/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.gui;

import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IItemList;
import com.the9grounds.aeadditions.container.ContainerTerminal;
import com.the9grounds.aeadditions.container.IFluidSelectorContainer;
import com.the9grounds.aeadditions.container.StorageType;
import com.the9grounds.aeadditions.gui.widget.FluidWidgetComparator;
import com.the9grounds.aeadditions.gui.widget.fluid.AbstractFluidWidget;
import com.the9grounds.aeadditions.gui.widget.fluid.IFluidSelectorGui;
import com.the9grounds.aeadditions.gui.widget.fluid.WidgetFluidSelector;
import com.the9grounds.aeadditions.network.packet.part.PacketTerminalOpenContainer;
import com.the9grounds.aeadditions.part.gas.PartGasTerminal;
import com.the9grounds.aeadditions.util.AEAConfigHandler;
import com.the9grounds.aeadditions.util.NetworkUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Mouse;

public class GuiTerminal
extends GuiContainer
implements IFluidSelectorGui {
    private PartGasTerminal terminal;
    private int currentScroll = 0;
    private GuiTextField searchbar;
    private List<AbstractFluidWidget> fluidWidgets = new ArrayList<AbstractFluidWidget>();
    private ResourceLocation guiTexture = new ResourceLocation("aeadditions", "textures/gui/terminalfluid.png");
    public IAEFluidStack currentFluid;
    private ContainerTerminal containerTerminal = (ContainerTerminal)this.field_147002_h;
    private StorageType type;

    public GuiTerminal(PartGasTerminal terminal, EntityPlayer player, StorageType type) {
        super((Container)new ContainerTerminal(terminal, player, type));
        this.terminal = terminal;
        this.field_146999_f = 176;
        this.field_147000_g = 204;
        this.type = type;
        NetworkUtil.sendToServer(new PacketTerminalOpenContainer(terminal));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float alpha, int sizeX, int sizeY) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.guiTexture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.searchbar.func_146194_f();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(I18n.func_74838_a((String)("com.the9grounds.aeadditions.part." + this.type.getName() + ".terminal.name")).replace("ME ", ""), 9, 6, 0);
        this.drawWidgets(mouseX, mouseY);
        if (this.currentFluid != null) {
            long currentFluidAmount = this.currentFluid.getStackSize();
            String amountToText = Long.toString(currentFluidAmount) + "mB";
            if (AEAConfigHandler.shortenedBuckets) {
                if (currentFluidAmount > 1000000000L) {
                    amountToText = Long.toString(currentFluidAmount / 1000000000L) + this.type.getMega() + "B";
                } else if (currentFluidAmount > 1000000L) {
                    amountToText = Long.toString(currentFluidAmount / 1000000L) + this.type.getKilo() + "B";
                } else if (currentFluidAmount > 9999L) {
                    amountToText = Long.toString(currentFluidAmount / 1000L) + this.type.getBuckets() + "B";
                }
            }
            this.field_146289_q.func_78276_b(I18n.func_74838_a((String)"com.the9grounds.aeadditions.tooltip.amount") + ": " + amountToText, 45, 91, 0);
            this.field_146289_q.func_78276_b(I18n.func_74838_a((String)"com.the9grounds.aeadditions.tooltip.fluid") + ": " + this.currentFluid.getFluid().getLocalizedName(this.currentFluid.getFluidStack()), 45, 101, 0);
        }
    }

    public void drawWidgets(int mouseX, int mouseY) {
        int listSize = this.fluidWidgets.size();
        if (!this.containerTerminal.getFluidStackList().isEmpty()) {
            int widgetIndex;
            block0: for (int y = 0; y < 4; ++y) {
                for (int x = 0; x < 9; ++x) {
                    widgetIndex = y * 9 + x + this.currentScroll * 9;
                    if (0 > widgetIndex || widgetIndex >= listSize) break block0;
                    AbstractFluidWidget widget = this.fluidWidgets.get(widgetIndex);
                    widget.drawWidget(x * 18 + 7, y * 18 + 17);
                }
            }
            for (int x = 0; x < 9; ++x) {
                for (int y = 0; y < 4 && 0 <= (widgetIndex = y * 9 + x) && widgetIndex < listSize && !this.fluidWidgets.get(widgetIndex).drawTooltip(x * 18 + 7, y * 18 - 1, mouseX, mouseY); ++y) {
                }
            }
            int deltaWheel = Mouse.getDWheel();
            if (deltaWheel > 0) {
                ++this.currentScroll;
            } else if (deltaWheel < 0) {
                --this.currentScroll;
            }
            if (this.currentScroll < 0) {
                this.currentScroll = 0;
            }
            if (listSize / 9 < 4 && this.currentScroll < listSize / 9 + 4) {
                this.currentScroll = 0;
            }
        }
    }

    @Override
    public IFluidSelectorContainer getContainer() {
        return this.containerTerminal;
    }

    @Override
    public IAEFluidStack getCurrentFluid() {
        return this.currentFluid;
    }

    public PartGasTerminal getTerminal() {
        return this.terminal;
    }

    @Override
    public int guiLeft() {
        return this.field_147003_i;
    }

    @Override
    public int guiTop() {
        return this.field_147009_r;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Mouse.getDWheel();
        this.updateFluids();
        Collections.sort(this.fluidWidgets, new FluidWidgetComparator());
        this.searchbar = new GuiTextField(0, this.field_146289_q, this.field_147003_i + 81, this.field_147009_r + 6, 88, 10){
            private int xPos;
            private int yPos;
            private int width;
            private int height;
            {
                this.xPos = 0;
                this.yPos = 0;
                this.width = 0;
                this.height = 0;
            }

            public boolean func_146192_a(int x, int y, int mouseBtn) {
                boolean flag;
                boolean bl = flag = x >= this.xPos && x < this.xPos + this.width && y >= this.yPos && y < this.yPos + this.height;
                if (flag && mouseBtn == 3) {
                    this.func_146180_a("");
                }
                return flag;
            }
        };
        this.searchbar.func_146185_a(false);
        this.searchbar.func_146195_b(true);
        this.searchbar.func_146203_f(15);
    }

    protected void func_73869_a(char key, int keyID) {
        if (keyID == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        this.searchbar.func_146201_a(key, keyID);
        this.updateFluids();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseBtn) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseBtn);
        this.searchbar.func_146192_a(mouseX, mouseY, mouseBtn);
        int listSize = this.fluidWidgets.size();
        for (int x = 0; x < 9; ++x) {
            for (int y = 0; y < 4; ++y) {
                int index = y * 9 + x;
                if (0 > index || index >= listSize) continue;
                AbstractFluidWidget widget = this.fluidWidgets.get(index);
                widget.mouseClicked(x * 18 + 7, y * 18 - 1, mouseX, mouseY);
            }
        }
    }

    public void updateFluids(IItemList<IAEFluidStack> fluidStacks) {
        this.containerTerminal.updateFluidList(fluidStacks);
        this.updateFluids();
    }

    public void updateFluids() {
        this.fluidWidgets = new ArrayList<AbstractFluidWidget>();
        for (IAEFluidStack stack : this.containerTerminal.getFluidStackList()) {
            FluidStack fluidStack = stack.getFluidStack();
            if (!fluidStack.getLocalizedName().toLowerCase().contains(this.searchbar.func_146179_b().toLowerCase()) || !this.type.canSee(stack.getFluidStack())) continue;
            this.fluidWidgets.add(new WidgetFluidSelector(this, stack));
        }
        this.updateSelectedFluid();
    }

    public void receiveSelectedFluid(Fluid currentFluid) {
        this.containerTerminal.receiveSelectedFluid(currentFluid);
        this.updateSelectedFluid();
    }

    public void updateSelectedFluid() {
        this.currentFluid = null;
        for (IAEFluidStack stack : this.containerTerminal.getFluidStackList()) {
            if (stack.getFluid() != this.containerTerminal.getSelectedFluid()) continue;
            this.currentFluid = stack;
        }
    }
}

