/*
 * Decompiled with CFR 0.152.
 */
package io.redstudioragnarok.redcore.vectors;

import io.netty.buffer.ByteBuf;
import io.redstudioragnarok.redcore.vectors.Vector3D;
import net.jafama.FastMath;
import net.minecraft.util.math.Vec3d;

@Deprecated
public final class Vector3F {
    public float x;
    public float y;
    public float z;

    public Vector3F() {
    }

    public Vector3F(float inputX, float inputY, float inputZ) {
        this.x = inputX;
        this.y = inputY;
        this.z = inputZ;
    }

    public Vector3F(Vector3F input) {
        this.x = input.x;
        this.y = input.y;
        this.z = input.z;
    }

    public Vector3F(Vector3D input) {
        this.x = (float)input.x;
        this.y = (float)input.y;
        this.z = (float)input.z;
    }

    public Vector3F(Vec3d input) {
        this.x = (float)input.field_72450_a;
        this.y = (float)input.field_72448_b;
        this.z = (float)input.field_72449_c;
    }

    public Vec3d toVec3d() {
        return new Vec3d((double)this.x, (double)this.y, (double)this.z);
    }

    public void zero() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
    }

    public void copy(Vector3F inputVector) {
        this.x = inputVector.x;
        this.y = inputVector.y;
        this.z = inputVector.z;
    }

    public void copy(Vector3D inputVector) {
        this.x = (float)inputVector.x;
        this.y = (float)inputVector.y;
        this.z = (float)inputVector.z;
    }

    public void set(float inputX, float inputY, float inputZ) {
        this.x = inputX;
        this.y = inputY;
        this.z = inputZ;
    }

    public void add(Vector3F inputVector) {
        this.x += inputVector.x;
        this.y += inputVector.y;
        this.z += inputVector.z;
    }

    public void add(Vector3D inputVector) {
        this.x += (float)inputVector.x;
        this.y += (float)inputVector.y;
        this.z += (float)inputVector.z;
    }

    public void scale(float multiplier) {
        this.x *= multiplier;
        this.y *= multiplier;
        this.z *= multiplier;
    }

    public void lerp(Vector3F input, float partialTicks, Vector3F target) {
        this.x = input.x + (target.x - input.x) * partialTicks;
        this.y = input.y + (target.y - input.y) * partialTicks;
        this.z = input.z + (target.z - input.z) * partialTicks;
    }

    public float distanceTo(Vector3F target) {
        float xDelta = target.x - this.x;
        float yDelta = target.y - this.y;
        float zDelta = target.z - this.z;
        return (float)FastMath.sqrt(xDelta * xDelta + yDelta * yDelta + zDelta * zDelta);
    }

    public float distanceTo(Vector3D target) {
        float xDelta = (float)(target.x - (double)this.x);
        float yDelta = (float)(target.y - (double)this.y);
        float zDelta = (float)(target.z - (double)this.z);
        return (float)FastMath.sqrt(xDelta * xDelta + yDelta * yDelta + zDelta * zDelta);
    }

    public void write(ByteBuf byteBuf) {
        byteBuf.writeFloat(this.x);
        byteBuf.writeFloat(this.y);
        byteBuf.writeFloat(this.z);
    }

    public void read(ByteBuf byteBuf) {
        this.x = byteBuf.readFloat();
        this.y = byteBuf.readFloat();
        this.z = byteBuf.readFloat();
    }
}

