/*
 * Decompiled with CFR 0.152.
 */
package dev.redstudio.redcore.logging;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class RedLogger {
    private static final Random RANDOM = new Random();
    private static final List<String> RECOMFORT_MESSAGES = new ArrayList<String>(Arrays.asList("Hey there, don't worry!", "Oh no! Even Minecraft mods need a hug sometimes.", "It's just a small hiccup! Let's get back to mining and crafting.", "Exception? More like an opportunity to make it even better!", "Think of this as a chance to take a quick snack break!", "Rome wasn't built in a day"));
    private static int maxLineLength;
    private final String modName;
    private final String newIssueLink;
    private final Logger logger;
    private final List<String> customRecomfortMessages = new ArrayList<String>();

    public RedLogger(String modName, String newIssueLink, Logger logger, String ... customRecomfortMessages) {
        this.modName = modName;
        this.newIssueLink = newIssueLink;
        this.logger = logger;
        this.customRecomfortMessages.addAll(Arrays.asList(customRecomfortMessages));
    }

    @Deprecated
    public RedLogger(String modName, URI newIssueLink, Logger logger, String ... customRecomfortMessages) {
        this.modName = modName;
        this.newIssueLink = newIssueLink.toString();
        this.logger = logger;
        this.customRecomfortMessages.addAll(Arrays.asList(customRecomfortMessages));
    }

    public void framed(String title, Level logLevel, String ... messages) {
        StringBuilder stringBuilder = new StringBuilder().append("\n");
        int maxLength = title.length();
        for (String message : messages) {
            maxLength = Math.max(maxLength, message.length());
        }
        int borderLength = maxLength + 4;
        String fullBorder = RedLogger.repeatString("=", borderLength);
        int halfBorderLength = (borderLength - title.length() - 2) / 2;
        String halfBorder = RedLogger.repeatString("=", halfBorderLength);
        stringBuilder.append(halfBorder).append(" ").append(title).append(" ").append(halfBorder);
        if (borderLength - title.length() - 2 * halfBorderLength == 1) {
            stringBuilder.append("=");
        }
        stringBuilder.append("\n");
        for (String message : messages) {
            stringBuilder.append(message).append("\n");
        }
        stringBuilder.append(fullBorder);
        this.logger.log(logLevel, stringBuilder.toString());
    }

    @Deprecated
    public void printFramedError(String category, String whatHappened, String whatNow, String ... additionalInformation) {
        this.framedError(category, whatHappened, whatNow, additionalInformation);
    }

    public void framedError(String category, String whatHappened, String whatNow, String ... additionalInformation) {
        ArrayList<String> formattedTextLines = new ArrayList<String>(Collections.singletonList(whatHappened));
        if (!whatNow.isEmpty() || additionalInformation.length != 0) {
            formattedTextLines.add("");
        }
        if (additionalInformation.length != 0) {
            formattedTextLines.addAll(Arrays.asList(additionalInformation));
        }
        if (!whatNow.isEmpty()) {
            if (additionalInformation.length != 0) {
                formattedTextLines.add("");
            }
            formattedTextLines.add(whatNow);
        }
        String header = this.modName + " had an exception, category:";
        ArrayList<String> combinedRecomfortMessages = new ArrayList<String>();
        combinedRecomfortMessages.addAll(this.customRecomfortMessages);
        combinedRecomfortMessages.addAll(RECOMFORT_MESSAGES);
        String recomfort = (String)combinedRecomfortMessages.get(RANDOM.nextInt(combinedRecomfortMessages.size()));
        RedLogger.getMaxLineLength(header, category, formattedTextLines, recomfort);
        String horizontalBorder = "+" + RedLogger.repeatString("-", maxLineLength + 2) + "+";
        String centeredHeader = RedLogger.centeredText(header);
        String centeredCategory = RedLogger.centeredText(category);
        String recomfortText = RedLogger.centeredText(recomfort);
        String formattedText = formattedTextLines.stream().map(line -> "| " + line + RedLogger.repeatString(" ", maxLineLength - line.length()) + " |").collect(Collectors.joining("\n"));
        String reportMessage = RedLogger.centeredText("Please report this error");
        String reportLink = RedLogger.centeredText(this.newIssueLink);
        String framedText = "\n" + horizontalBorder + "\n" + centeredHeader + "\n" + centeredCategory + "\n" + horizontalBorder + "\n" + recomfortText + "\n" + horizontalBorder + "\n" + formattedText + "\n" + horizontalBorder + "\n" + reportMessage + "\n" + reportLink + "\n" + horizontalBorder;
        this.logger.error(framedText);
    }

    private static void getMaxLineLength(String header, String category, List<String> lines, String recomfort) {
        maxLineLength = Math.max(Math.max(Math.max(Math.max(lines.stream().mapToInt(String::length).max().orElse(0), category.length()), lines.get(lines.size() - 1).length()), recomfort.length()), header.length());
    }

    private static String centeredText(String text) {
        int padding = (maxLineLength - text.length()) / 2;
        return "| " + RedLogger.repeatString(" ", padding) + text + RedLogger.repeatString(" ", maxLineLength - text.length() - padding) + " |";
    }

    private static String repeatString(String string, int count) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }
}

