/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.server;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import java.io.IOException;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import top.seraphjack.simplelogin.CommonProxy;
import top.seraphjack.simplelogin.SLConfig;
import top.seraphjack.simplelogin.SimpleLogin;
import top.seraphjack.simplelogin.server.PlayerLoginHandler;
import top.seraphjack.simplelogin.server.SLCommand;
import top.seraphjack.simplelogin.server.ServerSideEventHandler;
import top.seraphjack.simplelogin.server.storage.SLStorage;

public class ServerProxy
extends CommonProxy {
    @Override
    public void preInit() {
        super.preInit();
    }

    @Override
    public void serverStarting(FMLServerStartingEvent e) throws RuntimeException {
        super.serverStarting(e);
        SimpleLogin.logger.info("Server Starting");
        e.registerServerCommand((ICommand)new SLCommand());
        PlayerLoginHandler.instance();
        MinecraftForge.EVENT_BUS.register((Object)new ServerSideEventHandler());
        FMLCommonHandler.instance().bus().register((Object)new ServerSideEventHandler());
        SLStorage.initialize(SLConfig.server.storageMethod);
    }

    @Override
    public void serverStopping(FMLServerStoppingEvent e) throws IOException {
        super.serverStopping(e);
        SimpleLogin.logger.info("Server Stopping");
        PlayerLoginHandler.instance().stop();
        MinecraftForge.EVENT_BUS.unregister((Object)PlayerLoginHandler.instance());
        FMLCommonHandler.instance().bus().unregister((Object)PlayerLoginHandler.instance());
        SimpleLogin.logger.info("Saving all entries");
        SLStorage.instance().storageProvider.save();
        SLStorage.instance().storageProvider.close();
    }
}

