/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import top.seraphjack.simplelogin.server.storage.SLStorage;

public class MessageChangePassword
implements IMessage {
    private String oldPassword;
    private String newPassword;

    public MessageChangePassword() {
    }

    public MessageChangePassword(String oldPassword, String newPassword) {
        this.oldPassword = oldPassword;
        this.newPassword = newPassword;
    }

    public void fromBytes(ByteBuf buf) {
        this.oldPassword = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.newPassword = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.oldPassword);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.newPassword);
    }

    public static class MessageHandler
    implements IMessageHandler<MessageChangePassword, IMessage> {
        public IMessage onMessage(MessageChangePassword message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            String username = player.func_146103_bH().getName();
            if (SLStorage.instance().storageProvider.checkPassword(username, message.oldPassword)) {
                player.func_145747_a((IChatComponent)new ChatComponentText("Password changed successfully."));
                SLStorage.instance().storageProvider.changePassword(username, message.newPassword);
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentText("Wrong password."));
            }
            return null;
        }
    }
}

