/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.client.gui;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.client.gui.GuiButtonBookmark;
import com.emoniph.witchery.client.gui.GuiButtonJumpPage;
import com.emoniph.witchery.client.gui.GuiButtonNextPage;
import com.emoniph.witchery.item.ItemBook;
import com.emoniph.witchery.network.PacketItemUpdate;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiScreenBiomeBook
extends GuiScreen {
    private static final ResourceLocation field_110405_a = new ResourceLocation("textures/gui/book.png");
    private final EntityPlayer player;
    private final ItemStack itemstack;
    private int updateCount;
    private int bookImageWidth = 192;
    private int bookImageHeight = 192;
    private int pageIndex;
    private NBTTagList bookPages;
    private String bookTitle = "";
    private GuiButtonNextPage buttonNextPage;
    private GuiButtonNextPage buttonPreviousPage;
    private GuiButton buttonDone;
    private GuiButtonJumpPage buttonJumpPage1;
    private GuiButtonJumpPage buttonJumpPage2;
    private GuiButtonJumpPage buttonJumpPage3;
    private GuiButtonJumpPage buttonJumpPage4;
    private GuiButtonJumpPage buttonJumpPage5;
    private GuiButtonJumpPage buttonJumpPage6;
    private GuiButtonJumpPage buttonJumpPage7;
    ArrayList<BiomeGenBase> biomes = new ArrayList();
    ArrayList<Integer> sections = new ArrayList();
    ArrayList<String> sectionNames = new ArrayList();

    public GuiScreenBiomeBook(EntityPlayer player, ItemStack itemstack) {
        this.player = player;
        this.itemstack = itemstack;
        this.bookTitle = itemstack.func_82833_r();
        for (BiomeDictionary.Type biomeType : ItemBook.BIOME_TYPES) {
            this.addBiomes(biomeType);
        }
        this.pageIndex = ItemBook.getSelectedBiome(itemstack, this.biomes.size());
    }

    private void addBiomes(BiomeDictionary.Type biomeType) {
        BiomeGenBase[] biomesInType = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)biomeType);
        this.sections.add(this.biomes.size());
        this.sectionNames.add(Witchery.resource("witchery.book.biomes." + biomeType.toString().toLowerCase() + ".name"));
        for (int i = 0; i < biomesInType.length; ++i) {
            this.biomes.add(biomesInType[i]);
        }
    }

    private void storeCurrentPage() {
        ItemBook.setSelectedBiome(this.itemstack, this.pageIndex);
    }

    public void func_73876_c() {
        super.func_73876_c();
        ++this.updateCount;
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        int b0 = 2;
        int mid = (this.field_146294_l - this.bookImageWidth) / 2;
        this.buttonNextPage = new GuiButtonNextPage(1, mid + 120, b0 + 154, true);
        this.field_146292_n.add(this.buttonNextPage);
        this.buttonPreviousPage = new GuiButtonNextPage(2, mid + 38, b0 + 154, false);
        this.field_146292_n.add(this.buttonPreviousPage);
        for (int i = this.sections.size() - 1; i >= 0; --i) {
            GuiButtonBookmark button = new GuiButtonBookmark(3 + i, mid + 160, 12 * i + 10, this.sections.get(i), this.sectionNames.get(i));
            button.field_146124_l = true;
            this.field_146292_n.add(button);
        }
        this.updateButtons();
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        this.sendBookToServer(false);
    }

    private void updateButtons() {
        this.buttonNextPage.field_146125_m = this.pageIndex < this.biomes.size() - 1;
        this.buttonPreviousPage.field_146125_m = this.pageIndex > 0;
    }

    private void sendBookToServer(boolean par1) {
        if (this.player != null && this.pageIndex >= 0 && this.pageIndex < 1000 && this.player.field_71071_by.field_70461_c >= 0 && this.player.field_71071_by.func_70448_g() != null) {
            Witchery.packetPipeline.sendToServer(new PacketItemUpdate(this.player.field_71071_by.field_70461_c, this.pageIndex, this.player.field_71071_by.func_70448_g()));
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == 0) {
                this.field_146297_k.func_147108_a((GuiScreen)null);
            } else if (button.field_146127_k == 1) {
                if (this.pageIndex < this.biomes.size() - 1) {
                    ++this.pageIndex;
                    this.storeCurrentPage();
                }
            } else if (button.field_146127_k == 2) {
                if (this.pageIndex > 0) {
                    --this.pageIndex;
                    this.storeCurrentPage();
                }
            } else if (button instanceof GuiButtonBookmark) {
                GuiButtonBookmark but = (GuiButtonBookmark)button;
                this.pageIndex = but.nextPage;
                this.storeCurrentPage();
            }
            this.updateButtons();
        }
    }

    protected void func_73869_a(char par1, int par2) {
        super.func_73869_a(par1, par2);
    }

    public void func_73863_a(int par1, int par2, float par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(field_110405_a);
        int k = (this.field_146294_l - this.bookImageWidth) / 2;
        int b0 = 2;
        this.func_73729_b(k, b0, 0, 0, this.bookImageWidth, this.bookImageHeight);
        if (this.biomes.size() > 0 && this.pageIndex >= 0 && this.pageIndex < this.biomes.size()) {
            String pageNumberText = I18n.func_135052_a((String)"book.pageIndicator", (Object[])new Object[]{this.pageIndex + 1, this.biomes.size()});
            int pageNumberTextWitdh = this.field_146289_q.func_78256_a(pageNumberText);
            this.field_146289_q.func_78276_b(pageNumberText, k - pageNumberTextWitdh + this.bookImageWidth - 44, b0 + 16, 0);
            BiomeGenBase biome = this.biomes.get(this.pageIndex);
            int maxWidth = 116;
            boolean defaultColor = false;
            b0 = (byte)(b0 + this.drawSpiltString(biome.field_76791_y, k + 36, b0 + 32, 116, 0));
            b0 = (byte)(b0 + this.field_146289_q.field_78288_b);
            b0 = (byte)(b0 + this.drawSpiltString("> " + String.format(Witchery.resource("witchery.biomebook.rainfall"), Float.valueOf(biome.field_76751_G)), k + 36, b0 + 32, 116, 0));
            String temperatureFormat = Witchery.resource(biome.func_76736_e() ? "witchery.biomebook.temperaturehot" : "witchery.biomebook.temperature");
            b0 = (byte)(b0 + this.drawSpiltString("> " + String.format(temperatureFormat, Float.valueOf(biome.field_76750_F)), k + 36, b0 + 32, 116, 0));
            b0 = (byte)(b0 + this.drawSpiltString("> " + String.format(Witchery.resource("witchery.biomebook.snows"), this.toYesNo(biome.func_76746_c())), k + 36, b0 + 32, 116, 0));
            b0 = (byte)(b0 + this.drawSpiltString("> " + String.format(Witchery.resource("witchery.biomebook.lightning"), this.toYesNo(biome.func_76738_d())), k + 36, b0 + 32, 116, 0));
        }
        super.func_73863_a(par1, par2, par3);
    }

    private int drawSpiltString(String text, int x, int y, int maxWidth, int color) {
        int height = this.field_146289_q.func_78267_b(text, maxWidth);
        this.field_146289_q.func_78279_b(text, x, y, maxWidth, color);
        return height;
    }

    private String toYesNo(boolean val) {
        return Witchery.resource(val ? "witchery.yes" : "witchery.no");
    }

    public static void drawTexturedQuadFit(double x, double y, double width, double height, double zLevel) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(x + 0.0, y + height, zLevel, 0.0, 1.0);
        tessellator.func_78374_a(x + width, y + height, zLevel, 1.0, 1.0);
        tessellator.func_78374_a(x + width, y + 0.0, zLevel, 1.0, 0.0);
        tessellator.func_78374_a(x + 0.0, y + 0.0, zLevel, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    static ResourceLocation func_110404_g() {
        return field_110405_a;
    }
}

