/*
 * Decompiled with CFR 0.152.
 */
package glowredman.txloader;

import com.google.gson.JsonSyntaxException;
import glowredman.txloader.Asset;
import glowredman.txloader.JarHandler;
import glowredman.txloader.TXLoaderCore;
import glowredman.txloader.progress.IProgressBar;
import glowredman.txloader.progress.ProgressBarProxy;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

class RemoteHandler {
    static String latestRelease;
    static final Map<String, JVersion> VERSIONS;

    RemoteHandler() {
    }

    static boolean getVersions() {
        JVersionManifest manifest;
        try {
            manifest = RemoteHandler.downloadManifest();
        }
        catch (Exception e) {
            TXLoaderCore.LOGGER.error("Failed to get Minecraft versions!", (Throwable)e);
            return false;
        }
        latestRelease = manifest.latest.release;
        manifest.versions.forEach(rec$ -> ((JVersion)rec$).cache());
        TXLoaderCore.LOGGER.info("Successfully fetched Minecraft versions.");
        return true;
    }

    static void getAssets() {
        HashMap<JVersionDetails, Map> assets = new HashMap<JVersionDetails, Map>();
        HashMap<String, JVersionDetails> versionDetailsCache = new HashMap<String, JVersionDetails>();
        IProgressBar bar = ProgressBarProxy.get("Loading Remote Assets", TXLoaderCore.REMOTE_ASSETS.size());
        int added = 0;
        int skipped = 0;
        int failed = 0;
        for (Asset asset : TXLoaderCore.REMOTE_ASSETS) {
            Path jarPath;
            File file;
            block15: {
                bar.step(asset.getResourceLocation());
                file = asset.getFile();
                if (file.exists()) {
                    ++skipped;
                    continue;
                }
                String version = asset.getVersion();
                JVersionDetails versionDetails = versionDetailsCache.computeIfAbsent(version, RemoteHandler::downloadDetails);
                if (versionDetails == null) {
                    ++failed;
                    continue;
                }
                Asset.Source source = asset.getSource();
                if (source == Asset.Source.ASSET) {
                    JAsset jAsset = (JAsset)assets.computeIfAbsent(versionDetails, rec$ -> ((JVersionDetails)rec$).getAssets()).get(asset.resourceLocation);
                    if (jAsset == null) {
                        ++failed;
                        continue;
                    }
                    try {
                        jAsset.download(file);
                    }
                    catch (Exception e) {
                        TXLoaderCore.LOGGER.error("Failed to get asset! Path: " + asset.resourceLocation, (Throwable)e);
                        ++failed;
                    }
                    continue;
                }
                Path path = jarPath = source == Asset.Source.CLIENT ? JarHandler.CACHED_CLIENT_JARS.get(version) : JarHandler.CACHED_SERVER_JARS.get(version);
                if (jarPath == null) {
                    if (source == Asset.Source.CLIENT) {
                        try {
                            jarPath = versionDetails.downloads.client.downloadJar(version, "client.jar");
                            JarHandler.CACHED_CLIENT_JARS.put(version, jarPath);
                            break block15;
                        }
                        catch (Exception e) {
                            TXLoaderCore.LOGGER.error("Failed to download client jar and no cached jar was found", (Throwable)e);
                            ++failed;
                            continue;
                        }
                    }
                    try {
                        jarPath = versionDetails.downloads.server.downloadJar(version, "server.jar");
                        JarHandler.CACHED_SERVER_JARS.put(version, jarPath);
                    }
                    catch (Exception e) {
                        TXLoaderCore.LOGGER.error("Failed to download server jar and no cached jar was found", (Throwable)e);
                        ++failed;
                        continue;
                    }
                }
            }
            try {
                JarFile jarFile = new JarFile(jarPath.toFile());
                InputStream is = jarFile.getInputStream(jarFile.getJarEntry("assets/" + asset.resourceLocation));
                FileUtils.copyInputStreamToFile((InputStream)is, (File)file);
            }
            catch (Exception e) {
                TXLoaderCore.LOGGER.error("Failed to extract asset from jar! Path: " + asset.resourceLocation, (Throwable)e);
                ++failed;
                continue;
            }
            TXLoaderCore.LOGGER.debug("Successfully fetched {}", new Object[]{asset.resourceLocation});
            ++added;
        }
        TXLoaderCore.LOGGER.info("Successfully added {} assets. ({} skipped, {} failed)", new Object[]{added, skipped, failed});
        bar.pop();
    }

    private static JVersionManifest downloadManifest() throws JsonSyntaxException, IOException {
        URL manifestURL = new URL("https://launchermeta.mojang.com/mc/game/version_manifest.json");
        return (JVersionManifest)TXLoaderCore.GSON.fromJson(IOUtils.toString((URL)manifestURL, (Charset)StandardCharsets.UTF_8), JVersionManifest.class);
    }

    private static JVersionDetails downloadDetails(String version) {
        try {
            URL versionURL = new URL(VERSIONS.get(version).url);
            return (JVersionDetails)TXLoaderCore.GSON.fromJson(IOUtils.toString((URL)versionURL, (Charset)StandardCharsets.UTF_8), JVersionDetails.class);
        }
        catch (Exception e) {
            TXLoaderCore.LOGGER.error("Failed to get version details", (Throwable)e);
            return null;
        }
    }

    static {
        VERSIONS = new LinkedHashMap<String, JVersion>();
    }

    private static class JAsset {
        private String hash;

        private JAsset() {
        }

        private void download(File file) throws IOException {
            URL url = this.getURL();
            file.getParentFile().mkdirs();
            TXLoaderCore.LOGGER.info("Downloading {} to {}", new Object[]{url, file});
            FileUtils.copyURLToFile((URL)url, (File)file, (int)2000, (int)10000);
        }

        private URL getURL() throws MalformedURLException {
            StringBuilder sb = new StringBuilder(84);
            sb.append("https://resources.download.minecraft.net/");
            sb.append(this.hash, 0, 2);
            sb.append('/');
            sb.append(this.hash);
            return new URL(sb.toString());
        }
    }

    private static class JAssetIndex {
        private Map<String, JAsset> objects;

        private JAssetIndex() {
        }
    }

    private static class JDownloads {
        private JSourceDetails client;
        private JSourceDetails server;

        private JDownloads() {
        }
    }

    private static class JSourceDetails {
        private String url;

        private JSourceDetails() {
        }

        private Path downloadJar(String version, String fileName) throws IOException {
            File dir = JarHandler.txloaderCache.resolve(version).toFile();
            dir.mkdirs();
            File jar = new File(dir, fileName);
            TXLoaderCore.LOGGER.info("Downloading {} to {}", new Object[]{this.url, jar});
            FileUtils.copyURLToFile((URL)new URL(this.url), (File)jar, (int)2000, (int)10000);
            return jar.toPath();
        }
    }

    private static class JVersionDetails {
        private JSourceDetails assetIndex;
        private JDownloads downloads;

        private JVersionDetails() {
        }

        private Map<String, JAsset> getAssets() {
            try {
                URL assetsURL = new URL(this.assetIndex.url);
                return ((JAssetIndex)TXLoaderCore.GSON.fromJson(IOUtils.toString((URL)assetsURL, (Charset)StandardCharsets.UTF_8), JAssetIndex.class)).objects;
            }
            catch (Exception e) {
                TXLoaderCore.LOGGER.error("Failed to get asset index", (Throwable)e);
                return new HashMap<String, JAsset>();
            }
        }
    }

    private static class JVersion {
        private String id;
        private String url;

        private JVersion() {
        }

        private void cache() {
            VERSIONS.put(this.id, this);
        }
    }

    private static class JLatest {
        private String release;

        private JLatest() {
        }
    }

    private static class JVersionManifest {
        private JLatest latest;
        private List<JVersion> versions;

        private JVersionManifest() {
        }
    }
}

