/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.network.packet.client;

import appeng.api.config.RedstoneMode;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import thaumicenergistics.client.gui.GuiEssentiaIO;
import thaumicenergistics.common.network.NetworkHandler;
import thaumicenergistics.common.network.packet.client.ThEClientPacket;
import thaumicenergistics.common.registries.EnumCache;

public class Packet_C_EssentiaIOBus
extends ThEClientPacket {
    private static final byte MODE_SET_REDSTONE_CONTROLLED = 0;
    private static final byte MODE_SET_REDSTONE_MODE = 1;
    private static final byte MODE_SET_FILTER_SIZE = 2;
    private static final byte MODE_SEND_FULL_UPDATE = 3;
    private static final byte MODE_SEND_VOID_MODE = 4;
    private static final byte MODE_SEND_HAS_CRAFTINFG = 5;
    private static final byte MODE_SET_CRAFTING_MODE = 6;
    private RedstoneMode redstoneMode;
    private byte filterSize;
    private boolean redstoneControlled;
    private boolean isVoidAllowed;
    private boolean hasCraftingCard;
    private boolean craftingOnly;

    private static Packet_C_EssentiaIOBus newPacket(EntityPlayer player, byte mode) {
        Packet_C_EssentiaIOBus packet = new Packet_C_EssentiaIOBus();
        packet.player = player;
        packet.mode = mode;
        return packet;
    }

    public static void sendBusState(EntityPlayer player, RedstoneMode redstoneMode, byte filterSize, boolean redstoneControlled, boolean hasCraftingCard, boolean isCraftingOnly) {
        Packet_C_EssentiaIOBus packet = Packet_C_EssentiaIOBus.newPacket(player, (byte)3);
        packet.redstoneMode = redstoneMode;
        packet.filterSize = filterSize;
        packet.redstoneControlled = redstoneControlled;
        packet.hasCraftingCard = hasCraftingCard;
        packet.craftingOnly = isCraftingOnly;
        NetworkHandler.sendPacketToClient(packet);
    }

    public static void sendFilterSize(EntityPlayer player, byte filterSize) {
        Packet_C_EssentiaIOBus packet = Packet_C_EssentiaIOBus.newPacket(player, (byte)2);
        packet.filterSize = filterSize;
        NetworkHandler.sendPacketToClient(packet);
    }

    public static void sendRedstoneControlled(EntityPlayer player, boolean redstoneControlled) {
        Packet_C_EssentiaIOBus packet = Packet_C_EssentiaIOBus.newPacket(player, (byte)0);
        packet.redstoneControlled = redstoneControlled;
        NetworkHandler.sendPacketToClient(packet);
    }

    public static void sendHasCraftingCard(EntityPlayer player, boolean hasCraftingCard) {
        Packet_C_EssentiaIOBus packet = Packet_C_EssentiaIOBus.newPacket(player, (byte)5);
        packet.hasCraftingCard = hasCraftingCard;
        NetworkHandler.sendPacketToClient(packet);
    }

    public static void sendRedstoneMode(EntityPlayer player, RedstoneMode redstoneMode) {
        Packet_C_EssentiaIOBus packet = Packet_C_EssentiaIOBus.newPacket(player, (byte)1);
        packet.redstoneMode = redstoneMode;
        NetworkHandler.sendPacketToClient(packet);
    }

    public static void sendVoidMode(EntityPlayer player, boolean isVoidAllowed) {
        Packet_C_EssentiaIOBus packet = Packet_C_EssentiaIOBus.newPacket(player, (byte)4);
        packet.isVoidAllowed = isVoidAllowed;
        NetworkHandler.sendPacketToClient(packet);
    }

    public static void sendCraftingMode(EntityPlayer player, boolean isCraftingOnly) {
        Packet_C_EssentiaIOBus packet = Packet_C_EssentiaIOBus.newPacket(player, (byte)6);
        packet.craftingOnly = isCraftingOnly;
        NetworkHandler.sendPacketToClient(packet);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void wrappedExecute() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (!(gui instanceof GuiEssentiaIO)) {
            return;
        }
        switch (this.mode) {
            case 0: {
                ((GuiEssentiaIO)gui).onReceiveRedstoneControlled(this.redstoneControlled);
                break;
            }
            case 1: {
                ((GuiEssentiaIO)gui).onReceiveRedstoneMode(this.redstoneMode);
                break;
            }
            case 2: {
                ((GuiEssentiaIO)gui).onReceiveFilterSize(this.filterSize);
                break;
            }
            case 3: {
                ((GuiEssentiaIO)gui).onReceiveRedstoneMode(this.redstoneMode);
                ((GuiEssentiaIO)gui).onReceiveRedstoneControlled(this.redstoneControlled);
                ((GuiEssentiaIO)gui).onReceiveFilterSize(this.filterSize);
                ((GuiEssentiaIO)gui).onReceiveHasCrafting(this.hasCraftingCard);
                ((GuiEssentiaIO)gui).onReceiveCraftingOnly(this.craftingOnly);
                break;
            }
            case 4: {
                ((GuiEssentiaIO)gui).onServerSendVoidMode(this.isVoidAllowed);
                break;
            }
            case 6: {
                ((GuiEssentiaIO)gui).onReceiveCraftingOnly(this.craftingOnly);
                break;
            }
            case 5: {
                ((GuiEssentiaIO)gui).onReceiveHasCrafting(this.hasCraftingCard);
            }
        }
    }

    @Override
    public void readData(ByteBuf stream) {
        switch (this.mode) {
            case 0: {
                this.redstoneControlled = stream.readBoolean();
                break;
            }
            case 1: {
                this.redstoneMode = EnumCache.AE_REDSTONE_MODES[stream.readByte()];
                break;
            }
            case 2: {
                this.filterSize = stream.readByte();
                break;
            }
            case 3: {
                this.redstoneControlled = stream.readBoolean();
                this.redstoneMode = EnumCache.AE_REDSTONE_MODES[stream.readByte()];
                this.filterSize = stream.readByte();
                this.hasCraftingCard = stream.readBoolean();
                this.craftingOnly = stream.readBoolean();
                break;
            }
            case 4: {
                this.isVoidAllowed = stream.readBoolean();
                break;
            }
            case 6: {
                this.craftingOnly = stream.readBoolean();
                break;
            }
            case 5: {
                this.hasCraftingCard = stream.readBoolean();
            }
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        switch (this.mode) {
            case 0: {
                stream.writeBoolean(this.redstoneControlled);
                break;
            }
            case 1: {
                stream.writeByte((int)((byte)this.redstoneMode.ordinal()));
                break;
            }
            case 2: {
                stream.writeByte((int)this.filterSize);
                break;
            }
            case 3: {
                stream.writeBoolean(this.redstoneControlled);
                stream.writeByte((int)((byte)this.redstoneMode.ordinal()));
                stream.writeByte((int)this.filterSize);
                stream.writeBoolean(this.hasCraftingCard);
                stream.writeBoolean(this.craftingOnly);
                break;
            }
            case 4: {
                stream.writeBoolean(this.isVoidAllowed);
                break;
            }
            case 6: {
                stream.writeBoolean(this.craftingOnly);
                break;
            }
            case 5: {
                stream.writeBoolean(this.hasCraftingCard);
            }
        }
    }
}

