/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.items;

import appeng.api.AEApi;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.items.storage.ItemBasicStorageCell;
import appeng.util.IterationCounter;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import thaumcraft.api.research.ScanResult;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.items.relics.ItemThaumometer;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.playerdata.PacketScannedToServer;
import thaumcraft.common.lib.research.ScanManager;
import thaumcraft.common.lib.utils.EntityUtils;
import thaumicenergistics.common.registries.ThEStrings;

public class ItemCellMicroscope
extends ItemThaumometer {
    List<ItemStack> startCells = new ArrayList<ItemStack>();
    TileEntity cellSaveManager = null;

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.icon = ir.func_94245_a("thaumcraft:blank");
    }

    public String func_77658_a() {
        return ThEStrings.Item_Cell_Microscope.getUnlocalized();
    }

    public String func_77667_c(ItemStack itemStack) {
        return this.func_77658_a();
    }

    public int func_77626_a(ItemStack itemstack) {
        return 50;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer p) {
        ArrayList<ItemStack> cells;
        if (world.field_72995_K && (cells = this.doScan(stack, world, p, 0)).size() != 0) {
            this.startCells = cells;
        }
        p.func_71008_a(stack, this.func_77626_a(stack));
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer p, int count) {
        if (p.field_70170_p.field_72995_K && Objects.equals(p.func_70005_c_(), Minecraft.func_71410_x().field_71439_g.func_70005_c_())) {
            ArrayList<ItemStack> cells = this.doScan(stack, p.field_70170_p, p, count);
            if (cells.size() != 0 && cells.equals(this.startCells)) {
                if (count <= 5) {
                    p.func_71034_by();
                    this.startCells.clear();
                    for (ItemStack cell : cells) {
                        this.doCellScan(p, cell);
                    }
                }
                if (count % 2 == 0) {
                    p.field_70170_p.func_72980_b(p.field_70165_t, p.field_70163_u, p.field_70161_v, "thaumcraft:cameraticks", 0.2f, 0.45f + (float)count / 50.0f + p.field_70170_p.field_73012_v.nextFloat() * 0.1f, false);
                }
            } else {
                this.startCells.clear();
            }
        }
    }

    private void doCellScan(EntityPlayer p, ItemStack cell) {
        IMEInventoryHandler inv = AEApi.instance().registries().cell().getCellInventory(cell, (ISaveProvider)this.cellSaveManager, StorageChannel.ITEMS);
        IItemList itemList = inv.getAvailableItems(AEApi.instance().storage().createItemList(), IterationCounter.fetchNewId());
        for (IAEItemStack i : itemList) {
            ScanResult sr = new ScanResult(1, Item.func_150891_b((Item)i.getItem()), i.getItemDamage(), null, "");
            if (!ScanManager.isValidScanTarget((EntityPlayer)p, (ScanResult)sr, (String)"@")) continue;
            ScanManager.completeScan((EntityPlayer)p, (ScanResult)sr, (String)"@");
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketScannedToServer(sr, p, "@"));
        }
    }

    private ArrayList<ItemStack> doScan(ItemStack stack, World world, EntityPlayer p, int count) {
        ArrayList<ItemStack> cellsOutput = new ArrayList<ItemStack>();
        Entity pointedEntity = EntityUtils.getPointedEntity((World)p.field_70170_p, (Entity)p, (double)0.5, (double)10.0, (float)0.0f, (boolean)true);
        if (pointedEntity != null && pointedEntity instanceof EntityItem && ((EntityItem)pointedEntity).func_92059_d().func_77973_b() instanceof ItemBasicStorageCell) {
            MovingObjectPosition mop = this.func_77621_a(p.field_70170_p, p, true);
            try {
                Thaumcraft.proxy.blockRunes(world, (double)mop.field_72311_b, (double)mop.field_72312_c + 0.5, (double)mop.field_72309_d, 0.3f, 0.3f, 0.7f + world.field_73012_v.nextFloat() * 0.7f, 15, -0.03f);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cellSaveManager = null;
            cellsOutput.add(((EntityItem)pointedEntity).func_92059_d());
            return cellsOutput;
        }
        MovingObjectPosition lookingAtBlock = Minecraft.func_71410_x().field_71476_x;
        TileEntity blockAtPos = world.func_147438_o(lookingAtBlock.field_72311_b, lookingAtBlock.field_72312_c, lookingAtBlock.field_72309_d);
        if (blockAtPos instanceof ICellContainer) {
            ((ICellContainer)blockAtPos).getCellArray(StorageChannel.ITEMS);
            IInventory inv = (IInventory)blockAtPos;
            this.cellSaveManager = blockAtPos;
            try {
                Thaumcraft.proxy.blockRunes(world, (double)lookingAtBlock.field_72311_b, (double)lookingAtBlock.field_72312_c, (double)lookingAtBlock.field_72309_d, 0.3f, 0.3f, 0.7f + world.field_73012_v.nextFloat() * 0.7f, 15, -0.03f);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack itemStack = inv.func_70301_a(i);
                if (itemStack == null) continue;
                cellsOutput.add(itemStack);
            }
        }
        return cellsOutput;
    }

    public void func_77615_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer, int par4) {
        super.func_77615_a(par1ItemStack, par2World, par3EntityPlayer, par4);
        this.startCells.clear();
    }
}

