/*
 * Decompiled with CFR 0.152.
 */
package thaumicboots.api;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ISpecialArmor;
import thaumicboots.api.ItemBoots;
import thaumicboots.main.utils.TabThaumicBoots;

public class ItemElectricBoots
extends ItemBoots
implements IElectricItem,
ISpecialArmor {
    public int maxCharge;
    public int energyPerDamage;
    public double transferLimit;
    public boolean provideEnergy;
    public double damageAbsorptionRatio;

    public ItemElectricBoots(ItemArmor.ArmorMaterial par2EnumArmorMaterial, int par3, int par4) {
        super(par2EnumArmorMaterial, par3, par4);
        this.func_77637_a(TabThaumicBoots.tabThaumicBoots);
        this.func_77655_b(this.unlocalisedName);
    }

    @Override
    protected void setBootsData() {
        super.setBootsData();
        this.maxCharge = 0;
        this.energyPerDamage = 0;
        this.provideEnergy = false;
        this.transferLimit = 0.0;
        this.damageAbsorptionRatio = 0.5;
    }

    public int getEnergyPerDamage() {
        return this.energyPerDamage;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return this.provideEnergy;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public float getEMTNanoSpeed() {
        return 0.275f;
    }

    public float getEMTQuantumSpeed() {
        return 0.51f;
    }

    public double getDamageAbsorptionRatio() {
        return this.damageAbsorptionRatio;
    }

    public double getBaseAbsorptionRatio() {
        return 0.15;
    }

    @Override
    protected float computeBonus(ItemStack itemStack, EntityPlayer player) {
        int ticks = player.field_71071_by.func_70440_f((int)0).field_77990_d.func_74762_e("runTicks");
        float bonus = this.runBonus + (float)(ticks / 5) * 0.003f;
        if (ElectricItem.manager.getCharge(itemStack) == 0.0) {
            bonus = 0.0f;
        } else if (player.func_70090_H()) {
            bonus /= 4.0f;
        }
        return bonus;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        ItemStack itemStack = new ItemStack((Item)this, 1);
        if (this.getChargedItem(itemStack) == this) {
            ItemStack charged = new ItemStack((Item)this, 1);
            ElectricItem.manager.charge(charged, 2.147483647E9, Integer.MAX_VALUE, true, false);
            itemList.add(charged);
        }
        if (this.getEmptyItem(itemStack) == this) {
            itemList.add(new ItemStack((Item)this, 1, this.func_77612_l()));
        }
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        int energyPerDamage = this.getEnergyPerDamage();
        double damageLimit = energyPerDamage <= 0 ? 0.0 : 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage;
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, (int)damageLimit);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        if (ElectricItem.manager.getCharge(armor) >= (double)this.getEnergyPerDamage()) {
            return (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio());
        }
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        ElectricItem.manager.discharge(stack, (double)(damage * this.getEnergyPerDamage()), Integer.MAX_VALUE, true, false, false);
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    @Override
    public void applyFinalBonus(float bonus, EntityPlayer player, ItemStack itemStack) {
        if (ElectricItem.manager.getCharge(itemStack) == 0.0) {
            bonus *= 0.0f;
        }
        bonus = (float)((double)bonus * itemStack.field_77990_d.func_74769_h("speed"));
        this.applyBonus(player, bonus, itemStack);
    }
}

