/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.structure;

import com.google.common.collect.Iterables;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public interface IStructureElementChain<T>
extends IStructureElement<T> {
    public IStructureElement<T>[] fallbacks();

    @Override
    default public boolean check(T t, World world, int x, int y, int z) {
        for (IStructureElement<T> fallback : this.fallbacks()) {
            if (!fallback.check(t, world, x, y, z)) continue;
            return true;
        }
        return false;
    }

    @Override
    default public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
        for (IStructureElement<T> fallback : this.fallbacks()) {
            if (!fallback.spawnHint(t, world, x, y, z, trigger)) continue;
            return true;
        }
        return false;
    }

    @Override
    default public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
        for (IStructureElement<T> fallback : this.fallbacks()) {
            if (!fallback.placeBlock(t, world, x, y, z, trigger)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    default public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
        Predicate<ItemStack> predicate = null;
        ArrayList<Iterable<ItemStack>> is = new ArrayList<Iterable<ItemStack>>();
        for (IStructureElement<T> fallback : this.fallbacks()) {
            IStructureElement.BlocksToPlace e = fallback.getBlocksToPlace(t, world, x, y, z, trigger, env);
            if (e == null) continue;
            predicate = predicate == null ? e.getPredicate() : predicate.or(e.getPredicate());
            Iterable<ItemStack> stacks = e.getStacks();
            if (stacks == null) continue;
            is.add(stacks);
        }
        if (predicate == null) {
            return null;
        }
        return new IStructureElement.BlocksToPlace(predicate, Iterables.concat(is));
    }

    @Override
    default public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, IItemSource s, EntityPlayerMP actor, Consumer<IChatComponent> chatter) {
        boolean haveSkip = false;
        ArrayList bufferedNoise = new ArrayList();
        block4: for (IStructureElement<T> fallback : this.fallbacks()) {
            IStructureElement.PlaceResult result = fallback.survivalPlaceBlock(t, world, x, y, z, trigger, s, actor, bufferedNoise::add);
            switch (result) {
                case REJECT: {
                    continue block4;
                }
                case SKIP: {
                    haveSkip = true;
                    continue block4;
                }
                default: {
                    return result;
                }
            }
        }
        bufferedNoise.forEach(chatter);
        return haveSkip ? IStructureElement.PlaceResult.SKIP : IStructureElement.PlaceResult.REJECT;
    }

    @Override
    default public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
        boolean haveSkip = false;
        ArrayList bufferedNoise = new ArrayList();
        block4: for (IStructureElement<T> fallback : this.fallbacks()) {
            IStructureElement.PlaceResult result = fallback.survivalPlaceBlock(t, world, x, y, z, trigger, env.withChatter(bufferedNoise::add));
            switch (result) {
                case REJECT: {
                    continue block4;
                }
                case SKIP: {
                    haveSkip = true;
                    continue block4;
                }
                default: {
                    return result;
                }
            }
        }
        bufferedNoise.forEach(env.getChatter());
        return haveSkip ? IStructureElement.PlaceResult.SKIP : IStructureElement.PlaceResult.REJECT;
    }
}

