/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.event;

import com.gtnewhorizon.structurelib.event.BlockChangeListener;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class BlockChangeNotifier {
    private static final List<BlockChangeListener> listeners = new ArrayList<BlockChangeListener>();

    public static synchronized void addListener(BlockChangeListener listener) {
        listeners.add(listener);
    }

    public static void onBlockChange(World world, Chunk chunk, int x, int y, int z, Block oldBlock, Block newBlock, int oldMeta, int newMeta) {
        if (oldBlock == newBlock && oldMeta == newMeta) {
            return;
        }
        if (chunk == null) {
            chunk = world.func_72938_d(x, z);
        }
        int numListeners = listeners.size();
        for (int i = 0; i < numListeners; ++i) {
            BlockChangeListener listener = listeners.get(i);
            listener.onBlockChange(world, chunk, x, y, z, oldBlock, newBlock, oldMeta, newMeta);
        }
    }
}

