/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.personalspace.gui;

import java.awt.Rectangle;
import java.util.List;
import me.eigenraven.personalspace.gui.Icons;
import me.eigenraven.personalspace.gui.WButton;
import me.eigenraven.personalspace.world.DimensionConfig;

public class WCycleButton
extends WButton {
    final List<ButtonState> stateList;
    int currentIndex = 0;
    int length = 0;

    public WCycleButton(Rectangle position, String text, boolean dropShadow, int color, List<ButtonState> states, int initialIndex, Runnable onClick) {
        super(position, text, dropShadow, color, Icons.CHECKMARK, onClick);
        this.stateList = states;
        this.length = this.stateList.size();
        this.currentIndex = initialIndex;
        this.buttonIcon = this.stateList.get((int)this.currentIndex).icon;
    }

    public DimensionConfig.DaylightCycle getState() {
        return this.stateList.get((int)this.currentIndex).cycle;
    }

    void next() {
        if (++this.currentIndex >= this.length) {
            this.currentIndex = 0;
        }
        this.buttonIcon = this.stateList.get((int)this.currentIndex).icon;
    }

    @Override
    protected boolean mouseClickedImpl(int x, int y, int button) {
        this.next();
        return super.mouseClickedImpl(x, y, button);
    }

    public static class ButtonState {
        public final DimensionConfig.DaylightCycle cycle;
        public final Icons icon;

        ButtonState(DimensionConfig.DaylightCycle cycle, Icons icon) {
            this.cycle = cycle;
            this.icon = icon;
        }
    }
}

