/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.tileentity;

import java.io.File;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.ResourceLocation;
import pcl.opensecurity.OpenSecurity;
import pcl.opensecurity.client.sounds.ISoundTile;
import pcl.opensecurity.tileentity.TileEntityMachineBase;

public class TileEntityAlarm
extends TileEntityMachineBase
implements SimpleComponent,
ISoundTile {
    public static String cName = "OSAlarm";
    public Boolean shouldPlay = false;
    public String soundName = "klaxon1";
    public float volume = 1.0f;
    public Boolean computerPlaying = false;

    public TileEntityAlarm() {
        this.setSound(this.soundName);
    }

    public String getComponentName() {
        return "os_alarm";
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
    }

    @Override
    public boolean shouldPlaySound() {
        return this.shouldPlay;
    }

    @Override
    public String getSoundName() {
        return this.soundName;
    }

    @Override
    public float getVolume() {
        return this.volume;
    }

    @Override
    public ResourceLocation setSound(String sound) {
        this.setSoundRes(new ResourceLocation("opensecurity:" + sound));
        return this.getSoundRes();
    }

    public void setShouldStart(boolean b) {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_145844_m();
        this.shouldPlay = true;
    }

    public void setShouldStop(boolean b) {
        this.shouldPlay = false;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_145844_m();
    }

    @Callback
    public Object[] greet(Context context, Arguments args) {
        return new Object[]{"Lasciate ogne speranza, voi ch'intrate"};
    }

    @Callback(doc="function(range:integer):string; Sets the range in blocks of the alarm", direct=true)
    public Object[] setRange(Context context, Arguments args) {
        Float newVolume = Float.valueOf(args.checkInteger(0));
        if (newVolume.floatValue() >= 15.0f && newVolume.floatValue() <= 150.0f) {
            this.volume = newVolume.floatValue() / 15.0f + 0.5f;
            return new Object[]{"Success"};
        }
        return new Object[]{"Error, range should be between 15-150"};
    }

    @Callback(doc="function(soundName:string):string; Sets the alarm sound", direct=true)
    public Object[] setAlarm(Context context, Arguments args) {
        String alarm = args.checkString(0);
        File f = new File("mods" + File.separator + "OpenSecurity" + File.separator + "sounds" + File.separator + "alarms" + File.separator + alarm + ".ogg");
        if (f.exists() && !f.isDirectory()) {
            this.soundName = alarm;
            this.setSound(alarm);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_145844_m();
            return new Object[]{"Success"};
        }
        return new Object[]{"Fail"};
    }

    @Callback(doc="function():string; Activates the alarm", direct=true)
    public Object[] activate(Context context, Arguments args) {
        this.setShouldStart(true);
        this.computerPlaying = true;
        return new Object[]{"Ok"};
    }

    @Callback(doc="function():table; Returns a table of Alarm Sounds", direct=true)
    public Object[] listSounds(Context context, Arguments args) {
        return new Object[]{OpenSecurity.alarmList};
    }

    @Callback(doc="function(int:x, int:y, int:z, string:sound, float:range(1-10 recommended)):string; Plays sound at x y z", direct=true)
    public Object[] playSoundAt(Context context, Arguments args) {
        if (OpenSecurity.enableplaySoundAt) {
            int x = args.checkInteger(0);
            int y = args.checkInteger(1);
            int z = args.checkInteger(2);
            String sound = args.checkString(3);
            float range = args.checkInteger(4);
            this.field_145850_b.func_72908_a((double)x, (double)y, (double)z, sound, range / 15.0f + 0.5f, 1.0f);
            return new Object[]{"Ok"};
        }
        return new Object[]{"Disabled"};
    }

    @Callback(doc="function():string; Deactivates the alarm", direct=true)
    public Object[] deactivate(Context context, Arguments args) {
        this.setShouldStop(true);
        this.computerPlaying = false;
        return new Object[]{"Ok"};
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCom = new NBTTagCompound();
        this.func_145841_b(tagCom);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, tagCom);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound tagCom = packet.func_148857_g();
        this.func_145839_a(tagCom);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readSyncableDataFromNBT(tag);
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.writeSyncableDataToNBT(tag);
    }

    private void readSyncableDataFromNBT(NBTTagCompound tag) {
        this.shouldPlay = tag.func_74767_n("isPlayingSound");
        this.soundName = tag.func_74779_i("alarmName");
        this.volume = tag.func_74760_g("volume");
        this.computerPlaying = tag.func_74767_n("computerPlaying");
    }

    private void writeSyncableDataToNBT(NBTTagCompound tag) {
        tag.func_74757_a("isPlayingSound", this.shouldPlay.booleanValue());
        tag.func_74778_a("alarmName", this.soundName);
        tag.func_74776_a("volume", this.volume);
        tag.func_74757_a("computerPlaying", this.computerPlaying.booleanValue());
    }

    @Override
    public boolean playSoundNow() {
        return false;
    }
}

