/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.neid.mixins;

import com.gtnewhorizons.neid.Common;
import com.gtnewhorizons.neid.NEIDConfig;
import com.gtnewhorizons.neid.mixins.TargetedMod;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

public enum Mixins {
    VANILLA_STARTUP(new Builder("Start Vanilla").addTargetedMod(TargetedMod.VANILLA).setSide(Side.BOTH).setPhase(Phase.EARLY).addMixinClasses("minecraft.MixinWorld", "minecraft.MixinExtendedBlockStorage", "minecraft.MixinStatList", "minecraft.MixinBlockFire", "minecraft.MixinS22PacketMultiBlockChange", "minecraft.MixinS23PacketBlockChange", "minecraft.MixinS24PacketBlockAction", "minecraft.MixinS26PacketMapChunkBulk", "minecraft.MixinItemInWorldManager", "minecraft.MixinAnvilChunkLoader", "minecraft.MixinBlock").setApplyIf(() -> true)),
    VANILLA_STARTUP_ONLY_WITHOUT_THERMOS(new Builder("Start Vanilla No Thermos").addTargetedMod(TargetedMod.VANILLA).setSide(Side.BOTH).setPhase(Phase.EARLY).addMixinClasses("minecraft.MixinS21PacketChunkData").setApplyIf(() -> !Common.thermosTainted)),
    VANILLA_STARTUP_ONLY_WITH_THERMOS(new Builder("Start Vanilla with Thermos").addTargetedMod(TargetedMod.VANILLA).setSide(Side.BOTH).setPhase(Phase.EARLY).addMixinClasses("minecraft.MixinS21PacketChunkDataThermosTainted").setApplyIf(() -> Common.thermosTainted)),
    VANILLA_STARTUP_CLIENT(new Builder("Start Vanilla Client").addTargetedMod(TargetedMod.VANILLA).setSide(Side.CLIENT).setPhase(Phase.EARLY).addMixinClasses("minecraft.client.MixinRenderGlobal", "minecraft.client.MixinNetHandlerPlayClient", "minecraft.client.MixinPlayerControllerMP", "minecraft.client.MixinChunk").setApplyIf(() -> true)),
    VANILLA_STARTUP_DATAWATCHER(new Builder("Start Vanilla DataWatcher").addTargetedMod(TargetedMod.VANILLA).setSide(Side.BOTH).setPhase(Phase.EARLY).addMixinClasses("minecraft.MixinDataWatcher").setApplyIf(() -> NEIDConfig.ExtendDataWatcher));

    private final List<String> mixinClasses;
    private final List<TargetedMod> targetedMods;
    private final List<TargetedMod> excludedMods;
    private final Supplier<Boolean> applyIf;
    private final Phase phase;
    private final Side side;

    private Mixins(Builder builder) {
        this.mixinClasses = builder.mixinClasses;
        this.targetedMods = builder.targetedMods;
        this.excludedMods = builder.excludedMods;
        this.applyIf = builder.applyIf;
        this.phase = builder.phase;
        this.side = builder.side;
        if (this.mixinClasses.isEmpty()) {
            throw new RuntimeException("No mixin class specified for Mixin : " + this.name());
        }
        if (this.targetedMods.isEmpty()) {
            throw new RuntimeException("No targeted mods specified for Mixin : " + this.name());
        }
        if (this.applyIf == null) {
            throw new RuntimeException("No ApplyIf function specified for Mixin : " + this.name());
        }
        if (this.phase == null) {
            throw new RuntimeException("No Phase specified for Mixin : " + this.name());
        }
        if (this.side == null) {
            throw new RuntimeException("No Side function specified for Mixin : " + this.name());
        }
    }

    public static List<String> getEarlyMixins(Set<String> loadedCoreMods) {
        ArrayList<String> mixins = new ArrayList<String>();
        ArrayList<String> notLoading = new ArrayList<String>();
        for (Mixins mixin : Mixins.values()) {
            if (mixin.phase != Phase.EARLY) continue;
            if (mixin.shouldLoad(loadedCoreMods, Collections.emptySet())) {
                mixins.addAll(mixin.mixinClasses);
                continue;
            }
            notLoading.addAll(mixin.mixinClasses);
        }
        return mixins;
    }

    public static List<String> getLateMixins(Set<String> loadedMods) {
        ArrayList<String> mixins = new ArrayList<String>();
        ArrayList<String> notLoading = new ArrayList<String>();
        for (Mixins mixin : Mixins.values()) {
            if (mixin.phase != Phase.LATE) continue;
            if (mixin.shouldLoad(Collections.emptySet(), loadedMods)) {
                mixins.addAll(mixin.mixinClasses);
                continue;
            }
            notLoading.addAll(mixin.mixinClasses);
        }
        return mixins;
    }

    private boolean shouldLoadSide() {
        return this.side == Side.BOTH || this.side == Side.SERVER && FMLLaunchHandler.side().isServer() || this.side == Side.CLIENT && FMLLaunchHandler.side().isClient();
    }

    private boolean allModsLoaded(List<TargetedMod> targetedMods, Set<String> loadedCoreMods, Set<String> loadedMods) {
        if (targetedMods.isEmpty()) {
            return false;
        }
        for (TargetedMod target : targetedMods) {
            if (target == TargetedMod.VANILLA) continue;
            if (!loadedCoreMods.isEmpty() && target.coreModClass != null && !loadedCoreMods.contains(target.coreModClass)) {
                return false;
            }
            if (loadedMods.isEmpty() || target.modId == null || loadedMods.contains(target.modId)) continue;
            return false;
        }
        return true;
    }

    private boolean noModsLoaded(List<TargetedMod> targetedMods, Set<String> loadedCoreMods, Set<String> loadedMods) {
        if (targetedMods.isEmpty()) {
            return true;
        }
        for (TargetedMod target : targetedMods) {
            if (target == TargetedMod.VANILLA) continue;
            if (!loadedCoreMods.isEmpty() && target.coreModClass != null && loadedCoreMods.contains(target.coreModClass)) {
                return false;
            }
            if (loadedMods.isEmpty() || target.modId == null || !loadedMods.contains(target.modId)) continue;
            return false;
        }
        return true;
    }

    private boolean shouldLoad(Set<String> loadedCoreMods, Set<String> loadedMods) {
        return this.shouldLoadSide() && this.applyIf.get() != false && this.allModsLoaded(this.targetedMods, loadedCoreMods, loadedMods) && this.noModsLoaded(this.excludedMods, loadedCoreMods, loadedMods);
    }

    private static enum Phase {
        EARLY,
        LATE;

    }

    private static enum Side {
        BOTH,
        CLIENT,
        SERVER;

    }

    private static class Builder {
        private final String name;
        private final List<String> mixinClasses = new ArrayList<String>();
        private final List<TargetedMod> targetedMods = new ArrayList<TargetedMod>();
        private final List<TargetedMod> excludedMods = new ArrayList<TargetedMod>();
        private Supplier<Boolean> applyIf = null;
        private Phase phase = null;
        private Side side = null;

        public Builder(String name) {
            this.name = name;
        }

        public Builder addMixinClasses(String ... mixinClasses) {
            this.mixinClasses.addAll(Arrays.asList(mixinClasses));
            return this;
        }

        public Builder setPhase(Phase phase) {
            if (this.phase != null) {
                throw new RuntimeException("Trying to define Phase twice for " + this.name);
            }
            this.phase = phase;
            return this;
        }

        public Builder setSide(Side side) {
            if (this.side != null) {
                throw new RuntimeException("Trying to define Side twice for " + this.name);
            }
            this.side = side;
            return this;
        }

        public Builder setApplyIf(Supplier<Boolean> applyIf) {
            this.applyIf = applyIf;
            return this;
        }

        public Builder addTargetedMod(TargetedMod mod) {
            this.targetedMods.add(mod);
            return this;
        }

        public Builder addExcludedMod(TargetedMod mod) {
            this.excludedMods.add(mod);
            return this;
        }
    }
}

