/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.navigator.api.xaero.waypoints;

import com.gtnewhorizons.navigator.api.model.SupportedMods;
import com.gtnewhorizons.navigator.api.model.layers.InteractableLayerManager;
import com.gtnewhorizons.navigator.api.model.waypoints.Waypoint;
import com.gtnewhorizons.navigator.api.model.waypoints.WaypointManager;
import com.gtnewhorizons.navigator.api.xaero.waypoints.WaypointWithDimension;
import java.util.Map;
import xaero.common.minimap.waypoints.WaypointsManager;

public class XaeroWaypointManager
extends WaypointManager {
    public static int lastId;
    protected final int waypointId = lastId++;
    private WaypointWithDimension xWaypoint;
    private String symbol = "";

    public XaeroWaypointManager(InteractableLayerManager layerManager) {
        super(layerManager, SupportedMods.XaeroMiniMap);
    }

    public XaeroWaypointManager(InteractableLayerManager layerManager, String symbol) {
        this(layerManager);
        this.symbol = symbol;
    }

    @Override
    public void clearActiveWaypoint() {
        this.xWaypoint = null;
        this.getCustomWaypoints().remove(this.waypointId);
    }

    @Override
    public boolean hasWaypoint() {
        return this.xWaypoint != null;
    }

    public WaypointWithDimension getXWaypoint() {
        return this.xWaypoint;
    }

    @Override
    public void updateActiveWaypoint(Waypoint waypoint) {
        if (!this.hasWaypoint() || waypoint.blockX != this.xWaypoint.getX() || waypoint.blockY != this.xWaypoint.getY() || waypoint.blockZ != this.xWaypoint.getZ() || waypoint.dimensionId != this.xWaypoint.getDimID()) {
            this.xWaypoint = new WaypointWithDimension(waypoint.blockX, waypoint.blockY, waypoint.blockZ, waypoint.label, this.getSymbol(waypoint), 15, waypoint.dimensionId);
            this.getCustomWaypoints().put(this.waypointId, this.xWaypoint);
        }
    }

    protected Map<Integer, xaero.common.minimap.waypoints.Waypoint> getCustomWaypoints() {
        return WaypointsManager.getCustomWaypoints((String)"navigator");
    }

    protected String getSymbol(Waypoint waypoint) {
        if (!this.symbol.isEmpty()) {
            return this.symbol;
        }
        return waypoint.label.substring(0, 1);
    }
}

