/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets.textfield;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.api.IMathValue;
import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IStringValue;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetTextFieldTheme;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.math.Constant;
import com.cleanroommc.modularui.utils.math.MathBuilder;
import com.cleanroommc.modularui.value.StringValue;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.value.sync.ValueSyncHandler;
import com.cleanroommc.modularui.widgets.textfield.BaseTextFieldWidget;
import java.awt.Point;
import java.text.ParsePosition;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class TextFieldWidget
extends BaseTextFieldWidget<TextFieldWidget> {
    private IStringValue<?> stringValue;
    private Function<String, String> validator = val -> val;
    private boolean numbers = false;
    protected boolean changedMarkedColor = false;

    public static IMathValue parse(String num) {
        try {
            return MathBuilder.INSTANCE.parse(num);
        }
        catch (Exception e) {
            ModularUI.LOGGER.error("Failed to parse {} in TextFieldWidget", new Object[]{num});
            ModularUI.LOGGER.catching((Throwable)e);
            return new Constant(0.0);
        }
    }

    @Override
    public void onInit() {
        super.onInit();
        if (this.stringValue == null) {
            this.stringValue = new StringValue("");
        }
        this.setText(this.stringValue.getStringValue());
        if (!this.hasTooltip()) {
            this.tooltipBuilder(tooltip -> tooltip.addLine(IKey.str(this.getText())));
        }
        if (!this.changedMarkedColor) {
            this.renderer.setMarkedColor(this.getMarkedColor());
        }
    }

    public int getMarkedColor() {
        WidgetTheme theme = this.getWidgetTheme(this.getContext().getTheme());
        if (theme instanceof WidgetTextFieldTheme) {
            WidgetTextFieldTheme textFieldTheme = (WidgetTextFieldTheme)theme;
            return textFieldTheme.getMarkedColor();
        }
        return ITheme.getDefault().getTextFieldTheme().getMarkedColor();
    }

    @Override
    public boolean isValidSyncHandler(SyncHandler syncHandler) {
        if (syncHandler instanceof IStringValue) {
            IStringValue iStringValue = (IStringValue)((Object)syncHandler);
            if (syncHandler instanceof ValueSyncHandler) {
                ValueSyncHandler valueSyncHandler = (ValueSyncHandler)syncHandler;
                this.stringValue = iStringValue;
                valueSyncHandler.setChangeListener(() -> {
                    this.markTooltipDirty();
                    this.setText(this.stringValue.getValue().toString());
                });
                return true;
            }
        }
        return false;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.isFocused()) {
            String s = this.stringValue.getStringValue();
            if (!this.getText().equals(s)) {
                this.setText(s);
            }
        }
    }

    @Override
    public void drawText(ModularGuiContext context) {
        this.renderer.setSimulate(false);
        this.renderer.setPos(this.getArea().getPadding().left, 0);
        this.renderer.setScale(this.scale);
        this.renderer.setAlignment(this.textAlignment, -1.0f, this.getArea().height);
        this.renderer.draw(this.handler.getText());
        this.getScrollData().setScrollSize(Math.max(0, (int)this.renderer.getLastWidth()));
    }

    @Override
    public void drawForeground(ModularGuiContext context) {
        if (this.hasTooltip() && this.getScrollData().isScrollBarActive(this.getScrollArea()) && this.isHoveringFor(this.getTooltip().getShowUpTimer())) {
            this.getTooltip().draw(this.getContext());
        }
    }

    @NotNull
    public String getText() {
        if (this.handler.getText().isEmpty()) {
            return "";
        }
        if (this.handler.getText().size() > 1) {
            throw new IllegalStateException("TextFieldWidget can only have one line!");
        }
        return this.handler.getText().get(0);
    }

    public void setText(@NotNull String text) {
        if (this.handler.getText().isEmpty()) {
            this.handler.getText().add(text);
        } else {
            this.handler.getText().set(0, text);
        }
    }

    @Override
    public void onFocus(ModularGuiContext context) {
        super.onFocus(context);
        Point main = this.handler.getMainCursor();
        if (main.x == 0) {
            this.handler.setCursor(main.y, this.getText().length(), true, true);
        }
    }

    @Override
    public void onRemoveFocus(ModularGuiContext context) {
        super.onRemoveFocus(context);
        if (this.handler.getText().isEmpty()) {
            this.handler.getText().add(this.validator.apply(""));
        } else if (this.handler.getText().size() == 1) {
            this.handler.getText().set(0, this.validator.apply(this.handler.getText().get(0)));
            this.markTooltipDirty();
        } else {
            throw new IllegalStateException("TextFieldWidget can only have one line!");
        }
        this.stringValue.setStringValue(this.numbers ? format.parse(this.getText(), new ParsePosition(0)).toString() : this.getText());
    }

    @Override
    public boolean canHover() {
        return true;
    }

    public TextFieldWidget setMaxLength(int maxLength) {
        this.handler.setMaxCharacters(maxLength);
        return this;
    }

    public TextFieldWidget setPattern(Pattern pattern) {
        this.handler.setPattern(pattern);
        return this;
    }

    @Override
    public TextFieldWidget setTextColor(int textColor) {
        this.renderer.setColor(textColor);
        this.changedTextColor = true;
        return this;
    }

    public TextFieldWidget setMarkedColor(int color) {
        this.renderer.setMarkedColor(color);
        this.changedMarkedColor = true;
        return this;
    }

    public TextFieldWidget setValidator(Function<String, String> validator) {
        this.validator = validator;
        return this;
    }

    public TextFieldWidget setNumbersLong(Function<Long, Long> validator) {
        this.numbers = true;
        this.setValidator(val -> {
            long num = val.isEmpty() ? 0L : (long)TextFieldWidget.parse(val).doubleValue();
            return format.format(validator.apply(num));
        });
        return this;
    }

    public TextFieldWidget setNumbers(Function<Integer, Integer> validator) {
        this.numbers = true;
        return this.setValidator(val -> {
            int num = val.isEmpty() ? 0 : (int)TextFieldWidget.parse(val).doubleValue();
            return format.format(validator.apply(num));
        });
    }

    public TextFieldWidget setNumbersDouble(Function<Double, Double> validator) {
        this.numbers = true;
        return this.setValidator(val -> {
            double num = val.isEmpty() ? 0.0 : TextFieldWidget.parse(val).doubleValue();
            return format.format(validator.apply(num));
        });
    }

    public TextFieldWidget setNumbers(Supplier<Integer> min, Supplier<Integer> max) {
        return this.setNumbers(val -> Math.min((Integer)max.get(), Math.max((Integer)min.get(), val)));
    }

    public TextFieldWidget setNumbersLong(Supplier<Long> min, Supplier<Long> max) {
        return this.setNumbersLong(val -> Math.min((Long)max.get(), Math.max((Long)min.get(), val)));
    }

    public TextFieldWidget setNumbers(int min, int max) {
        return this.setNumbers(val -> Math.min(max, Math.max(min, val)));
    }

    public TextFieldWidget setNumbers() {
        return this.setNumbers(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public TextFieldWidget value(IStringValue<?> stringValue) {
        this.stringValue = stringValue;
        this.setValue(stringValue);
        return this;
    }
}

