/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets.slot;

import com.cleanroommc.modularui.utils.item.IItemHandlerLong;
import com.cleanroommc.modularui.utils.item.IItemStackLong;
import com.cleanroommc.modularui.utils.item.ItemStackLong;
import com.cleanroommc.modularui.widgets.slot.IOnSlotChangedLong;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import com.google.common.primitives.Ints;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModularSlotLong
extends ModularSlot {
    private final IItemHandlerLong itemHandler;
    private final int index;
    private IOnSlotChangedLong changeListener = IOnSlotChangedLong.DEFAULT;
    private Predicate<IItemStackLong> filter = item -> true;

    public ModularSlotLong(IItemHandlerLong handler, int index) {
        this(handler, index, false);
    }

    public ModularSlotLong(IItemHandlerLong itemHandler, int index, boolean phantom) {
        super(itemHandler, index, phantom);
        this.itemHandler = itemHandler;
        this.index = index;
    }

    public boolean isItemValidLong(IItemStackLong stack) {
        return stack != null && this.filter.test(stack);
    }

    @Override
    public boolean func_75214_a(@Nullable ItemStack stack) {
        return this.isItemValidLong(stack == null ? null : new ItemStackLong(stack)) && super.func_75214_a(stack);
    }

    public IItemStackLong getStackLong() {
        return this.itemHandler.getStackInSlotLong(this.index);
    }

    public void putStackLong(IItemStackLong stack) {
        if (ItemStackLong.areItemStacksEqual(stack, this.getStackLong())) {
            return;
        }
        this.itemHandler.setStackInSlotLong(this.index, stack);
    }

    public long getSlotStackLimitLong() {
        return this.itemHandler.getSlotLimitLong(this.index);
    }

    @Override
    public int func_75219_a() {
        return Ints.saturatedCast((long)this.getSlotStackLimitLong());
    }

    public long getItemStackLimitLong(@NotNull IItemStackLong stack) {
        return this.getSlotStackLimitLong();
    }

    @Override
    public int getItemStackLimit(@NotNull ItemStack stack) {
        return Ints.saturatedCast((long)this.getItemStackLimitLong(new ItemStackLong(stack)));
    }

    public void onSlotChangedRealLong(IItemStackLong stack, boolean onlyChangedAmount, boolean client, boolean init) {
        this.changeListener.onChange(stack, onlyChangedAmount, client, init);
    }

    @Override
    public void onSlotChangedReal(ItemStack itemStack, boolean onlyChangedAmount, boolean client, boolean init) {
        this.onSlotChangedRealLong(new ItemStackLong(itemStack), onlyChangedAmount, client, init);
        super.onSlotChangedReal(itemStack, onlyChangedAmount, client, init);
    }

    public ModularSlotLong changeListener(IOnSlotChangedLong changeListener) {
        if (changeListener == null) {
            this.changeListener = IOnSlotChangedLong.DEFAULT;
            return this;
        }
        this.changeListener = changeListener;
        return this;
    }

    public ModularSlotLong filterLong(Predicate<IItemStackLong> filter) {
        this.filter = filter;
        if (this.filter == null) {
            this.filter = item -> true;
        }
        return this;
    }
}

