/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.item;

import com.cleanroommc.modularui.utils.item.IItemHandler;
import com.cleanroommc.modularui.utils.item.IItemHandlerModifiable;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class SlotItemHandler
extends Slot {
    private static IInventory emptyInventory = new InventoryBasic("[Null]", true, 0);
    private final IItemHandler itemHandler;
    private final int index;

    public SlotItemHandler(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
        super(emptyInventory, index, xPosition, yPosition);
        this.itemHandler = itemHandler;
        this.index = index;
    }

    public boolean func_75214_a(ItemStack stack) {
        if (stack != null && this.itemHandler.isItemValid(this.index, stack)) {
            ItemStack remainder;
            IItemHandler handler = this.getItemHandler();
            if (handler instanceof IItemHandlerModifiable) {
                IItemHandlerModifiable handlerModifiable = (IItemHandlerModifiable)handler;
                ItemStack currentStack = handlerModifiable.getStackInSlot(this.index);
                handlerModifiable.setStackInSlot(this.index, null);
                remainder = handlerModifiable.insertItem(this.index, stack, true);
                handlerModifiable.setStackInSlot(this.index, currentStack);
            } else {
                remainder = handler.insertItem(this.index, stack, true);
            }
            return remainder != null ? remainder.field_77994_a < stack.field_77994_a : stack.field_77994_a > 0;
        }
        return false;
    }

    public ItemStack func_75211_c() {
        return this.itemHandler.getStackInSlot(this.index);
    }

    public void func_75215_d(ItemStack stack) {
        ((IItemHandlerModifiable)this.getItemHandler()).setStackInSlot(this.index, stack);
        this.func_75218_e();
    }

    public void func_75220_a(ItemStack p_75220_1_, ItemStack p_75220_2_) {
    }

    public int func_75219_a() {
        return this.itemHandler.getSlotLimit(this.index);
    }

    public int getItemStackLimit(ItemStack stack) {
        int maxInput;
        ItemStack maxAdd = stack.func_77946_l();
        maxAdd.field_77994_a = maxInput = stack.func_77976_d();
        IItemHandler handler = this.getItemHandler();
        ItemStack currentStack = handler.getStackInSlot(this.index);
        if (handler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable handlerModifiable = (IItemHandlerModifiable)handler;
            handlerModifiable.setStackInSlot(this.index, null);
            ItemStack remainder = handlerModifiable.insertItem(this.index, maxAdd, true);
            handlerModifiable.setStackInSlot(this.index, currentStack);
            return remainder != null ? maxInput - remainder.field_77994_a : maxInput;
        }
        ItemStack remainder = handler.insertItem(this.index, maxAdd, true);
        int current = currentStack != null ? currentStack.field_77994_a : 0;
        int added = remainder != null ? maxInput - remainder.field_77994_a : maxInput;
        return current + added;
    }

    public boolean func_82869_a(EntityPlayer playerIn) {
        return this.getItemHandler().getStackInSlot(this.index) == null || this.getItemHandler().extractItem(this.index, 1, true) != null;
    }

    @Nullable
    public ItemStack func_75209_a(int amount) {
        return this.getItemHandler().extractItem(this.index, amount, false);
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public boolean isSameInventory(Slot other) {
        SlotItemHandler slotHand;
        return other instanceof SlotItemHandler && (slotHand = (SlotItemHandler)other).getItemHandler() == this.itemHandler;
    }

    public boolean func_75217_a(IInventory inventory, int invIndex) {
        return this.itemHandler.isSlotFromInventory(this.index, inventory, invIndex);
    }
}

