/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.fakeworld;

import com.cleanroommc.modularui.utils.fakeworld.BlockInfo;
import com.cleanroommc.modularui.utils.fakeworld.BlockPosUtil;
import com.cleanroommc.modularui.utils.fakeworld.DummyWorld;
import com.cleanroommc.modularui.utils.fakeworld.ISchema;
import com.google.common.collect.AbstractIterator;
import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;

public class MapSchema
implements ISchema {
    private final World world;
    private final Object2ObjectOpenHashMap<BlockPos, BlockInfo> blocks = new Object2ObjectOpenHashMap();
    private BiPredicate<BlockPos, BlockInfo> renderFilter;
    private final BlockPos origin;
    private final Vector3d center;

    public MapSchema(Map<BlockPos, BlockInfo> blocks) {
        this(blocks, null);
    }

    public MapSchema(Map<BlockPos, BlockInfo> blocks, BiPredicate<BlockPos, BlockInfo> renderFilter) {
        this.world = new DummyWorld();
        this.renderFilter = renderFilter;
        BlockPos min = new BlockPos(BlockPosUtil.MAX.x, BlockPosUtil.MAX.y, BlockPosUtil.MAX.z);
        BlockPos max = new BlockPos(BlockPosUtil.MIN.x, BlockPosUtil.MAX.y, BlockPosUtil.MAX.z);
        if (!blocks.isEmpty()) {
            for (Map.Entry<BlockPos, BlockInfo> entry : blocks.entrySet()) {
                if (entry.getValue().getBlock() == Blocks.field_150350_a) continue;
                this.blocks.put((Object)entry.getKey(), (Object)entry.getValue());
                entry.getValue().apply(this.world, entry.getKey());
                BlockPosUtil.setMin(min, entry.getKey());
                BlockPosUtil.setMax(max, entry.getKey());
            }
        } else {
            min.set(0, 0, 0);
            max.set(0, 0, 0);
        }
        this.origin = min;
        this.center = BlockPosUtil.getCenterD(min, max);
    }

    @Override
    public void setRenderFilter(@Nullable BiPredicate<BlockPos, BlockInfo> renderFilter) {
        this.renderFilter = renderFilter;
    }

    @Override
    @Nullable
    public BiPredicate<BlockPos, BlockInfo> getRenderFilter() {
        return this.renderFilter;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public Vector3d getFocus() {
        return this.center;
    }

    @Override
    public BlockPos getOrigin() {
        return this.origin;
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<BlockPos, BlockInfo>> iterator() {
        return new AbstractIterator<Map.Entry<BlockPos, BlockInfo>>(){
            private final ObjectIterator<Object2ObjectMap.Entry<BlockPos, BlockInfo>> it;
            {
                this.it = MapSchema.this.blocks.object2ObjectEntrySet().fastIterator();
            }

            protected Map.Entry<BlockPos, BlockInfo> computeNext() {
                while (this.it.hasNext()) {
                    Map.Entry entry = (Map.Entry)this.it.next();
                    if (MapSchema.this.renderFilter != null && !MapSchema.this.renderFilter.test((BlockPos)entry.getKey(), (BlockInfo)entry.getValue())) continue;
                    return entry;
                }
                return (Map.Entry)this.endOfData();
            }
        };
    }

    public static class Builder {
        private final Object2ObjectOpenHashMap<BlockPos, BlockInfo> blocks = new Object2ObjectOpenHashMap();
        private BiPredicate<BlockPos, BlockInfo> renderFilter;

        public Builder add(BlockPos pos, Block block) {
            return this.add(pos, block, 0, null);
        }

        public Builder add(BlockPos pos, Block block, int meta) {
            return this.add(pos, block, meta, null);
        }

        public Builder add(BlockPos pos, Block block, int blockMeta, TileEntity customTile) {
            if (block == Blocks.field_150350_a) {
                return this;
            }
            this.blocks.put((Object)pos, (Object)new BlockInfo(block, blockMeta, customTile));
            return this;
        }

        public Builder add(BlockPos pos, BlockInfo blockInfo) {
            this.blocks.put((Object)pos, (Object)blockInfo.toImmutable());
            return this;
        }

        public Builder add(Iterable<BlockPos> posList, Function<BlockPos, BlockInfo> function) {
            for (BlockPos pos : posList) {
                BlockInfo info = function.apply(pos).toImmutable();
                this.add(pos, info);
            }
            return this;
        }

        public Builder add(Map<BlockPos, BlockInfo> blocks) {
            this.blocks.putAll(blocks);
            return this;
        }

        public Builder setRenderFilter(BiPredicate<BlockPos, BlockInfo> renderFilter) {
            this.renderFilter = renderFilter;
            return this;
        }

        public MapSchema build() {
            if (this.renderFilter == null) {
                return new MapSchema((Map<BlockPos, BlockInfo>)this.blocks);
            }
            return new MapSchema((Map<BlockPos, BlockInfo>)this.blocks, this.renderFilter);
        }
    }
}

