/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.api.inventory.ClickType;
import com.cleanroommc.modularui.mixins.early.minecraft.ContainerAccessor;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.screen.ContainerCustomizer;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.value.sync.ModularSyncManager;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import com.cleanroommc.modularui.widgets.slot.SlotGroup;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModularContainer
extends Container {
    private final EntityPlayer player;
    private final ModularSyncManager syncManager;
    private boolean init = true;
    private final List<ModularSlot> slots = new ArrayList<ModularSlot>();
    private final List<ModularSlot> shiftClickSlots = new ArrayList<ModularSlot>();
    private ContainerCustomizer containerCustomizer;
    @SideOnly(value=Side.CLIENT)
    private ModularScreen optionalScreen;

    public static ModularContainer getCurrent(EntityPlayer player) {
        Container container = player.field_71070_bA;
        if (container instanceof ModularContainer) {
            ModularContainer container2 = (ModularContainer)container;
            return container2;
        }
        return null;
    }

    public ModularContainer(EntityPlayer player, PanelSyncManager panelSyncManager, String mainPanelName) {
        this.player = player;
        this.syncManager = new ModularSyncManager(this);
        this.syncManager.construct(mainPanelName, panelSyncManager);
        this.containerCustomizer = panelSyncManager.getContainerCustomizer();
        if (this.containerCustomizer == null) {
            this.containerCustomizer = new ContainerCustomizer();
        }
        this.containerCustomizer.initialize(this);
        this.sortShiftClickSlots();
    }

    @SideOnly(value=Side.CLIENT)
    public ModularContainer(ContainerCustomizer containerCustomizer) {
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.syncManager = null;
        this.containerCustomizer = containerCustomizer != null ? containerCustomizer : new ContainerCustomizer();
        this.containerCustomizer.initialize(this);
    }

    @SideOnly(value=Side.CLIENT)
    void construct(ModularScreen screen) {
        this.optionalScreen = screen;
    }

    @SideOnly(value=Side.CLIENT)
    public ModularScreen getScreen() {
        if (this.optionalScreen == null) {
            throw new NullPointerException("ModularScreen is not yet initialised!");
        }
        return this.optionalScreen;
    }

    public ContainerAccessor acc() {
        return (ContainerAccessor)((Object)this);
    }

    public void func_75132_a(ICrafting player) {
        super.func_75132_a(player);
        if (this.syncManager != null) {
            this.syncManager.onOpen();
        }
    }

    public void func_75134_a(@NotNull EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (this.syncManager != null) {
            this.syncManager.onClose();
        }
        this.containerCustomizer.onContainerClosed();
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.syncManager != null) {
            this.syncManager.detectAndSendChanges(this.init);
        }
        this.init = false;
    }

    private void sortShiftClickSlots() {
        this.shiftClickSlots.sort(Comparator.comparingInt(slot -> Objects.requireNonNull(slot.getSlotGroup()).getShiftClickPriority()));
    }

    public void func_75131_a(ItemStack[] items) {
        if (this.field_75151_b.size() != items.length) {
            ModularUI.LOGGER.error("Here are {} slots, but expected {}", new Object[]{this.field_75151_b.size(), items.length});
        }
        for (int i = 0; i < Math.min(this.field_75151_b.size(), items.length); ++i) {
            this.func_75139_a(i).func_75215_d(items[i]);
        }
    }

    @ApiStatus.Internal
    public void registerSlot(String panelName, ModularSlot slot) {
        SlotGroup slotGroup;
        if (this.field_75151_b.contains((Object)slot)) {
            throw new IllegalArgumentException("Tried to register slot which already exists!");
        }
        this.func_75146_a(slot);
        this.slots.add(slot);
        if (slot.getSlotGroupName() != null) {
            slotGroup = this.getSyncManager().getSlotGroup(panelName, slot.getSlotGroupName());
            if (slotGroup == null) {
                ModularUI.LOGGER.throwing((Throwable)new IllegalArgumentException("SlotGroup '" + slot.getSlotGroupName() + "' is not registered!"));
                return;
            }
            slot.slotGroup(slotGroup);
        }
        if (slot.getSlotGroup() != null && (slotGroup = slot.getSlotGroup()).allowShiftTransfer()) {
            this.shiftClickSlots.add(slot);
            if (!this.init) {
                this.sortShiftClickSlots();
            }
        }
    }

    @Contract(value="_, null, null -> fail")
    @NotNull
    @ApiStatus.Internal
    public SlotGroup validateSlotGroup(String panelName, @Nullable String slotGroupName, @Nullable SlotGroup slotGroup) {
        if (slotGroup != null) {
            if (this.getSyncManager().getSlotGroup(panelName, slotGroup.getName()) == null) {
                throw new IllegalArgumentException("Slot group is not registered in the GUI.");
            }
            return slotGroup;
        }
        if (slotGroupName != null) {
            slotGroup = this.getSyncManager().getSlotGroup(panelName, slotGroupName);
            if (slotGroup == null) {
                throw new IllegalArgumentException("Can't find slot group for name " + slotGroupName);
            }
            return slotGroup;
        }
        throw new IllegalArgumentException("Either the slot group or the name must not be null!");
    }

    public ModularSyncManager getSyncManager() {
        if (this.syncManager == null) {
            throw new IllegalStateException("GuiSyncManager is not available for client only GUI's.");
        }
        return this.syncManager;
    }

    public boolean isClient() {
        return this.syncManager == null || NetworkUtils.isClient(this.player);
    }

    public boolean isClientOnly() {
        return this.syncManager == null;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public ModularSlot getModularSlot(int index) {
        return this.slots.get(index);
    }

    public List<ModularSlot> getShiftClickSlots() {
        return Collections.unmodifiableList(this.shiftClickSlots);
    }

    public boolean func_75145_c(@NotNull EntityPlayer playerIn) {
        return true;
    }

    @Nullable
    public ItemStack func_75144_a(int slotId, int mouseButton, int clickTypeIn, @NotNull EntityPlayer player) {
        return this.containerCustomizer.slotClick(slotId, mouseButton, ClickType.fromNumber(clickTypeIn), player);
    }

    @Nullable
    public ItemStack superSlotClick(int slotId, int mouseButton, @NotNull ClickType clickTypeIn, @NotNull EntityPlayer player) {
        return super.func_75144_a(slotId, mouseButton, clickTypeIn.toNumber(), player);
    }

    @Nullable
    public ItemStack func_82846_b(@NotNull EntityPlayer playerIn, int index) {
        return this.containerCustomizer.transferStackInSlot(playerIn, index);
    }

    @Nullable
    public ItemStack superTransferStackInSlot(@NotNull EntityPlayer playerIn, int index) {
        return this.containerCustomizer.transferStackInSlot(playerIn, index);
    }

    public boolean func_94530_a(@Nullable ItemStack stack, @NotNull Slot slotIn) {
        return this.containerCustomizer.canMergeSlot(stack, slotIn);
    }

    public boolean superCanMergeSlot(@Nullable ItemStack stack, @NotNull Slot slotIn) {
        return super.func_94530_a(stack, slotIn);
    }

    protected boolean func_75135_a(@NotNull ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        return this.containerCustomizer.mergeItemStack(stack, startIndex, endIndex, reverseDirection);
    }

    public boolean superMergeItemStack(@NotNull ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        return super.func_75135_a(stack, startIndex, endIndex, reverseDirection);
    }
}

