/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable.text;

import com.cleanroommc.modularui.api.IThemeApi;
import com.cleanroommc.modularui.api.drawable.IHoverable;
import com.cleanroommc.modularui.api.drawable.IIcon;
import com.cleanroommc.modularui.api.drawable.ITextLine;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;

public class ComposedLine
implements ITextLine {
    private final List<Object> elements;
    private final int width;
    private final int height;
    private float lastX;
    private float lastY;

    public ComposedLine(List<Object> elements, int width, int height) {
        this.elements = elements;
        this.width = width;
        this.height = height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight(FontRenderer fr) {
        return this.height == fr.field_78288_b ? this.height : this.height + 1;
    }

    @Override
    public void draw(GuiContext context, FontRenderer fr, float x, float y, int color, boolean shadow) {
        this.lastX = x;
        this.lastY = y;
        for (Object o : this.elements) {
            float drawY;
            if (o instanceof String) {
                String s = (String)o;
                drawY = (float)this.getHeight(fr) / 2.0f - (float)fr.field_78288_b / 2.0f;
                fr.func_85187_a(s, (int)x, (int)(y + drawY), color, shadow);
                x += (float)fr.func_78256_a(s);
                continue;
            }
            if (!(o instanceof IIcon)) continue;
            IIcon icon = (IIcon)o;
            drawY = (float)this.getHeight(fr) / 2.0f - (float)icon.getHeight() / 2.0f;
            icon.draw(context, (int)x, (int)(y + drawY), icon.getWidth(), icon.getHeight(), IThemeApi.get().getDefaultTheme().getFallback());
            if (icon instanceof IHoverable) {
                IHoverable hoverable = (IHoverable)icon;
                hoverable.setRenderedAt((int)x, (int)(y + drawY));
            }
            x += (float)icon.getWidth();
        }
    }

    @Override
    public Object getHoveringElement(FontRenderer fr, int x, int y) {
        int h0 = this.getHeight(fr);
        if ((float)y < this.lastY || (float)y > this.lastY + (float)h0) {
            return null;
        }
        if ((float)x < this.lastX || (float)x > this.lastX + (float)this.getWidth()) {
            return Boolean.FALSE;
        }
        float x0 = (float)x - this.lastX;
        float x1 = 0.0f;
        float y0 = (float)y - this.lastY;
        for (Object o : this.elements) {
            float h;
            float w;
            if (o instanceof String) {
                String s = (String)o;
                w = fr.func_78256_a(s);
                h = fr.field_78288_b;
            } else {
                if (!(o instanceof IIcon)) continue;
                IIcon icon = (IIcon)o;
                w = icon.getWidth();
                h = icon.getWidth();
            }
            if (x0 > x1 && x0 < x1 + w) {
                if (h < (float)h0) {
                    int lower = (int)((float)h0 / 2.0f - h / 2.0f);
                    int upper = (int)((float)h0 / 2.0f + h / 2.0f - 1.0f);
                    if (y0 < (float)lower || y0 > (float)upper) {
                        return Boolean.FALSE;
                    }
                }
                return o;
            }
            x1 += w;
        }
        return null;
    }
}

