/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.api;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.theme.ThemeAPI;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.theme.WidgetThemeParser;
import com.cleanroommc.modularui.utils.JsonBuilder;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IThemeApi {
    @Contract(pure=true)
    public static IThemeApi get() {
        return ThemeAPI.INSTANCE;
    }

    public ITheme getDefaultTheme();

    @NotNull
    public ITheme getTheme(String var1);

    public boolean hasTheme(String var1);

    public boolean hasWidgetTheme(String var1);

    public void registerTheme(String var1, JsonBuilder var2);

    public List<JsonBuilder> getJavaDefaultThemes(String var1);

    public ITheme getThemeForScreen(String var1, String var2, @Nullable String var3);

    default public ITheme getThemeForScreen(ModularScreen screen, @Nullable String defaultTheme) {
        return this.getThemeForScreen(screen.getOwner(), screen.getName(), defaultTheme);
    }

    default public void registerThemeForScreen(String owner, String name, String theme) {
        this.registerThemeForScreen(owner + ":" + name, theme);
    }

    public void registerThemeForScreen(String var1, String var2);

    public void registerWidgetTheme(String var1, WidgetTheme var2, WidgetThemeParser var3);
}

