/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import codechicken.lib.math.MathHelper;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.widget.Interactable;
import com.gtnewhorizons.modularui.common.widget.SyncedWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;

public class SliderWidget
extends SyncedWidget
implements Interactable {
    private IDrawable slider = ModularUITextures.BASE_BUTTON;
    private Size handleSize = new Size(8, 0);
    private float min = 0.0f;
    private float max = 1.0f;
    @SideOnly(value=Side.CLIENT)
    private float sliderPos;
    private float value = 0.0f;
    private Supplier<Float> getter;
    private Consumer<Float> setter;
    private boolean grabHandle = false;

    public SliderWidget() {
        this.setBackground(ModularUITextures.ITEM_SLOT);
    }

    public float toValue(float pos) {
        return this.min + (this.max - this.min) * (pos / (float)(this.size.width - this.handleSize.width));
    }

    public float toPos(float value) {
        return (value - this.min) / (this.max - this.min) * (float)(this.size.width - this.handleSize.width);
    }

    @SideOnly(value=Side.CLIENT)
    public void updateSlider(int relativePos, boolean sync) {
        this.setValue(this.toValue((float)MathHelper.clip((double)((float)relativePos - (float)this.handleSize.width / 2.0f), (double)0.0, (double)(this.size.width - this.handleSize.width))), sync);
    }

    @Override
    public void onInit() {
        this.setValue(this.getter.get().floatValue(), false);
    }

    @Override
    public void onRebuild() {
        this.handleSize = new Size(this.handleSize.width > 0 ? this.handleSize.width : 8, this.handleSize.height > 0 ? this.handleSize.height : this.size.height);
    }

    @Override
    public void draw(float partialTicks) {
        this.slider.draw(this.sliderPos, (float)this.size.height / 2.0f - (float)this.handleSize.height / 2.0f, this.handleSize.width, this.handleSize.height, partialTicks);
    }

    @Override
    public Interactable.ClickResult onClick(int buttonId, boolean doubleClick) {
        this.grabHandle = true;
        int clickPos = this.getContext().getCursor().getX() - this.getAbsolutePos().x;
        if (!((float)clickPos >= this.sliderPos) || !((float)clickPos < this.sliderPos + (float)this.handleSize.width)) {
            this.updateSlider(clickPos, true);
        }
        return Interactable.ClickResult.SUCCESS;
    }

    @Override
    public boolean onClickReleased(int buttonId) {
        if (this.grabHandle) {
            this.grabHandle = false;
            this.setValue(this.value, true);
            return true;
        }
        return false;
    }

    @Override
    public void onMouseDragged(int buttonId, long deltaTime) {
        if (this.grabHandle) {
            this.updateSlider(this.getContext().getCursor().getX() - this.getAbsolutePos().x, false);
        }
    }

    @Override
    public void detectAndSendChanges(boolean init) {
        if (this.syncsToClient()) {
            float val = this.getter.get().floatValue();
            if (init || val != this.value) {
                this.setValue(val, true);
                this.markForUpdate();
            }
        }
    }

    @Override
    public void readOnClient(int id, PacketBuffer buf) throws IOException {
        if (id == 1) {
            this.setValue(buf.readFloat(), false);
        }
    }

    @Override
    public void readOnServer(int id, PacketBuffer buf) throws IOException {
        if (id == 1) {
            this.setValue(buf.readFloat(), false);
            this.markForUpdate();
        }
    }

    public void setValue(float value, boolean sync) {
        this.value = value;
        if (sync) {
            if (this.isClient()) {
                this.syncToServer(1, buffer -> buffer.writeFloat(this.value));
            } else {
                this.syncToClient(1, buffer -> buffer.writeFloat(this.value));
            }
        }
        if (this.isClient()) {
            this.sliderPos = this.toPos(this.value);
        }
        this.setter.accept(Float.valueOf(this.value));
    }

    public float getValue() {
        return this.value;
    }

    public SliderWidget setHandleTexture(IDrawable slider) {
        this.slider = slider;
        return this;
    }

    public SliderWidget setHandleSize(Size handleSize) {
        this.handleSize = handleSize;
        return this;
    }

    public SliderWidget setBounds(float min, float max) {
        this.min = min;
        this.max = max;
        return this;
    }

    public SliderWidget setGetter(Supplier<Float> getter) {
        this.getter = getter;
        return this;
    }

    public SliderWidget setSetter(Consumer<Float> setter) {
        this.setter = setter;
        return this;
    }
}

