/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.fluids;

import com.gtnewhorizons.modularui.api.fluids.IFluidTankLong;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public interface IFluidTanksHandler {
    public int getTanks();

    @Nullable
    public FluidStack getFluidStackInTank(int var1);

    public Fluid getFluidInTank(int var1);

    public IFluidTankLong getFluidTank(int var1);

    @Nullable
    public FluidStack fill(int var1, @Nullable Fluid var2, long var3, boolean var5);

    @Nullable
    public FluidStack drain(int var1, long var2, boolean var4);

    public long getTankCapacity(int var1);

    public long getRealTankCapacity(int var1);

    public long getTankStoredAmount(int var1);

    default public boolean isFluidValid(int slot, FluidStack stack) {
        return true;
    }

    default public List<FluidStack> getFluids() {
        ArrayList<FluidStack> ret = new ArrayList<FluidStack>();
        for (int i = 0; i < this.getTanks(); ++i) {
            ret.add(this.getFluidStackInTank(i));
        }
        return ret;
    }

    public void setFluidInTank(int var1, Fluid var2, long var3);

    default public void setFluidInTank(int tank, Fluid fluid) {
        this.setFluidInTank(tank, fluid, 0L);
    }

    default public void setFluidInTank(int tank, IFluidTankLong fluid) {
        this.setFluidInTank(tank, fluid != null ? fluid.getStoredFluid() : null, fluid != null ? (long)fluid.getFluidAmount() : 0L);
    }
}

