/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.loader.extras;

import WayofTime.alchemicalWizardry.ModItems;
import WayofTime.alchemicalWizardry.common.demonVillage.demonHoard.demon.EntityMinorDemonGrunt;
import WayofTime.alchemicalWizardry.common.entity.mob.EntityDemon;
import com.kuba6000.mobsinfo.api.IChanceModifier;
import com.kuba6000.mobsinfo.api.MobDrop;
import com.kuba6000.mobsinfo.api.MobRecipe;
import com.kuba6000.mobsinfo.loader.extras.IExtraLoader;
import com.kuba6000.mobsinfo.loader.extras.Translations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class BloodMagic
implements IExtraLoader {
    @Override
    public void process(String k, ArrayList<MobDrop> drops, MobRecipe recipe) {
        if (!(recipe.entity instanceof EntityAnimal)) {
            MobDrop drop = new MobDrop(new ItemStack(ModItems.weakBloodShard), MobDrop.DropType.Normal, 0, null, null, false, false);
            drop.variableChance = true;
            drop.chanceModifiers.addAll(Arrays.asList(new IChanceModifier.NormalChance(50.0), new IChanceModifier.DropsOnlyWithWeaknessII()));
            drops.add(drop);
        }
        if (recipe.entity instanceof EntityDemon) {
            for (MobDrop drop : drops) {
                if (drop.stack.func_77973_b() != ModItems.demonPlacer) continue;
                drop.variableChance = true;
                drop.chanceModifiers.addAll(Arrays.asList(new IChanceModifier.NormalChance(100.0), new DemonDemonPlacer()));
            }
        }
        if (recipe.entity instanceof EntityMinorDemonGrunt) {
            ItemStack lifeShardStack = new ItemStack(ModItems.baseItems, 1, 28);
            ItemStack soulShardStack = new ItemStack(ModItems.baseItems, 1, 29);
            MobDrop drop = new MobDrop(lifeShardStack, MobDrop.DropType.Normal, 0, 0, null, true, false);
            drop.variableChance = true;
            drop.chanceModifiers.addAll(Arrays.asList(new IChanceModifier.NormalChance(30.0), new MinorDemonGruntShards()));
            drops.add(drop);
            MobDrop drop2 = new MobDrop(soulShardStack, MobDrop.DropType.Normal, 0, 0, null, true, false);
            drop2.variableChance = true;
            drop2.chanceModifiers.addAll(Arrays.asList(new IChanceModifier.NormalChance(30.0), new MinorDemonGruntShards()));
            drops.add(drop2);
        }
    }

    private static class DemonDemonPlacer
    implements IChanceModifier {
        private DemonDemonPlacer() {
        }

        @Override
        public String getDescription() {
            return Translations.BLOODMAGIC_DEMON_PLACER.get();
        }

        @Override
        public double apply(double chance, @Nonnull World world, @Nonnull List<ItemStack> drops, Entity attacker, EntityLiving victim) {
            return 0.0;
        }
    }

    private static class MinorDemonGruntShards
    implements IChanceModifier {
        private MinorDemonGruntShards() {
        }

        @Override
        public String getDescription() {
            return Translations.BLOODMAGIC_DEMON_SHARDS.get();
        }

        @Override
        public double apply(double chance, @Nonnull World world, @Nonnull List<ItemStack> drops, Entity attacker, EntityLiving victim) {
            return chance;
        }
    }
}

