/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.renderer;

import java.util.List;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.MergedVertex;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.shape.Cube;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.MalisisDoorsSettings;
import net.malisis.doors.entity.MixedBlockTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.opengl.GL11;

public class MixedBlockRenderer
extends MalisisRenderer {
    private int mixedBlockMetadata;
    private MixedBlockTileEntity tileEntity;
    private Shape simpleShape;
    private Shape[][] shapes;
    private Block block1;
    private Block block2;
    private int metadata1;
    private int metadata2;

    @Override
    protected void initialize() {
        this.simpleShape = new Cube();
        this.shapes = new Shape[][]{new Shape[6], new Shape[6]};
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            Cube s0 = new Cube();
            Cube s1 = new Cube();
            s0.enableMergedVertexes();
            s1.enableMergedVertexes();
            this.shapes[0][dir.ordinal()] = s0.removeFace(s0.getFace(Face.nameFromDirection(dir))).storeState();
            this.shapes[1][dir.ordinal()] = s1.shrink(dir, 0.999f).removeFace(s1.getFace(Face.nameFromDirection(dir))).storeState();
        }
        this.rp = new RenderParameters();
        this.rp.useBlockBounds.set(false);
        this.rp.usePerVertexAlpha.set(true);
        this.rp.useWorldSensitiveIcon.set(false);
    }

    private boolean setup() {
        if (this.renderType == RenderType.ITEM_INVENTORY) {
            if (!this.itemStack.func_77942_o()) {
                return false;
            }
            this.block1 = Block.func_149729_e((int)this.itemStack.func_77978_p().func_74762_e("block1"));
            this.block2 = Block.func_149729_e((int)this.itemStack.func_77978_p().func_74762_e("block2"));
            this.metadata1 = this.itemStack.func_77978_p().func_74762_e("metadata1");
            this.metadata2 = this.itemStack.func_77978_p().func_74762_e("metadata2");
            this.mixedBlockMetadata = 3;
        } else if (this.renderType == RenderType.ISBRH_WORLD) {
            this.tileEntity = TileEntityUtils.getTileEntity(MixedBlockTileEntity.class, this.world, this.x, this.y, this.z);
            if (this.tileEntity == null) {
                return false;
            }
            this.block1 = this.tileEntity.block1;
            this.block2 = this.tileEntity.block2;
            this.metadata1 = this.tileEntity.metadata1;
            this.metadata2 = this.tileEntity.metadata2;
            this.mixedBlockMetadata = this.blockMetadata;
        }
        return this.block1 != null && this.block2 != null;
    }

    @Override
    public void render() {
        if (!this.setup()) {
            return;
        }
        if (this.renderType == RenderType.ITEM_INVENTORY) {
            GL11.glAlphaFunc((int)516, (float)0.0f);
            GL11.glEnable((int)2903);
            GL11.glShadeModel((int)7425);
            this.enableBlending();
        }
        if (MalisisDoorsSettings.simpleMixedBlockRendering.get().booleanValue() || !Minecraft.func_71410_x().field_71474_y.field_74347_j) {
            this.renderSimple();
            return;
        }
        this.set(this.block1, this.metadata1);
        this.drawPass(true);
        this.set(this.block2, this.metadata2);
        this.drawPass(false);
    }

    private void setColor() {
        int color = this.renderType == RenderType.ISBRH_WORLD ? this.block.func_149720_d(this.world, this.x, this.y, this.z) : this.block.func_149635_D();
        this.rp.colorMultiplier.set(color);
        this.shape.setParameters("Top", this.rp, true);
        if (this.block instanceof BlockGrass) {
            this.rp.colorMultiplier.set(color);
            this.shape.setParameters("Top", this.rp, true);
            this.rp.colorMultiplier.set(0xFFFFFF);
        }
    }

    private void renderSimple() {
        boolean reversed = false;
        float width = 1.0f;
        float height = 1.0f;
        float depth = 1.0f;
        float offsetX = 0.0f;
        float offestY = 0.0f;
        float offsetZ = 0.0f;
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.mixedBlockMetadata);
        if (dir == ForgeDirection.DOWN || dir == ForgeDirection.UP) {
            height = 0.5f;
            offestY = 0.5f;
            if (dir == ForgeDirection.UP) {
                reversed = true;
            }
        }
        if (dir == ForgeDirection.WEST || dir == ForgeDirection.EAST) {
            width = 0.5f;
            offsetX = 0.5f;
            if (dir == ForgeDirection.EAST) {
                reversed = true;
            }
        }
        if (dir == ForgeDirection.NORTH || dir == ForgeDirection.SOUTH) {
            depth = 0.5f;
            offsetZ = 0.5f;
            if (dir == ForgeDirection.SOUTH) {
                reversed = true;
            }
        }
        Block b = reversed ? this.block2 : this.block1;
        int m = reversed ? this.metadata2 : this.metadata1;
        this.set(b, m);
        this.setColor();
        this.simpleShape.resetState().setSize(width, height, depth);
        this.drawShape(this.simpleShape, this.rp);
        b = reversed ? this.block1 : this.block2;
        m = reversed ? this.metadata1 : this.metadata2;
        this.set(b, m);
        this.setColor();
        this.simpleShape.resetState().setSize(width, height, depth).translate(offsetX, offestY, offsetZ);
        this.drawShape(this.simpleShape, this.rp);
    }

    private void drawPass(boolean firstBlock) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.mixedBlockMetadata);
        if (firstBlock) {
            dir = dir.getOpposite();
        }
        this.shape = this.shapes[firstBlock && this.renderType == RenderType.ISBRH_WORLD ? 1 : 0][dir.ordinal()];
        this.shape.resetState();
        if (this.shouldShadeFace(firstBlock)) {
            List<MergedVertex> vertexes = this.shape.getMergedVertexes(dir);
            for (MergedVertex v : vertexes) {
                v.setAlpha(0);
            }
        }
        this.setColor();
        this.drawShape(this.shape, this.rp);
    }

    protected boolean shouldShadeFace(Boolean firstBlock) {
        Block other;
        Object[] shaded = new Block[]{Blocks.field_150359_w, Blocks.field_150362_t, Blocks.field_150361_u};
        if (this.block.canRenderInPass(1)) {
            return true;
        }
        Block block = other = firstBlock != false ? this.block2 : this.block1;
        if (other.canRenderInPass(1)) {
            return true;
        }
        if (ArrayUtils.contains((Object[])shaded, (Object)this.block) || ArrayUtils.contains((Object[])shaded, (Object)other)) {
            return true;
        }
        return firstBlock == false;
    }

    @Override
    protected boolean shouldRenderFace(Face face) {
        if (this.renderType != RenderType.ISBRH_WORLD || this.world == null || this.block == null) {
            return true;
        }
        if (this.rp != null && this.rp.renderAllFaces.get().booleanValue()) {
            return true;
        }
        if (this.renderBlocks != null && this.renderBlocks.field_147837_f) {
            return true;
        }
        RenderParameters p = face.getParameters();
        if (p.direction.get() == null) {
            return true;
        }
        boolean b = MalisisDoors.Blocks.mixedBlock.func_149646_a(this.world, this.x + p.direction.get().offsetX, this.y + p.direction.get().offsetY, this.z + p.direction.get().offsetZ, p.direction.get().ordinal());
        return b;
    }
}

