/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.recipe;

import net.malisis.core.util.BlockState;
import net.malisis.core.util.ItemUtils;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.door.block.BigDoor;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class BigDoorRecipe
implements IRecipe {
    private BigDoor.Type type;

    public BigDoorRecipe(BigDoor.Type type) {
        this.type = type;
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        return this.getMatching(inv) != null;
    }

    public ItemStack getMatching(InventoryCrafting inv) {
        boolean doorMatch = false;
        ItemStack frame = null;
        int frameSize = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemStack = inv.func_70301_a(i);
            if (itemStack == null) continue;
            if (itemStack.func_77973_b() == this.type.door) {
                if (doorMatch) {
                    return null;
                }
                doorMatch = true;
                continue;
            }
            Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
            if (block == null || frame != null && !ItemUtils.areItemStacksStackable(frame, itemStack)) {
                return null;
            }
            frame = itemStack;
            ++frameSize;
        }
        return !doorMatch || frame == null || frameSize != 5 ? null : frame;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack frame = this.getMatching(inv);
        if (frame == null) {
            return null;
        }
        ItemStack itemStack = new ItemStack((Block)(this.type == BigDoor.Type.CARRIAGE ? MalisisDoors.Blocks.carriageDoor : MalisisDoors.Blocks.medievalDoor));
        NBTTagCompound nbt = new NBTTagCompound();
        BlockState.toNBT(nbt, ItemUtils.getStateFromItemStack(frame));
        itemStack.func_77982_d(nbt);
        return itemStack;
    }

    public ItemStack func_77571_b() {
        return new ItemStack((Block)(this.type == BigDoor.Type.CARRIAGE ? MalisisDoors.Blocks.carriageDoor : MalisisDoors.Blocks.medievalDoor));
    }

    public int func_77570_a() {
        return 2;
    }

    public ItemStack[] getRemainingItems(InventoryCrafting inv) {
        ItemStack[] itemStacks = new ItemStack[inv.func_70302_i_()];
        int left = 5;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemStack = inv.func_70301_a(i);
            inv.func_70299_a(i, null);
            if (itemStack == null) continue;
            ItemUtils.ItemStackSplitter iss = new ItemUtils.ItemStackSplitter(itemStack);
            iss.split(itemStack.func_77973_b() == this.type.door ? 1 : left);
            itemStacks[i] = iss.source;
            if (itemStack.func_77973_b() == this.type.door) continue;
            left -= iss.amount;
        }
        return itemStacks;
    }
}

