/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.movement;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.ParallelTransformation;
import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Scale;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.movement.IDoorMovement;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.util.AxisAlignedBB;

public class SpinningAroundDoorMovement
implements IDoorMovement {
    private Rotation rotBot = new Rotation(720.0f).aroundAxis(0.0f, 0.0f, 1.0f);
    private Rotation rotTop = new Rotation(720.0f).aroundAxis(0.0f, 0.0f, 1.0f);
    private Rotation rotBot2 = new Rotation(-720.0f).aroundAxis(0.0f, 0.0f, 1.0f);
    private Rotation rotTop2 = new Rotation(-720.0f).aroundAxis(0.0f, 0.0f, 1.0f).offset(0.0f, 1.0f, 0.0f);
    private Scale scaleBot = new Scale(0.0f, 0.0f, 0.0f);
    private Scale scaleTop = new Scale(0.0f, 0.0f, 0.0f).offset(0.0f, 1.0f, 0.0f);

    @Override
    public AxisAlignedBB getBoundingBox(DoorTileEntity tileEntity, boolean topBlock, BoundingBoxType type) {
        if (tileEntity.isOpened() && type != BoundingBoxType.RAYTRACE) {
            return null;
        }
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.1875);
        if (type == BoundingBoxType.SELECTION) {
            if (!topBlock) {
                aabb.field_72337_e += 1.0;
            } else {
                aabb.field_72338_b -= 1.0;
            }
        }
        return aabb;
    }

    @Override
    public Animation[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        boolean doubleDoor = tileEntity.getDoubleDoor() != null;
        boolean closed = tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED;
        int ot = tileEntity.getDescriptor().getOpeningTime();
        float offsetX = doubleDoor ? (tileEntity.isReversed() ? 0.5f : -0.5f) : 0.0f;
        this.rotBot.offset(offsetX, 0.5f, 0.0f);
        this.rotBot.reversed(closed);
        this.rotBot.forTicks(ot);
        this.rotBot2.forTicks(ot);
        this.rotBot2.reversed(closed);
        this.rotTop.offset(offsetX, 0.5f, 0.0f);
        this.rotTop.reversed(closed);
        this.rotTop.forTicks(ot);
        this.rotTop2.forTicks(ot);
        this.rotTop2.reversed(closed);
        this.scaleBot.reversed(closed);
        this.scaleBot.forTicks(ot);
        this.scaleTop.reversed(closed);
        this.scaleTop.forTicks(ot);
        ParallelTransformation bot = new ParallelTransformation(this.rotBot, this.rotBot2, this.scaleBot);
        ParallelTransformation top = new ParallelTransformation(this.rotTop, this.rotTop2, this.scaleTop);
        return new Animation[]{new Animation(model.getShape("bottom"), bot), new Animation(model.getShape("top"), top)};
    }

    @Override
    public boolean isSpecial() {
        return false;
    }
}

