/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.movement;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.ParallelTransformation;
import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.core.util.MultiBlock;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.movement.IDoorMovement;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.malisis.doors.door.tileentity.RustyHatchTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class RustyHatchMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getBoundingBox(DoorTileEntity tileEntity, boolean topBlock, BoundingBoxType type) {
        if (!(tileEntity instanceof RustyHatchTileEntity)) {
            return null;
        }
        MultiBlock mb = ((RustyHatchTileEntity)tileEntity).getMultiBlock();
        if (mb == null) {
            return null;
        }
        float f = 0.125f;
        AxisAlignedBB aabb = mb.getWorldBounds();
        ForgeDirection dir = ForgeDirection.getOrientation((int)tileEntity.getDirection());
        if (!tileEntity.isOpened()) {
            if (topBlock) {
                aabb.field_72338_b = aabb.field_72338_b + 1.0 - (double)f;
                aabb.field_72337_e = aabb.field_72338_b + (double)f;
            } else {
                aabb.field_72338_b += 2.0;
                aabb.field_72337_e = aabb.field_72338_b + (double)f;
            }
        } else {
            aabb.field_72340_a += (double)f;
            aabb.field_72336_d -= (double)f;
            aabb.field_72339_c += (double)f;
            aabb.field_72334_f -= (double)f;
            if (topBlock) {
                aabb.field_72338_b += 1.0;
                aabb.field_72337_e -= (double)(2.0f * f);
            } else {
                aabb.field_72338_b += (double)(2.0f * f);
                aabb.field_72337_e -= 1.0;
            }
            if (dir == ForgeDirection.NORTH) {
                aabb.field_72339_c = aabb.field_72334_f - (double)f;
            }
            if (dir == ForgeDirection.SOUTH) {
                aabb.field_72334_f = aabb.field_72339_c + (double)f;
            }
            if (dir == ForgeDirection.EAST) {
                aabb.field_72336_d = aabb.field_72340_a + (double)f;
            }
            if (dir == ForgeDirection.WEST) {
                aabb.field_72340_a = aabb.field_72336_d - (double)f;
            }
        }
        return aabb;
    }

    private Transformation getDoorTransformation(DoorTileEntity tileEntity) {
        float f;
        float offX = f = -0.375f;
        float offY = f;
        float toAngle = 90.0f;
        if (!tileEntity.isTopBlock(0, 0, 0)) {
            toAngle = -toAngle;
            offY = -0.5f;
        }
        int t = tileEntity.getDescriptor().getOpeningTime() / 2;
        Rotation rotation = (Rotation)new Rotation(toAngle).aroundAxis(0.0f, 0.0f, 1.0f).offset(offX, offY, 0.0f).movement(1);
        if (tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED) {
            rotation.reversed(true);
        } else {
            rotation.delay(t);
        }
        rotation.forTicks(t);
        return rotation;
    }

    private Transformation getHandleTransformation(DoorTileEntity tileEntity) {
        int t = tileEntity.getDescriptor().getOpeningTime() / 2;
        Rotation rotation = (Rotation)new Rotation(400.0f).aroundAxis(0.0f, 1.0f, 0.0f).offset(0.5f, 0.0f, 0.5f).movement(1);
        if (tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED) {
            ((Rotation)rotation.delay(t)).reversed(true);
        }
        rotation.forTicks(t);
        return rotation;
    }

    @Override
    public Animation[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        ParallelTransformation transform = new ParallelTransformation(this.getDoorTransformation(tileEntity), this.getHandleTransformation(tileEntity));
        return new Animation[]{new Animation(model.getShape("door"), this.getDoorTransformation(tileEntity)), new Animation(model.getShape("handle"), transform)};
    }

    @Override
    public boolean isSpecial() {
        return true;
    }
}

