/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors;

import com.google.common.collect.ImmutableSetMultimap;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.WeakHashMap;
import net.malisis.core.MalisisCore;
import net.malisis.doors.entity.VanishingTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.IEntitySelector;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.profiler.Profiler;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldAccess;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.util.ForgeDirection;

public class ProxyAccess {
    private static WeakHashMap<IBlockAccess, IBlockAccess> cache = new WeakHashMap();
    private static World tmpCache;
    private static boolean worldInstanciationFailed;

    public static IBlockAccess get(IBlockAccess world) {
        if (world == null) {
            return null;
        }
        Object proxy = cache.get(world);
        if (proxy == null) {
            if (world instanceof World) {
                if (worldInstanciationFailed) {
                    return world;
                }
                try {
                    tmpCache = (World)world;
                    proxy = new ProxyWorld((World)world);
                    tmpCache = null;
                }
                catch (Exception e) {
                    MalisisCore.log.error("[ProxyAccess] Proxy world instanciation failed :", (Throwable)e);
                    worldInstanciationFailed = true;
                    return world;
                }
            } else {
                proxy = new ProxyBlockAccess(world);
            }
            cache.put(world, (IBlockAccess)proxy);
        }
        return proxy;
    }

    public static VanishingTileEntity getVanishingTileEntity(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof VanishingTileEntity) {
            return (VanishingTileEntity)te;
        }
        return null;
    }

    public static Block getBlock(IBlockAccess world, int x, int y, int z) {
        VanishingTileEntity te = ProxyAccess.getVanishingTileEntity(world, x, y, z);
        if (te != null) {
            return te.copiedBlock != null ? te.copiedBlock : Blocks.field_150350_a;
        }
        return world.func_147439_a(x, y, z);
    }

    public static int getMetadata(IBlockAccess world, int x, int y, int z) {
        VanishingTileEntity te = ProxyAccess.getVanishingTileEntity(world, x, y, z);
        if (te != null) {
            return te.copiedMetadata;
        }
        return world.func_72805_g(x, y, z);
    }

    public static TileEntity getTileEntity(IBlockAccess world, int x, int y, int z) {
        VanishingTileEntity te = ProxyAccess.getVanishingTileEntity(world, x, y, z);
        if (te != null) {
            return te.copiedTileEntity;
        }
        return world.func_147438_o(x, y, z);
    }

    static {
        worldInstanciationFailed = false;
    }

    private static class ProxyWorld
    extends World {
        public World original;

        public ProxyWorld(World world) {
            super(world.func_72860_G(), "ProxyWorld", new WorldSettings(world.func_72912_H()), world.field_73011_w, (Profiler)null);
            this.original = world;
            this.field_73011_w.field_76579_a = world;
        }

        public Block func_147439_a(int x, int y, int z) {
            return ProxyAccess.getBlock((IBlockAccess)this.original, x, y, z);
        }

        public TileEntity func_147438_o(int x, int y, int z) {
            return ProxyAccess.getTileEntity((IBlockAccess)this.original, x, y, z);
        }

        public int func_72805_g(int x, int y, int z) {
            return ProxyAccess.getMetadata((IBlockAccess)this.original, x, y, z);
        }

        public boolean func_147465_d(int x, int y, int z, Block block, int metadata, int flag) {
            VanishingTileEntity te = ProxyAccess.getVanishingTileEntity((IBlockAccess)this.original, x, y, z);
            if (te != null) {
                te.copiedBlock = block;
                te.copiedMetadata = metadata;
                return true;
            }
            return this.original.func_147465_d(x, y, z, block, metadata, flag);
        }

        public boolean func_72921_c(int x, int y, int z, int metadata, int flag) {
            VanishingTileEntity te = ProxyAccess.getVanishingTileEntity((IBlockAccess)this.original, x, y, z);
            if (te != null && te.copiedBlock != null) {
                te.copiedMetadata = metadata;
                this.func_147459_d(x, y, z, te.copiedBlock);
                return true;
            }
            return this.original.func_72921_c(x, y, z, metadata, flag);
        }

        protected IChunkProvider func_72970_h() {
            return null;
        }

        public WorldInfo func_72912_H() {
            if (this.original != null) {
                return this.original.func_72912_H();
            }
            return tmpCache.func_72912_H();
        }

        public long func_72905_C() {
            if (this.original != null) {
                return this.original.func_72905_C();
            }
            return tmpCache.func_72905_C();
        }

        public void func_72966_v() {
        }

        public void calculateInitialWeatherBody() {
        }

        protected int func_152379_p() {
            return 0;
        }

        public BiomeGenBase func_72807_a(int x, int z) {
            return this.original.func_72807_a(x, z);
        }

        public BiomeGenBase getBiomeGenForCoordsBody(int x, int z) {
            return this.original.getBiomeGenForCoordsBody(x, z);
        }

        public WorldChunkManager func_72959_q() {
            return this.original.func_72959_q();
        }

        public void func_72974_f() {
            this.original.func_72974_f();
        }

        public Block func_147474_b(int x, int z) {
            return this.original.func_147474_b(x, z);
        }

        public boolean func_147437_c(int x, int y, int z) {
            return this.original.func_147437_c(x, y, z);
        }

        public boolean func_72899_e(int p_72899_1_, int p_72899_2_, int p_72899_3_) {
            return this.original.func_72899_e(p_72899_1_, p_72899_2_, p_72899_3_);
        }

        public boolean func_72873_a(int p_72873_1_, int p_72873_2_, int p_72873_3_, int p_72873_4_) {
            return this.original.func_72873_a(p_72873_1_, p_72873_2_, p_72873_3_, p_72873_4_);
        }

        public boolean func_72904_c(int p_72904_1_, int p_72904_2_, int p_72904_3_, int p_72904_4_, int p_72904_5_, int p_72904_6_) {
            return this.original.func_72904_c(p_72904_1_, p_72904_2_, p_72904_3_, p_72904_4_, p_72904_5_, p_72904_6_);
        }

        public Chunk func_72938_d(int p_72938_1_, int p_72938_2_) {
            return this.original.func_72938_d(p_72938_1_, p_72938_2_);
        }

        public Chunk func_72964_e(int p_72964_1_, int p_72964_2_) {
            return this.original.func_72964_e(p_72964_1_, p_72964_2_);
        }

        public void markAndNotifyBlock(int x, int y, int z, Chunk chunk, Block oldBlock, Block newBlock, int flag) {
            this.original.markAndNotifyBlock(x, y, z, chunk, oldBlock, newBlock, flag);
        }

        public boolean func_147468_f(int x, int y, int z) {
            return this.original.func_147468_f(x, y, z);
        }

        public boolean func_147480_a(int x, int y, int z, boolean dropBlock) {
            return this.original.func_147480_a(x, y, z, dropBlock);
        }

        public boolean func_147449_b(int x, int y, int z, Block blockType) {
            return this.original.func_147449_b(x, y, z, blockType);
        }

        public void func_147471_g(int p_147471_1_, int p_147471_2_, int p_147471_3_) {
            this.original.func_147471_g(p_147471_1_, p_147471_2_, p_147471_3_);
        }

        public void func_147444_c(int p_147444_1_, int p_147444_2_, int p_147444_3_, Block p_147444_4_) {
            this.original.func_147444_c(p_147444_1_, p_147444_2_, p_147444_3_, p_147444_4_);
        }

        public void func_72975_g(int p_72975_1_, int p_72975_2_, int p_72975_3_, int p_72975_4_) {
            this.original.func_72975_g(p_72975_1_, p_72975_2_, p_72975_3_, p_72975_4_);
        }

        public void func_147458_c(int p_147458_1_, int p_147458_2_, int p_147458_3_, int p_147458_4_, int p_147458_5_, int p_147458_6_) {
            this.original.func_147458_c(p_147458_1_, p_147458_2_, p_147458_3_, p_147458_4_, p_147458_5_, p_147458_6_);
        }

        public void func_147459_d(int p_147459_1_, int p_147459_2_, int p_147459_3_, Block p_147459_4_) {
            this.original.func_147459_d(p_147459_1_, p_147459_2_, p_147459_3_, p_147459_4_);
        }

        public void func_147441_b(int p_147441_1_, int p_147441_2_, int p_147441_3_, Block p_147441_4_, int p_147441_5_) {
            this.original.func_147441_b(p_147441_1_, p_147441_2_, p_147441_3_, p_147441_4_, p_147441_5_);
        }

        public void func_147460_e(int p_147460_1_, int p_147460_2_, int p_147460_3_, Block p_147460_4_) {
            this.original.func_147460_e(p_147460_1_, p_147460_2_, p_147460_3_, p_147460_4_);
        }

        public boolean func_147477_a(int p_147477_1_, int p_147477_2_, int p_147477_3_, Block p_147477_4_) {
            return this.original.func_147477_a(p_147477_1_, p_147477_2_, p_147477_3_, p_147477_4_);
        }

        public boolean func_72937_j(int p_72937_1_, int p_72937_2_, int p_72937_3_) {
            return this.original.func_72937_j(p_72937_1_, p_72937_2_, p_72937_3_);
        }

        public int func_72883_k(int p_72883_1_, int p_72883_2_, int p_72883_3_) {
            return this.original.func_72883_k(p_72883_1_, p_72883_2_, p_72883_3_);
        }

        public int func_72957_l(int p_72957_1_, int p_72957_2_, int p_72957_3_) {
            return this.original.func_72957_l(p_72957_1_, p_72957_2_, p_72957_3_);
        }

        public int func_72849_a(int p_72849_1_, int p_72849_2_, int p_72849_3_, boolean p_72849_4_) {
            return this.original.func_72849_a(p_72849_1_, p_72849_2_, p_72849_3_, p_72849_4_);
        }

        public int func_72976_f(int p_72976_1_, int p_72976_2_) {
            return this.original.func_72976_f(p_72976_1_, p_72976_2_);
        }

        public int func_82734_g(int p_82734_1_, int p_82734_2_) {
            return this.original.func_82734_g(p_82734_1_, p_82734_2_);
        }

        public int func_72925_a(EnumSkyBlock p_72925_1_, int p_72925_2_, int p_72925_3_, int p_72925_4_) {
            return this.original.func_72925_a(p_72925_1_, p_72925_2_, p_72925_3_, p_72925_4_);
        }

        public int func_72972_b(EnumSkyBlock p_72972_1_, int p_72972_2_, int p_72972_3_, int p_72972_4_) {
            return this.original.func_72972_b(p_72972_1_, p_72972_2_, p_72972_3_, p_72972_4_);
        }

        public void func_72915_b(EnumSkyBlock p_72915_1_, int p_72915_2_, int p_72915_3_, int p_72915_4_, int p_72915_5_) {
            this.original.func_72915_b(p_72915_1_, p_72915_2_, p_72915_3_, p_72915_4_, p_72915_5_);
        }

        public void func_147479_m(int p_147479_1_, int p_147479_2_, int p_147479_3_) {
            this.original.func_147479_m(p_147479_1_, p_147479_2_, p_147479_3_);
        }

        public int func_72802_i(int p_72802_1_, int p_72802_2_, int p_72802_3_, int p_72802_4_) {
            return this.original.func_72802_i(p_72802_1_, p_72802_2_, p_72802_3_, p_72802_4_);
        }

        public float func_72801_o(int p_72801_1_, int p_72801_2_, int p_72801_3_) {
            return this.original.func_72801_o(p_72801_1_, p_72801_2_, p_72801_3_);
        }

        public boolean func_72935_r() {
            return this.original.func_72935_r();
        }

        public MovingObjectPosition func_72933_a(Vec3 p_72933_1_, Vec3 p_72933_2_) {
            return this.original.func_72933_a(p_72933_1_, p_72933_2_);
        }

        public MovingObjectPosition func_72901_a(Vec3 p_72901_1_, Vec3 p_72901_2_, boolean p_72901_3_) {
            return this.original.func_72901_a(p_72901_1_, p_72901_2_, p_72901_3_);
        }

        public MovingObjectPosition func_147447_a(Vec3 p_147447_1_, Vec3 p_147447_2_, boolean p_147447_3_, boolean p_147447_4_, boolean p_147447_5_) {
            return this.original.func_147447_a(p_147447_1_, p_147447_2_, p_147447_3_, p_147447_4_, p_147447_5_);
        }

        public void func_72956_a(Entity p_72956_1_, String p_72956_2_, float p_72956_3_, float p_72956_4_) {
            this.original.func_72956_a(p_72956_1_, p_72956_2_, p_72956_3_, p_72956_4_);
        }

        public void func_85173_a(EntityPlayer p_85173_1_, String p_85173_2_, float p_85173_3_, float p_85173_4_) {
            this.original.func_85173_a(p_85173_1_, p_85173_2_, p_85173_3_, p_85173_4_);
        }

        public void func_72908_a(double x, double y, double z, String soundName, float volume, float pitch) {
            this.original.func_72908_a(x, y, z, soundName, volume, pitch);
        }

        public void func_72980_b(double x, double y, double z, String soundName, float volume, float pitch, boolean distanceDelay) {
            this.original.func_72980_b(x, y, z, soundName, volume, pitch, distanceDelay);
        }

        public void func_72934_a(String recordName, int x, int y, int z) {
            this.original.func_72934_a(recordName, x, y, z);
        }

        public void func_72869_a(String particleName, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            this.original.func_72869_a(particleName, x, y, z, velocityX, velocityY, velocityZ);
        }

        public boolean func_72942_c(Entity p_72942_1_) {
            return this.original.func_72942_c(p_72942_1_);
        }

        public boolean func_72838_d(Entity p_72838_1_) {
            return this.original.func_72838_d(p_72838_1_);
        }

        public void func_72923_a(Entity p_72923_1_) {
            this.original.func_72923_a(p_72923_1_);
        }

        public void func_72847_b(Entity p_72847_1_) {
            this.original.func_72847_b(p_72847_1_);
        }

        public void func_72900_e(Entity p_72900_1_) {
            this.original.func_72900_e(p_72900_1_);
        }

        public void func_72973_f(Entity p_72973_1_) {
            this.original.func_72973_f(p_72973_1_);
        }

        public void func_72954_a(IWorldAccess p_72954_1_) {
            this.original.func_72954_a(p_72954_1_);
        }

        public List<AxisAlignedBB> func_72945_a(Entity p_72945_1_, AxisAlignedBB p_72945_2_) {
            return this.original.func_72945_a(p_72945_1_, p_72945_2_);
        }

        public List<AxisAlignedBB> func_147461_a(AxisAlignedBB p_147461_1_) {
            return this.original.func_147461_a(p_147461_1_);
        }

        public int func_72967_a(float p_72967_1_) {
            return this.original.func_72967_a(p_72967_1_);
        }

        public float getSunBrightnessFactor(float p_72967_1_) {
            return this.original.getSunBrightnessFactor(p_72967_1_);
        }

        public void func_72848_b(IWorldAccess p_72848_1_) {
            this.original.func_72848_b(p_72848_1_);
        }

        public float func_72971_b(float p_72971_1_) {
            return this.original.func_72971_b(p_72971_1_);
        }

        public float getSunBrightnessBody(float p_72971_1_) {
            return this.original.getSunBrightnessBody(p_72971_1_);
        }

        public Vec3 func_72833_a(Entity p_72833_1_, float p_72833_2_) {
            return this.original.func_72833_a(p_72833_1_, p_72833_2_);
        }

        public Vec3 getSkyColorBody(Entity p_72833_1_, float p_72833_2_) {
            return this.original.getSkyColorBody(p_72833_1_, p_72833_2_);
        }

        public float func_72826_c(float p_72826_1_) {
            return this.original.func_72826_c(p_72826_1_);
        }

        public int func_72853_d() {
            return this.original.func_72853_d();
        }

        public float func_130001_d() {
            return this.original.func_130001_d();
        }

        public float getCurrentMoonPhaseFactorBody() {
            return this.original.getCurrentMoonPhaseFactorBody();
        }

        public float func_72929_e(float p_72929_1_) {
            return this.original.func_72929_e(p_72929_1_);
        }

        public Vec3 func_72824_f(float p_72824_1_) {
            return this.original.func_72824_f(p_72824_1_);
        }

        public Vec3 drawCloudsBody(float p_72824_1_) {
            return this.original.drawCloudsBody(p_72824_1_);
        }

        public Vec3 func_72948_g(float p_72948_1_) {
            return this.original.func_72948_g(p_72948_1_);
        }

        public int func_72874_g(int p_72874_1_, int p_72874_2_) {
            return this.original.func_72874_g(p_72874_1_, p_72874_2_);
        }

        public int func_72825_h(int p_72825_1_, int p_72825_2_) {
            return this.original.func_72825_h(p_72825_1_, p_72825_2_);
        }

        public float func_72880_h(float p_72880_1_) {
            return this.original.func_72880_h(p_72880_1_);
        }

        public float getStarBrightnessBody(float par1) {
            return this.original.getStarBrightnessBody(par1);
        }

        public void func_147464_a(int p_147464_1_, int p_147464_2_, int p_147464_3_, Block p_147464_4_, int p_147464_5_) {
            this.original.func_147464_a(p_147464_1_, p_147464_2_, p_147464_3_, p_147464_4_, p_147464_5_);
        }

        public void func_147454_a(int p_147454_1_, int p_147454_2_, int p_147454_3_, Block p_147454_4_, int p_147454_5_, int p_147454_6_) {
            this.original.func_147454_a(p_147454_1_, p_147454_2_, p_147454_3_, p_147454_4_, p_147454_5_, p_147454_6_);
        }

        public void func_147446_b(int p_147446_1_, int p_147446_2_, int p_147446_3_, Block p_147446_4_, int p_147446_5_, int p_147446_6_) {
            this.original.func_147446_b(p_147446_1_, p_147446_2_, p_147446_3_, p_147446_4_, p_147446_5_, p_147446_6_);
        }

        public void func_72939_s() {
            this.original.func_72939_s();
        }

        public void func_147448_a(Collection<TileEntity> p_147448_1_) {
            this.original.func_147448_a(p_147448_1_);
        }

        public void func_72870_g(Entity p_72870_1_) {
            this.original.func_72870_g(p_72870_1_);
        }

        public void func_72866_a(Entity p_72866_1_, boolean p_72866_2_) {
            this.original.func_72866_a(p_72866_1_, p_72866_2_);
        }

        public boolean func_72855_b(AxisAlignedBB p_72855_1_) {
            return this.original.func_72855_b(p_72855_1_);
        }

        public boolean func_72917_a(AxisAlignedBB p_72917_1_, Entity p_72917_2_) {
            return this.original.func_72917_a(p_72917_1_, p_72917_2_);
        }

        public boolean func_72829_c(AxisAlignedBB p_72829_1_) {
            return this.original.func_72829_c(p_72829_1_);
        }

        public boolean func_72953_d(AxisAlignedBB p_72953_1_) {
            return this.original.func_72953_d(p_72953_1_);
        }

        public boolean func_147470_e(AxisAlignedBB p_147470_1_) {
            return this.original.func_147470_e(p_147470_1_);
        }

        public boolean func_72918_a(AxisAlignedBB p_72918_1_, Material p_72918_2_, Entity p_72918_3_) {
            return this.original.func_72918_a(p_72918_1_, p_72918_2_, p_72918_3_);
        }

        public boolean func_72875_a(AxisAlignedBB p_72875_1_, Material p_72875_2_) {
            return this.original.func_72875_a(p_72875_1_, p_72875_2_);
        }

        public boolean func_72830_b(AxisAlignedBB p_72830_1_, Material p_72830_2_) {
            return this.original.func_72830_b(p_72830_1_, p_72830_2_);
        }

        public Explosion func_72876_a(Entity p_72876_1_, double p_72876_2_, double p_72876_4_, double p_72876_6_, float p_72876_8_, boolean p_72876_9_) {
            return this.original.func_72876_a(p_72876_1_, p_72876_2_, p_72876_4_, p_72876_6_, p_72876_8_, p_72876_9_);
        }

        public Explosion func_72885_a(Entity p_72885_1_, double p_72885_2_, double p_72885_4_, double p_72885_6_, float p_72885_8_, boolean p_72885_9_, boolean p_72885_10_) {
            return this.original.func_72885_a(p_72885_1_, p_72885_2_, p_72885_4_, p_72885_6_, p_72885_8_, p_72885_9_, p_72885_10_);
        }

        public float func_72842_a(Vec3 p_72842_1_, AxisAlignedBB p_72842_2_) {
            return this.original.func_72842_a(p_72842_1_, p_72842_2_);
        }

        public boolean func_72886_a(EntityPlayer player, int x, int y, int z, int side) {
            return this.original.func_72886_a(player, x, y, z, side);
        }

        public String func_72981_t() {
            return this.original.func_72981_t();
        }

        public String func_72827_u() {
            return this.original.func_72827_u();
        }

        public void func_147455_a(int x, int y, int z, TileEntity tileEntityIn) {
            this.original.func_147455_a(x, y, z, tileEntityIn);
        }

        public void func_147475_p(int x, int y, int z) {
            this.original.func_147475_p(x, y, z);
        }

        public void func_147457_a(TileEntity tileEntityIn) {
            this.original.func_147457_a(tileEntityIn);
        }

        public boolean func_147469_q(int x, int y, int z) {
            return this.original.func_147469_q(x, y, z);
        }

        public boolean func_147445_c(int x, int y, int z, boolean def) {
            return this.original.func_147445_c(x, y, z, def);
        }

        public void func_72891_a(boolean hostile, boolean peaceful) {
            this.original.func_72891_a(hostile, peaceful);
        }

        public void func_72835_b() {
            this.original.func_72835_b();
        }

        public void updateWeatherBody() {
            this.original.updateWeatherBody();
        }

        public boolean func_72884_u(int x, int y, int z) {
            return this.original.func_72884_u(x, y, z);
        }

        public boolean func_72850_v(int x, int y, int z) {
            return this.original.func_72850_v(x, y, z);
        }

        public boolean func_72834_c(int x, int y, int z, boolean byWater) {
            return this.original.func_72834_c(x, y, z, byWater);
        }

        public boolean canBlockFreezeBody(int x, int y, int z, boolean byWater) {
            return this.original.canBlockFreezeBody(x, y, z, byWater);
        }

        public boolean func_147478_e(int x, int y, int z, boolean checkLight) {
            return this.original.func_147478_e(x, y, z, checkLight);
        }

        public boolean canSnowAtBody(int x, int y, int z, boolean checkLight) {
            return this.original.canSnowAtBody(x, y, z, checkLight);
        }

        public boolean func_147451_t(int x, int y, int z) {
            return this.original.func_147451_t(x, y, z);
        }

        public boolean func_147463_c(EnumSkyBlock p_147463_1_, int p_147463_2_, int p_147463_3_, int p_147463_4_) {
            return this.original.func_147463_c(p_147463_1_, p_147463_2_, p_147463_3_, p_147463_4_);
        }

        public boolean func_72955_a(boolean p_72955_1_) {
            return this.original.func_72955_a(p_72955_1_);
        }

        public List<NextTickListEntry> func_72920_a(Chunk p_72920_1_, boolean p_72920_2_) {
            return this.original.func_72920_a(p_72920_1_, p_72920_2_);
        }

        public List<Entity> func_72839_b(Entity p_72839_1_, AxisAlignedBB p_72839_2_) {
            return this.original.func_72839_b(p_72839_1_, p_72839_2_);
        }

        public List<Entity> func_94576_a(Entity p_94576_1_, AxisAlignedBB p_94576_2_, IEntitySelector p_94576_3_) {
            return this.original.func_94576_a(p_94576_1_, p_94576_2_, p_94576_3_);
        }

        public <T> List<T> func_72872_a(Class<T> p_72872_1_, AxisAlignedBB p_72872_2_) {
            return this.original.func_72872_a(p_72872_1_, p_72872_2_);
        }

        public <T> List<T> func_82733_a(Class<T> clazz, AxisAlignedBB bb, IEntitySelector selector) {
            return this.original.func_82733_a(clazz, bb, selector);
        }

        public Entity func_72857_a(Class<? extends Entity> p_72857_1_, AxisAlignedBB p_72857_2_, Entity p_72857_3_) {
            return this.original.func_72857_a(p_72857_1_, p_72857_2_, p_72857_3_);
        }

        public Entity func_73045_a(int arg0) {
            return this.original.func_73045_a(arg0);
        }

        public List<Entity> func_72910_y() {
            return this.original.func_72910_y();
        }

        public void func_147476_b(int p_147476_1_, int p_147476_2_, int p_147476_3_, TileEntity p_147476_4_) {
            this.original.func_147476_b(p_147476_1_, p_147476_2_, p_147476_3_, p_147476_4_);
        }

        public int func_72907_a(Class<? extends Entity> p_72907_1_) {
            return this.original.func_72907_a(p_72907_1_);
        }

        public void func_72868_a(List<Entity> p_72868_1_) {
            this.original.func_72868_a(p_72868_1_);
        }

        public void func_72828_b(List<Entity> p_72828_1_) {
            this.original.func_72828_b(p_72828_1_);
        }

        public boolean func_147472_a(Block p_147472_1_, int p_147472_2_, int p_147472_3_, int p_147472_4_, boolean p_147472_5_, int p_147472_6_, Entity p_147472_7_, ItemStack p_147472_8_) {
            return this.original.func_147472_a(p_147472_1_, p_147472_2_, p_147472_3_, p_147472_4_, p_147472_5_, p_147472_6_, p_147472_7_, p_147472_8_);
        }

        public PathEntity func_72865_a(Entity p_72865_1_, Entity p_72865_2_, float p_72865_3_, boolean p_72865_4_, boolean p_72865_5_, boolean p_72865_6_, boolean p_72865_7_) {
            return this.original.func_72865_a(p_72865_1_, p_72865_2_, p_72865_3_, p_72865_4_, p_72865_5_, p_72865_6_, p_72865_7_);
        }

        public PathEntity func_72844_a(Entity p_72844_1_, int p_72844_2_, int p_72844_3_, int p_72844_4_, float p_72844_5_, boolean p_72844_6_, boolean p_72844_7_, boolean p_72844_8_, boolean p_72844_9_) {
            return this.original.func_72844_a(p_72844_1_, p_72844_2_, p_72844_3_, p_72844_4_, p_72844_5_, p_72844_6_, p_72844_7_, p_72844_8_, p_72844_9_);
        }

        public int func_72879_k(int x, int y, int z, int directionIn) {
            return this.original.func_72879_k(x, y, z, directionIn);
        }

        public int func_94577_B(int x, int y, int z) {
            return this.original.func_94577_B(x, y, z);
        }

        public boolean func_94574_k(int x, int y, int z, int directionIn) {
            return this.original.func_94574_k(x, y, z, directionIn);
        }

        public int func_72878_l(int x, int y, int z, int directionIn) {
            return this.original.func_72878_l(x, y, z, directionIn);
        }

        public boolean func_72864_z(int x, int y, int z) {
            return this.original.func_72864_z(x, y, z);
        }

        public int func_94572_D(int x, int y, int z) {
            return this.original.func_94572_D(x, y, z);
        }

        public EntityPlayer func_72890_a(Entity entityIn, double distance) {
            return this.original.func_72890_a(entityIn, distance);
        }

        public EntityPlayer func_72977_a(double x, double y, double z, double distance) {
            return this.original.func_72977_a(x, y, z, distance);
        }

        public EntityPlayer func_72856_b(Entity entityIn, double distance) {
            return this.original.func_72856_b(entityIn, distance);
        }

        public EntityPlayer func_72846_b(double p_72846_1_, double p_72846_3_, double p_72846_5_, double p_72846_7_) {
            return this.original.func_72846_b(p_72846_1_, p_72846_3_, p_72846_5_, p_72846_7_);
        }

        public EntityPlayer func_72924_a(String name) {
            return this.original.func_72924_a(name);
        }

        public EntityPlayer func_152378_a(UUID uuid) {
            return this.original.func_152378_a(uuid);
        }

        public void func_72882_A() {
            this.original.func_72882_A();
        }

        public void func_72906_B() throws MinecraftException {
            this.original.func_72906_B();
        }

        public void func_82738_a(long p_82738_1_) {
            this.original.func_82738_a(p_82738_1_);
        }

        public long func_82737_E() {
            return this.original.func_82737_E();
        }

        public long func_72820_D() {
            return this.original.func_72820_D();
        }

        public void func_72877_b(long time) {
            this.original.func_72877_b(time);
        }

        public ChunkCoordinates func_72861_E() {
            return this.original.func_72861_E();
        }

        public void func_72950_A(int p_72950_1_, int p_72950_2_, int p_72950_3_) {
            this.original.func_72950_A(p_72950_1_, p_72950_2_, p_72950_3_);
        }

        public void func_72897_h(Entity entityIn) {
            this.original.func_72897_h(entityIn);
        }

        public boolean func_72962_a(EntityPlayer player, int x, int y, int z) {
            return this.original.func_72962_a(player, x, y, z);
        }

        public boolean canMineBlockBody(EntityPlayer par1EntityPlayer, int par2, int par3, int par4) {
            return this.original.canMineBlockBody(par1EntityPlayer, par2, par3, par4);
        }

        public void func_72960_a(Entity entityIn, byte p_72960_2_) {
            this.original.func_72960_a(entityIn, p_72960_2_);
        }

        public IChunkProvider func_72863_F() {
            return this.original.func_72863_F();
        }

        public void func_147452_c(int x, int y, int z, Block blockIn, int eventId, int eventParameter) {
            this.original.func_147452_c(x, y, z, blockIn, eventId, eventParameter);
        }

        public ISaveHandler func_72860_G() {
            return this.original.func_72860_G();
        }

        public GameRules func_82736_K() {
            return this.original.func_82736_K();
        }

        public void func_72854_c() {
            this.original.func_72854_c();
        }

        public float func_72819_i(float p_72819_1_) {
            return this.original.func_72819_i(p_72819_1_);
        }

        public void func_147442_i(float p_147442_1_) {
            this.original.func_147442_i(p_147442_1_);
        }

        public float func_72867_j(float p_72867_1_) {
            return this.original.func_72867_j(p_72867_1_);
        }

        public void func_72894_k(float strength) {
            this.original.func_72894_k(strength);
        }

        public boolean func_72911_I() {
            return this.original.func_72911_I();
        }

        public boolean func_72896_J() {
            return this.original.func_72896_J();
        }

        public boolean func_72951_B(int x, int y, int z) {
            return this.original.func_72951_B(x, y, z);
        }

        public boolean func_72958_C(int x, int y, int z) {
            return this.original.func_72958_C(x, y, z);
        }

        public void func_72823_a(String p_72823_1_, WorldSavedData p_72823_2_) {
            this.original.func_72823_a(p_72823_1_, p_72823_2_);
        }

        public WorldSavedData func_72943_a(Class<? extends WorldSavedData> p_72943_1_, String p_72943_2_) {
            return this.original.func_72943_a(p_72943_1_, p_72943_2_);
        }

        public int func_72841_b(String p_72841_1_) {
            return this.original.func_72841_b(p_72841_1_);
        }

        public void func_82739_e(int p_82739_1_, int p_82739_2_, int p_82739_3_, int p_82739_4_, int p_82739_5_) {
            this.original.func_82739_e(p_82739_1_, p_82739_2_, p_82739_3_, p_82739_4_, p_82739_5_);
        }

        public void func_72926_e(int p_72926_1_, int x, int y, int z, int p_72926_5_) {
            this.original.func_72926_e(p_72926_1_, x, y, z, p_72926_5_);
        }

        public void func_72889_a(EntityPlayer player, int p_72889_2_, int x, int y, int z, int p_72889_6_) {
            this.original.func_72889_a(player, p_72889_2_, x, y, z, p_72889_6_);
        }

        public int func_72800_K() {
            return this.original.func_72800_K();
        }

        public int func_72940_L() {
            return this.original.func_72940_L();
        }

        public Random func_72843_D(int p_72843_1_, int p_72843_2_, int p_72843_3_) {
            return this.original.func_72843_D(p_72843_1_, p_72843_2_, p_72843_3_);
        }

        public ChunkPosition func_147440_b(String type, int x, int y, int z) {
            return this.original.func_147440_b(type, x, y, z);
        }

        public boolean func_72806_N() {
            return this.original.func_72806_N();
        }

        public double func_72919_O() {
            return this.original.func_72919_O();
        }

        public CrashReportCategory func_72914_a(CrashReport report) {
            return this.original.func_72914_a(report);
        }

        public void func_147443_d(int p_147443_1_, int x, int y, int z, int blockDamage) {
            this.original.func_147443_d(p_147443_1_, x, y, z, blockDamage);
        }

        public Calendar func_83015_S() {
            return this.original.func_83015_S();
        }

        public void func_92088_a(double x, double y, double z, double motionX, double motionY, double motionZ, NBTTagCompound compund) {
            this.original.func_92088_a(x, y, z, motionX, motionY, motionZ, compund);
        }

        public Scoreboard func_96441_U() {
            return this.original.func_96441_U();
        }

        public void func_147453_f(int x, int yPos, int z, Block blockIn) {
            this.original.func_147453_f(x, yPos, z, blockIn);
        }

        public float func_147462_b(double x, double y, double z) {
            return this.original.func_147462_b(x, y, z);
        }

        public float func_147473_B(int x, int y, int z) {
            return this.original.func_147473_B(x, y, z);
        }

        public void func_147450_X() {
            this.original.func_147450_X();
        }

        public void addTileEntity(TileEntity entity) {
            this.original.addTileEntity(entity);
        }

        public boolean isSideSolid(int x, int y, int z, ForgeDirection side) {
            return this.original.isSideSolid(x, y, z, side);
        }

        public boolean isSideSolid(int x, int y, int z, ForgeDirection side, boolean _default) {
            return this.original.isSideSolid(x, y, z, side, _default);
        }

        public ImmutableSetMultimap<ChunkCoordIntPair, ForgeChunkManager.Ticket> getPersistentChunks() {
            return this.original.getPersistentChunks();
        }

        public int getBlockLightOpacity(int x, int y, int z) {
            return this.original.getBlockLightOpacity(x, y, z);
        }

        public int countEntities(EnumCreatureType type, boolean forSpawnCount) {
            return this.original.countEntities(type, forSpawnCount);
        }
    }

    private static class ProxyBlockAccess
    implements IBlockAccess {
        public IBlockAccess original;

        public ProxyBlockAccess(IBlockAccess world) {
            this.original = world;
        }

        public Block func_147439_a(int x, int y, int z) {
            return ProxyAccess.getBlock(this.original, x, y, z);
        }

        public TileEntity func_147438_o(int x, int y, int z) {
            return ProxyAccess.getTileEntity(this.original, x, y, z);
        }

        public int func_72805_g(int x, int y, int z) {
            return ProxyAccess.getMetadata(this.original, x, y, z);
        }

        public int func_72802_i(int arg0, int arg1, int arg2, int arg3) {
            return this.original.func_72802_i(arg0, arg1, arg2, arg3);
        }

        public int func_72879_k(int arg0, int arg1, int arg2, int arg3) {
            return this.original.func_72879_k(arg0, arg1, arg2, arg3);
        }

        public boolean func_147437_c(int arg0, int arg1, int arg2) {
            return this.original.func_147437_c(arg0, arg1, arg2);
        }

        public BiomeGenBase func_72807_a(int arg0, int arg1) {
            return this.original.func_72807_a(arg0, arg1);
        }

        public int func_72800_K() {
            return this.original.func_72800_K();
        }

        public boolean func_72806_N() {
            return this.original.func_72806_N();
        }

        public boolean isSideSolid(int arg0, int arg1, int arg2, ForgeDirection arg3, boolean arg4) {
            return this.original.isSideSolid(arg0, arg1, arg2, arg3, arg4);
        }
    }

    private static interface IProxyAccess {
        public Block getBlock(int var1, int var2, int var3);

        public TileEntity getTileEntity(int var1, int var2, int var3);

        public int getBlockMetadata(int var1, int var2, int var3);

        public boolean setBlockMetadataWithNotify(int var1, int var2, int var3, int var4, int var5);

        public boolean setBlock(int var1, int var2, int var3, Block var4, int var5, int var6);

        public WorldInfo getWorldInfo();

        public WorldInfo getSeed();

        public void calculateInitialSkylight();

        public void calculateInitialWeatherBody();
    }
}

