/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.finiteliquid;

import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.element.MergedVertex;
import net.malisis.core.renderer.element.shape.Cube;
import net.malisis.core.util.BlockState;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.util.ForgeDirection;

public class FiniteLiquidRenderer
extends MalisisRenderer {
    @Override
    protected void initialize() {
        this.shape = new Cube();
        this.shape.enableMergedVertexes();
    }

    @Override
    public void render() {
        if (this.world == null) {
            this.drawShape(new Cube());
            return;
        }
        this.initialize();
        this.shape.resetState();
        this.rp.renderAllFaces.set(false);
        if (this.world.func_147439_a(this.x, this.y + 1, this.z) == this.block) {
            this.drawShape(new Cube());
            return;
        }
        for (MergedVertex v : this.shape.getMergedVertexes(this.shape.getFace("top"))) {
            int[][] aom = v.getBase().getAoMatrix(ForgeDirection.UP);
            boolean air = false;
            float height = (float)this.blockMetadata / 16.0f;
            int count = 1;
            for (int i = 0; i < aom.length; ++i) {
                int oX = aom[i][0];
                int oY = aom[i][1] - 1;
                int oZ = aom[i][2];
                BlockState state = new BlockState(this.world, this.x + oX, this.y + oY, this.z + oZ);
                if (state.getBlock() == Blocks.field_150350_a && i != 1 || state.getBlock() != this.block) continue;
                height += (float)state.getMetadata() / 16.0f;
                ++count;
            }
            v.setY(air ? 0.0 : (double)(height / (float)count));
        }
        this.drawShape(this.shape, this.rp);
    }
}

