/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.element;

import java.util.HashMap;
import java.util.List;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.element.Vertex;
import net.malisis.core.renderer.icon.MalisisIcon;
import net.malisis.core.util.Vector;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class Face
implements ITransformable.Translate,
ITransformable.Rotate {
    protected String name;
    protected Vertex[] vertexes;
    protected RenderParameters params = new RenderParameters();
    private float[][] scratch;
    private static final int[] dirs = new int[]{Vertex.NORTH, Vertex.SOUTH, Vertex.EAST, Vertex.WEST, Vertex.UP, Vertex.DOWN};
    private static final String[] strdirs = new String[]{"North", "South", "East", "West", "Top", "Bottom"};

    public void reset() {
    }

    public Face(Vertex[] vertexes, RenderParameters params) {
        this.vertexes = vertexes;
        this.scratch = new float[vertexes.length][2];
        this.params = params != null ? params : this.params;
        this.setName(null);
    }

    public Face(Vertex ... vertexes) {
        this(vertexes, (RenderParameters)null);
    }

    public Face(List<Vertex> vertexes) {
        this(vertexes.toArray(new Vertex[0]), (RenderParameters)null);
    }

    public Face(Face face) {
        this(face, new RenderParameters(face.params));
    }

    public Face(Face face, RenderParameters params) {
        Vertex[] faceVertexes = face.getVertexes();
        this.vertexes = new Vertex[faceVertexes.length];
        this.scratch = new float[faceVertexes.length][2];
        for (int i = 0; i < faceVertexes.length; ++i) {
            this.vertexes[i] = new Vertex(faceVertexes[i]);
        }
        this.params = params != null ? params : this.params;
        this.name = face.name;
    }

    public void copy(Face f) {
        this.params.merge(f.params);
        boolean init = false;
        if (this.vertexes.length != f.vertexes.length) {
            this.vertexes = new Vertex[f.vertexes.length];
            this.scratch = new float[f.vertexes.length][2];
            init = true;
        }
        for (int i = 0; i < f.vertexes.length; ++i) {
            if (init) {
                this.vertexes[i] = new Vertex(f.vertexes[i]);
                continue;
            }
            this.vertexes[i].setState(f.vertexes[i]);
        }
        this.name = f.name;
    }

    public void setName(String name) {
        if (name == null) {
            name = "";
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
            for (int dir : dirs) {
                map.put(dir, 0);
                for (Vertex v : this.vertexes) {
                    if ((v.getDirectionFlags() & dir) == 0) continue;
                    map.put(dir, (Integer)map.get(dir) + 1);
                }
                if ((Integer)map.get(dir) != 4) continue;
                name = strdirs[Integer.numberOfTrailingZeros(dir)];
            }
        }
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public Vertex[] getVertexes() {
        return this.vertexes;
    }

    public Face setParameters(RenderParameters params) {
        this.params = params != null ? params : new RenderParameters();
        return this;
    }

    public RenderParameters getParameters() {
        return this.params;
    }

    public Face setColor(int color) {
        for (Vertex v : this.vertexes) {
            v.setColor(color);
        }
        return this;
    }

    public Face setAlpha(int alpha) {
        for (Vertex v : this.vertexes) {
            v.setAlpha(alpha);
        }
        return this;
    }

    public Face setBrightness(int brightness) {
        for (Vertex v : this.vertexes) {
            v.setBrightness(brightness);
        }
        return this;
    }

    public Face setTexture(IIcon icon) {
        return this.setTexture(icon, this.params.flipU.get(), this.params.flipV.get(), false);
    }

    public Face setStandardUV() {
        this.vertexes[0].setUV(0.0f, 0.0f);
        this.vertexes[1].setUV(0.0f, 1.0f);
        this.vertexes[2].setUV(1.0f, 1.0f);
        this.vertexes[3].setUV(1.0f, 0.0f);
        return this;
    }

    public Face interpolateUV() {
        float u = 0.0f;
        float v = 0.0f;
        float U = 1.0f;
        float V = 1.0f;
        for (Vertex vertex : this.vertexes) {
            vertex.setUV(this.interpolate(u, U, this.getFactorU(vertex), false), this.interpolate(v, V, this.getFactorV(vertex), false));
        }
        return this;
    }

    public Face setTexture(IIcon icon, boolean flippedU, boolean flippedV, boolean interpolate) {
        int i;
        if (icon == null) {
            return this;
        }
        float u = icon.func_94209_e();
        float v = icon.func_94206_g();
        float U = icon.func_94212_f();
        float V = icon.func_94210_h();
        for (i = 0; i < this.vertexes.length; ++i) {
            Vertex vertex = this.vertexes[i];
            double factorU = interpolate ? this.getFactorU(vertex) : vertex.getU();
            double factorV = interpolate ? this.getFactorV(vertex) : vertex.getV();
            int k = i;
            if (icon instanceof MalisisIcon) {
                k = (i + ((MalisisIcon)icon).getRotation()) % this.vertexes.length;
            }
            this.scratch[k][0] = this.interpolate(u, U, factorU, flippedU);
            this.scratch[k][1] = this.interpolate(v, V, factorV, flippedV);
        }
        for (i = 0; i < this.vertexes.length; ++i) {
            this.vertexes[i].setUV(this.scratch[i][0], this.scratch[i][1]);
        }
        return this;
    }

    private double getFactorU(Vertex vertex) {
        if (this.params.direction.get() == null) {
            return vertex.getU();
        }
        switch (this.params.direction.get()) {
            case EAST: 
            case WEST: {
                return vertex.getZ();
            }
            case NORTH: 
            case SOUTH: 
            case UP: 
            case DOWN: {
                return vertex.getX();
            }
        }
        return 0.0;
    }

    private double getFactorV(Vertex vertex) {
        if (this.params.direction.get() == null) {
            return vertex.getV();
        }
        switch (this.params.direction.get()) {
            case EAST: 
            case WEST: 
            case NORTH: 
            case SOUTH: {
                return 1.0 - vertex.getY();
            }
            case UP: 
            case DOWN: {
                return vertex.getZ();
            }
        }
        return 0.0;
    }

    private float interpolate(float min, float max, double factor, boolean flipped) {
        if (factor > 1.0) {
            factor = 1.0;
        }
        if (factor < 0.0) {
            factor = 0.0;
        }
        if (flipped) {
            factor = 1.0 - factor;
        }
        return min + (max - min) * (float)factor;
    }

    public Face factor(float fx, float fy, float fz) {
        for (Vertex v : this.vertexes) {
            if (v == null) continue;
            v.factorX(fx);
            v.factorY(fy);
            v.factorZ(fz);
        }
        return this;
    }

    @Override
    public void rotate(float angle, float x, float y, float z, float offsetX, float offsetY, float offsetZ) {
        this.rotateAroundX(angle * x, offsetX, offsetY, offsetZ);
        this.rotateAroundY(angle * y, offsetX, offsetY, offsetZ);
        this.rotateAroundZ(angle * z, offsetX, offsetY, offsetZ);
    }

    @Override
    public void translate(float x, float y, float z) {
        for (Vertex v : this.vertexes) {
            v.add(x, y, z);
        }
    }

    public void scale(float f) {
        this.scale(f, 0.5, 0.5, 0.5);
    }

    public void scale(float f, double x, double y, double z) {
        for (Vertex v : this.vertexes) {
            v.scale(f, x, y, z);
        }
    }

    public void rotateAroundX(double angle) {
        this.rotateAroundX(angle, 0.5, 0.5, 0.5);
    }

    public void rotateAroundX(double angle, double centerX, double centerY, double centerZ) {
        for (Vertex v : this.vertexes) {
            v.rotateAroundX(angle, centerX, centerY, centerZ);
        }
    }

    public void rotateAroundY(double angle) {
        this.rotateAroundY(angle, 0.5, 0.5, 0.5);
    }

    public void rotateAroundY(double angle, double centerX, double centerY, double centerZ) {
        for (Vertex v : this.vertexes) {
            v.rotateAroundY(angle, centerX, centerY, centerZ);
        }
    }

    public void rotateAroundZ(double angle) {
        this.rotateAroundZ(angle, 0.5, 0.5, 0.5);
    }

    public void rotateAroundZ(double angle, double centerX, double centerY, double centerZ) {
        for (Vertex v : this.vertexes) {
            v.rotateAroundZ(angle, centerX, centerY, centerZ);
        }
    }

    public int[][][] calculateAoMatrix(ForgeDirection offset) {
        int[][][] aoMatrix = new int[this.vertexes.length][3][3];
        for (int i = 0; i < this.vertexes.length; ++i) {
            aoMatrix[i] = this.vertexes[i].getAoMatrix(offset);
        }
        return aoMatrix;
    }

    public Vector[] getVertexNormals() {
        Vector[] normals = new Vector[this.vertexes.length];
        int i = 0;
        for (Vertex v : this.vertexes) {
            normals[i++] = new Vector(v.getX(), v.getY(), v.getZ());
        }
        return normals;
    }

    public void calculateNormal() {
        this.calculateNormal(this.getVertexNormals());
    }

    public Vector calculateNormal(Vector[] normals) {
        if (normals == null || normals.length != this.vertexes.length) {
            normals = this.getVertexNormals();
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (int i = 0; i < this.vertexes.length; ++i) {
            Vertex current = this.vertexes[i];
            Vertex next = this.vertexes[(i + 1) % this.vertexes.length];
            x += (current.getY() - next.getY()) * (current.getZ() + next.getZ());
            y += (current.getZ() - next.getZ()) * (current.getX() + next.getX());
            z += (current.getX() - next.getX()) * (current.getY() + next.getY());
        }
        int factor = 1000;
        Vector normal = new Vector((float)Math.round(x * (double)factor) / (float)factor, (float)Math.round(y * (double)factor) / (float)factor, (float)Math.round(z * (double)factor) / (float)factor);
        normal.normalize();
        return normal;
    }

    public void deductParameters() {
        this.deductParameters(this.getVertexNormals());
    }

    public void deductParameters(Vector[] normals) {
        Vector normal = this.calculateNormal(normals);
        ForgeDirection dir = ForgeDirection.UNKNOWN;
        if (normal.x == 0.0 && normal.y == 0.0) {
            if (normal.z == 1.0) {
                dir = ForgeDirection.SOUTH;
            } else if (normal.z == -1.0) {
                dir = ForgeDirection.NORTH;
            }
        } else if (normal.x == 0.0 && normal.z == 0.0) {
            if (normal.y == 1.0) {
                dir = ForgeDirection.UP;
            } else if (normal.y == -1.0) {
                dir = ForgeDirection.DOWN;
            }
        } else if (normal.y == 0.0 && normal.z == 0.0) {
            if (normal.x == 1.0) {
                dir = ForgeDirection.EAST;
            } else if (normal.x == -1.0) {
                dir = ForgeDirection.WEST;
            }
        }
        this.params.direction.set(dir);
        this.params.textureSide.set(dir);
        this.params.aoMatrix.set(this.calculateAoMatrix(dir));
        float f = (float)(normal.x * normal.x * 0.6 + normal.y * (normal.y * 3.0 + 1.0) / 4.0 + normal.z * normal.z * 0.8);
        this.params.colorFactor.set(Float.valueOf(f));
    }

    public String toString() {
        String s = this.name() + " {";
        for (Vertex v : this.vertexes) {
            s = s + v + ", ";
        }
        return s + "}";
    }

    public static String nameFromDirection(ForgeDirection dir) {
        if (dir == ForgeDirection.UP) {
            return "top";
        }
        if (dir == ForgeDirection.DOWN) {
            return "bottom";
        }
        return dir.toString();
    }
}

