/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.interaction;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Iterator;
import net.malisis.core.client.gui.ClipArea;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.IClipable;
import net.malisis.core.client.gui.component.IGuiText;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.control.IScrollable;
import net.malisis.core.client.gui.component.control.UIScrollBar;
import net.malisis.core.client.gui.component.control.UISlimScrollbar;
import net.malisis.core.client.gui.element.GuiShape;
import net.malisis.core.client.gui.element.SimpleGuiShape;
import net.malisis.core.client.gui.element.XResizableGuiShape;
import net.malisis.core.client.gui.element.XYResizableGuiShape;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.client.gui.icon.GuiIcon;
import net.malisis.core.renderer.font.FontRenderOptions;
import net.malisis.core.renderer.font.MalisisFont;
import net.minecraft.util.IIcon;
import org.apache.commons.lang3.StringUtils;

public class UISelect<T>
extends UIComponent<UISelect<T>>
implements Iterable<Option<T>>,
IClipable,
IGuiText<UISelect<T>>,
IScrollable {
    protected MalisisFont font = MalisisFont.minecraftFont;
    protected FontRenderOptions fro = new FontRenderOptions();
    protected FontRenderOptions hoveredFro = new FontRenderOptions();
    protected FontRenderOptions selectedFro = new FontRenderOptions();
    protected FontRenderOptions disabledFro = new FontRenderOptions();
    protected FluentIterable<Option<T>> options;
    protected Option<T> selectedOption = null;
    protected int maxExpandedWidth = -1;
    protected int maxDisplayedOptions = Integer.MAX_VALUE;
    protected boolean expanded = false;
    protected int optionsWidth = 0;
    protected int optionsHeight = 0;
    protected String labelPattern;
    protected Function<T, ? extends Option<T>> optionFunction;
    protected Function<T, String> labelFunction = Functions.toStringFunction();
    protected Predicate<T> disablePredicate = Predicates.alwaysFalse();
    private Function<T, Option<T>> toOption = new Function<T, Option<T>>(){

        public Option<T> apply(T input) {
            Option option = UISelect.this.optionFunction != null ? (Option)UISelect.this.optionFunction.apply(input) : new Option(input);
            option.setLabel((String)UISelect.this.labelFunction.apply(input));
            option.setDisabled(UISelect.this.disablePredicate.apply(input));
            return option;
        }
    };
    protected UISlimScrollbar scrollbar;
    protected int optionOffset;
    protected int bgColor = 0xFFFFFF;
    protected int hoverBgColor = 6191263;
    protected GuiShape arrowShape;
    protected GuiShape optionsShape;
    protected GuiShape optionBackground;
    protected GuiIcon iconsSelect;
    protected GuiIcon iconsSelectDisabled;
    protected GuiIcon iconsExpanded;
    protected GuiIcon arrowIcon;

    public UISelect(MalisisGui gui, int width, Iterable<T> values) {
        super(gui);
        this.setSize(width, 12);
        this.setOptions(values);
        this.fro.color = 0xFFFFFF;
        this.fro.shadow = true;
        this.hoveredFro.color = 14604447;
        this.hoveredFro.shadow = true;
        this.selectedFro.color = 10397919;
        this.selectedFro.shadow = true;
        this.disabledFro.color = 0x444444;
        this.scrollbar = new UISlimScrollbar(gui, this, UIScrollBar.Type.VERTICAL);
        this.scrollbar.setFade(false);
        this.scrollbar.setAutoHide(true);
        this.scrollbar.setOffset(0, 12);
        this.shape = new XResizableGuiShape(3);
        this.arrowShape = new SimpleGuiShape();
        this.arrowShape.setSize(7.0f, 4.0f);
        this.arrowShape.storeState();
        this.optionsShape = new XYResizableGuiShape(1);
        this.optionBackground = new SimpleGuiShape();
        this.iconsSelect = gui.getGuiTexture().getXResizableIcon(200, 30, 9, 12, 3);
        this.iconsSelectDisabled = gui.getGuiTexture().getXResizableIcon(200, 42, 9, 12, 3);
        this.iconsExpanded = gui.getGuiTexture().getXYResizableIcon(200, 30, 9, 12, 1);
        this.arrowIcon = gui.getGuiTexture().getIcon(209, 48, 7, 4);
    }

    public UISelect(MalisisGui gui, int width) {
        this(gui, width, null);
    }

    @Override
    public int getHeight() {
        return this.expanded ? this.optionsHeight : super.getHeight();
    }

    @Override
    public MalisisFont getFont() {
        return this.font;
    }

    @Override
    public UISelect<T> setFont(MalisisFont font) {
        this.font = font;
        this.calcOptionsSize();
        return this;
    }

    @Override
    public FontRenderOptions getFontRenderOptions() {
        return this.fro;
    }

    @Override
    public UISelect<T> setFontRenderOptions(FontRenderOptions fro) {
        this.fro = fro;
        this.calcOptionsSize();
        return this;
    }

    public FontRenderOptions getHoveredFontRendererOptions() {
        return this.hoveredFro;
    }

    public UISelect<T> setSelectedFontRendererOptions(FontRenderOptions fro) {
        this.selectedFro = fro;
        return this;
    }

    public FontRenderOptions getSelectedFontRendererOptions() {
        return this.selectedFro;
    }

    public UISelect<T> setDisabledFontRendererOptions(FontRenderOptions fro) {
        this.disabledFro = fro;
        return this;
    }

    public FontRenderOptions getDisabledFontRendererOptions() {
        return this.disabledFro;
    }

    public UISelect<T> setHoveredFontRendererOptions(FontRenderOptions fro) {
        this.hoveredFro = fro;
        return this;
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public UISelect<T> setBgColor(int bgColor) {
        this.bgColor = bgColor;
        return this;
    }

    public int getHoverBgColor() {
        return this.hoverBgColor;
    }

    public UISelect<T> setHoverBgColor(int hoverBgColor) {
        this.hoverBgColor = hoverBgColor;
        return this;
    }

    public UISelect<T> setColors(int bgColor, int hoverBgColor) {
        this.bgColor = bgColor;
        this.hoverBgColor = hoverBgColor;
        return this;
    }

    public UISelect<T> setOptionFunction(Function<T, ? extends Option<T>> func) {
        this.optionFunction = func;
        return this;
    }

    public UISelect<T> setLabelFunction(Function<T, String> func) {
        if (func == null) {
            func = Functions.toStringFunction();
        }
        this.labelFunction = func;
        this.calcOptionsSize();
        return this;
    }

    public UISelect<T> setDisablePredicate(Predicate<T> predicate) {
        if (predicate == null) {
            predicate = Predicates.alwaysFalse();
        }
        this.disablePredicate = predicate;
        return this;
    }

    @Override
    public void setFocused(boolean focused) {
        super.setFocused(focused);
        if (!focused && this.expanded) {
            this.expanded = false;
            this.scrollbar.updateScrollbar();
        }
    }

    public UISelect<T> setLabelPattern(String labelPattern) {
        this.labelPattern = labelPattern;
        this.calcOptionsSize();
        return this;
    }

    public UISelect<T> setMaxExpandedWidth(int width) {
        this.maxExpandedWidth = width;
        this.calcOptionsSize();
        return this;
    }

    private void calcOptionsSize() {
        this.optionsWidth = this.getWidth() - 4;
        for (Option<T> option : this) {
            this.optionsWidth = Math.max(this.optionsWidth, (int)MalisisFont.minecraftFont.getStringWidth(option.getLabel(this.labelPattern)));
        }
        this.optionsWidth += 4;
        if (this.maxExpandedWidth > 0) {
            this.optionsWidth = Math.min(this.maxExpandedWidth, this.optionsWidth);
        }
    }

    public UISelect<T> maxDisplayedOptions(int amount) {
        this.maxDisplayedOptions = amount;
        this.calcOptionsSize();
        return this;
    }

    public UISelect<T> setOptions(Iterable<T> values) {
        if (values == null) {
            values = Collections.EMPTY_LIST;
        }
        this.options = FluentIterable.from((Iterable)values).transform(this.toOption);
        this.calcOptionsSize();
        return this;
    }

    public Option<T> getOption(T obj) {
        for (Option<T> opt : this) {
            if (obj != opt.getKey()) continue;
            return opt;
        }
        return null;
    }

    public void setSelectedOption(T obj) {
        this.setSelectedOption(this.getOption(obj));
    }

    public void setSelectedOption(Option<T> option) {
        this.selectedOption = option;
    }

    public Option<T> getSelectedOption() {
        return this.selectedOption;
    }

    public T getSelectedValue() {
        Option<T> opt = this.getSelectedOption();
        if (opt == null) {
            return null;
        }
        return opt.getKey();
    }

    public T select(Option<T> option) {
        Object value;
        if (option == null || option.isDisabled()) {
            return this.getSelectedValue();
        }
        Object t = value = option != null ? (Object)option.getKey() : null;
        if (option.equals(this.selectedOption)) {
            return value;
        }
        if (this.fireEvent(new SelectEvent<Object>(this, value))) {
            this.setSelectedOption(option);
        }
        if (this.expanded && this.maxDisplayedOptions < this.options.size()) {
            int i = this.getSelectedIndex();
            if (i < this.optionOffset) {
                this.optionOffset = i;
            } else if (i >= this.optionOffset + this.maxDisplayedOptions) {
                this.optionOffset = i - this.maxDisplayedOptions + 1;
            }
            this.optionOffset = Math.max(0, Math.min(this.options.size() - this.maxDisplayedOptions, this.optionOffset));
        }
        return this.getSelectedValue();
    }

    public T select(T obj) {
        return (T)this.select((T)this.getOption(obj));
    }

    public T selectFirst() {
        return (T)this.select((T)((Option)Iterables.getFirst(this.options, null)));
    }

    public T selectLast() {
        return (T)this.select((T)((Option)Iterables.getLast(this.options, null)));
    }

    public T selectPrevious() {
        if (this.selectedOption == null) {
            return this.selectFirst();
        }
        Option<T> option = null;
        for (Option<T> opt : this) {
            if (opt.isDisabled()) continue;
            if (opt.equals(this.selectedOption)) {
                return (T)this.select((T)option);
            }
            option = opt;
        }
        return null;
    }

    public T selectNext() {
        if (this.selectedOption == null) {
            return this.selectFirst();
        }
        Option<T> option = null;
        for (Option<T> opt : this) {
            if (opt.isDisabled()) continue;
            if (this.selectedOption.equals(option)) {
                return (T)this.select((T)opt);
            }
            option = opt;
        }
        return null;
    }

    protected Option<T> getOptionAt(int mouseX, int mouseY) {
        if (!this.isInsideBounds(mouseX, mouseY)) {
            return null;
        }
        int y = this.relativeY(mouseY - 13);
        if (y < 0) {
            return null;
        }
        int cy = 0;
        for (int i = this.optionOffset; i < this.optionOffset + this.maxDisplayedOptions && i < this.options.size(); ++i) {
            Option option = (Option)this.options.get(i);
            if (cy + option.getHeight(this) > y) {
                return option;
            }
            cy += option.getHeight(this);
        }
        return null;
    }

    protected int getSelectedIndex() {
        if (this.selectedOption == null) {
            return 0;
        }
        for (int i = 0; i < this.options.size(); ++i) {
            if (!((Option)this.options.get(i)).equals(this.selectedOption)) continue;
            return i;
        }
        return 0;
    }

    @Override
    public boolean isInsideBounds(int x, int y) {
        if (super.isInsideBounds(x, y)) {
            return true;
        }
        if (!this.expanded || !this.isVisible()) {
            return false;
        }
        return x >= this.screenX() && x <= this.screenX() + this.optionsWidth && y >= this.screenY() + 12 && y <= this.screenY() + 12 + this.optionsHeight;
    }

    @Override
    public int getZIndex() {
        return super.getZIndex() + (this.expanded ? 300 : 0);
    }

    @Override
    public ClipArea getClipArea() {
        return new ClipArea(this, this.screenX(), this.screenY(), this.screenX() + this.optionsWidth, this.screenY() + this.optionsHeight + 12, false);
    }

    @Override
    public void setClipContent(boolean clip) {
    }

    @Override
    public boolean shouldClipContent() {
        return this.expanded;
    }

    @Override
    public int getContentHeight() {
        if (!this.expanded || this.maxDisplayedOptions > this.options.size()) {
            return this.getHeight();
        }
        return this.optionsHeight * this.options.size();
    }

    @Override
    public int getContentWidth() {
        return 0;
    }

    @Override
    public float getOffsetX() {
        return 0.0f;
    }

    @Override
    public void setOffsetX(float offsetX, int delta) {
    }

    @Override
    public float getOffsetY() {
        return (float)this.optionOffset / (float)(this.options.size() - this.maxDisplayedOptions);
    }

    @Override
    public void setOffsetY(float offsetY, int delta) {
        this.optionOffset = Math.round(offsetY / this.getScrollStep());
        this.optionOffset = Math.max(0, Math.min(this.options.size() - this.maxDisplayedOptions, this.optionOffset));
    }

    @Override
    public float getScrollStep() {
        return 1.0f / (float)(this.options.size() - this.maxDisplayedOptions);
    }

    @Override
    public int getVerticalPadding() {
        return 1;
    }

    @Override
    public int getHorizontalPadding() {
        return 1;
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        this.shape.resetState();
        this.shape.setSize(super.getWidth(), super.getHeight());
        this.rp.icon.set((IIcon)(this.isDisabled() ? this.iconsSelectDisabled : this.iconsSelect));
        this.rp.colorMultiplier.set(this.bgColor);
        renderer.drawShape(this.shape, this.rp);
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        this.optionsHeight = 10 * Math.min(this.options.size(), this.maxDisplayedOptions) + 2;
        if (this.optionsHeight < 10) {
            this.optionsHeight = 10;
        }
        if (this.selectedOption != null) {
            this.select(this.selectedOption.getKey());
        }
        this.arrowShape.resetState();
        this.arrowShape.setPosition(this.width - 9, 4.0f);
        if (this.isHovered() || this.expanded) {
            this.rp.colorMultiplier.set(12503295);
        } else {
            this.rp.colorMultiplier.reset();
        }
        this.rp.icon.set((IIcon)this.arrowIcon);
        renderer.drawShape(this.arrowShape, this.rp);
        if (this.selectedOption != null) {
            this.selectedOption.draw(this, renderer, 2, 2, 2, partialTick, false, true);
        }
        if (!this.expanded) {
            return;
        }
        renderer.next();
        ClipArea area = this.getClipArea();
        renderer.startClipping(area);
        this.optionsShape.resetState();
        this.optionsShape.setSize(this.optionsWidth, this.optionsHeight);
        this.optionsShape.translate(0.0f, 12.0f, 1.0f);
        this.rp.icon.set((IIcon)this.iconsExpanded);
        this.rp.colorMultiplier.set(this.bgColor);
        renderer.drawShape(this.optionsShape, this.rp);
        renderer.next();
        int y = 14;
        Option<T> hover = this.getOptionAt(mouseX, mouseY);
        for (int i = this.optionOffset; i < this.optionOffset + this.maxDisplayedOptions && i < this.options.size(); ++i) {
            Option option = (Option)this.options.get(i);
            option.draw(this, renderer, 0, y, 0, partialTick, option.equals(hover), false);
            y += option.getHeight(this);
        }
        renderer.endClipping(area);
    }

    @Override
    public boolean onClick(int x, int y) {
        if (!this.expanded) {
            this.expanded = true;
            this.optionOffset = Math.max(0, Math.min(this.options.size() - this.maxDisplayedOptions, this.getSelectedIndex()));
            this.scrollbar.updateScrollbar();
            return true;
        }
        Option<T> opt = this.getOptionAt(x, y);
        if (opt != null) {
            if (opt.isDisabled()) {
                this.setFocused(true);
                return true;
            }
            this.select((T)opt);
        }
        this.expanded = false;
        this.scrollbar.updateScrollbar();
        this.setFocused(true);
        return true;
    }

    @Override
    public boolean onScrollWheel(int x, int y, int delta) {
        if (!this.isFocused() || this.maxDisplayedOptions < this.options.size()) {
            return super.onScrollWheel(x, y, delta);
        }
        if (delta < 0) {
            this.selectNext();
        } else {
            this.selectPrevious();
        }
        return true;
    }

    @Override
    public boolean onKeyTyped(char keyChar, int keyCode) {
        if (!this.isFocused()) {
            return super.onKeyTyped(keyChar, keyCode);
        }
        switch (keyCode) {
            case 200: {
                this.selectPrevious();
                break;
            }
            case 208: {
                this.selectNext();
                break;
            }
            case 199: {
                this.selectFirst();
                break;
            }
            case 207: {
                this.selectLast();
                break;
            }
            default: {
                return super.onKeyTyped(keyChar, keyCode);
            }
        }
        return true;
    }

    @Override
    public Iterator<Option<T>> iterator() {
        return this.options.iterator();
    }

    public static class Option<T> {
        private T key;
        private String label;
        private boolean disabled;

        public Option(T key) {
            this.key = key;
        }

        public Option(T key, String label) {
            this.key = key;
            this.label = label;
        }

        public T getKey() {
            return this.key;
        }

        public String getLabel(String pattern) {
            if (pattern == null) {
                return this.label;
            }
            return String.format(pattern, this.label);
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public void setDisabled(boolean disabled) {
            this.disabled = disabled;
        }

        public int getHeight(UISelect select) {
            return (int)(select.font.getStringHeight(select.fro) + 1.0f);
        }

        public void draw(UISelect select, GuiRenderer renderer, int x, int y, int z, float partialTick, boolean hovered, boolean isTop) {
            String text = this.getLabel(select.labelPattern);
            if (StringUtils.isEmpty((CharSequence)text)) {
                return;
            }
            if (hovered && !this.disabled) {
                renderer.drawRectangle(x + 1, y - 1, z + 2, select.optionsWidth - 2, this.getHeight(select), select.getHoverBgColor(), 255);
            }
            if (isTop) {
                text = MalisisFont.minecraftFont.clipString(text, select.getWidth() - 15);
            }
            FontRenderOptions fro = select.getFontRenderOptions();
            if (this.equals(select.getSelectedOption()) && !isTop) {
                fro = select.getSelectedFontRendererOptions();
            }
            if (hovered) {
                fro = select.getHoveredFontRendererOptions();
            }
            if (this.disabled) {
                fro = select.getDisabledFontRendererOptions();
            }
            renderer.drawText(select.font, text, x + 2, y, z + 2, fro);
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof Option && this.key.equals(((Option)obj).key);
        }
    }

    public static class SelectEvent<T>
    extends ComponentEvent.ValueChange<UISelect, T> {
        public SelectEvent(UISelect<T> component, T newValue) {
            super(component, component.getSelectedValue(), newValue);
        }
    }
}

