/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.decoration;

import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.GuiTexture;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.element.SimpleGuiShape;
import net.malisis.core.renderer.icon.MalisisIcon;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public class UIImage
extends UIComponent<UIImage> {
    public static final ResourceLocation BLOCKS_TEXTURE = TextureMap.field_110575_b;
    public static final ResourceLocation ITEMS_TEXTURE = TextureMap.field_110576_c;
    private GuiTexture texture;
    private IIcon icon = null;
    private ItemStack itemStack;

    public UIImage(MalisisGui gui, GuiTexture texture, IIcon icon) {
        super(gui);
        this.setIcon(texture, icon);
        this.setSize(16, 16);
        this.shape = new SimpleGuiShape();
    }

    public UIImage(MalisisGui gui, ItemStack itemStack) {
        super(gui);
        this.setItemStack(itemStack);
        this.setSize(16, 16);
        this.shape = new SimpleGuiShape();
    }

    public UIImage setIcon(IIcon icon) {
        this.itemStack = null;
        this.icon = icon != null ? icon : new MalisisIcon();
        return this;
    }

    public UIImage setIcon(GuiTexture texture, IIcon icon) {
        this.itemStack = null;
        this.icon = icon != null ? icon : new MalisisIcon();
        this.texture = texture;
        return this;
    }

    public UIImage setItemStack(ItemStack itemStack) {
        this.icon = null;
        this.texture = null;
        this.itemStack = itemStack;
        this.setSize(16, 16);
        return this;
    }

    public IIcon getIcon() {
        return this.icon;
    }

    public GuiTexture getTexture() {
        return this.texture;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Override
    public UIImage setSize(int width, int height) {
        if (this.itemStack != null) {
            width = 16;
            height = 16;
        }
        return (UIImage)super.setSize(width, height);
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        if (this.icon != null) {
            this.rp.icon.set(this.icon);
            renderer.bindTexture(this.texture);
            renderer.drawShape(this.shape, this.rp);
        } else if (this.itemStack != null) {
            renderer.drawItemStack(this.itemStack);
        }
    }

    @Override
    public String getPropertyString() {
        return (this.itemStack != null ? this.itemStack : "texture : " + this.texture + ",  icon : " + this.icon) + super.getPropertyString();
    }
}

