/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.api.util;

import eu.usrv.legacylootgames.blocks.DungeonBrick;
import net.minecraft.world.World;
import ru.timeconqueror.lootgames.registry.LGBlocks;
import ru.timeconqueror.lootgames.utils.future.BlockPos;
import ru.timeconqueror.lootgames.utils.future.BlockState;
import ru.timeconqueror.lootgames.utils.future.WorldExt;

public class LootGameCleaner {
    private static final BlockState DUNGEON_FLOOR = BlockState.of(LGBlocks.DUNGEON_WALL, DungeonBrick.Type.FLOOR.ordinal());
    private static final BlockState SHIELDED_FLOOR = BlockState.of(LGBlocks.DUNGEON_WALL, DungeonBrick.Type.FLOOR_SHIELDED.ordinal());

    public static void resetUnbreakablePlayField(World world, BlockPos floorPos) {
        if (!LootGameCleaner.resetUnbreakableFieldsStartingFrom(world, floorPos)) {
            LootGameCleaner.resetUnbreakableFieldsStartingFrom(world, floorPos.north());
            LootGameCleaner.resetUnbreakableFieldsStartingFrom(world, floorPos.east());
            LootGameCleaner.resetUnbreakableFieldsStartingFrom(world, floorPos.south());
            LootGameCleaner.resetUnbreakableFieldsStartingFrom(world, floorPos.west());
        }
    }

    private static boolean resetUnbreakableFieldsStartingFrom(World world, BlockPos blockPos) {
        BlockState state = WorldExt.getBlockState(world, blockPos);
        if (state.equals(SHIELDED_FLOOR)) {
            WorldExt.setBlockState(world, blockPos, DUNGEON_FLOOR);
            LootGameCleaner.resetUnbreakableFieldsStartingFrom(world, blockPos.north());
            LootGameCleaner.resetUnbreakableFieldsStartingFrom(world, blockPos.east());
            LootGameCleaner.resetUnbreakableFieldsStartingFrom(world, blockPos.south());
            LootGameCleaner.resetUnbreakableFieldsStartingFrom(world, blockPos.west());
            return true;
        }
        return false;
    }
}

