/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.utils;

import com.jamesswafford.chess4j.board.Board;
import com.jamesswafford.chess4j.board.Move;
import com.jamesswafford.chess4j.board.MoveGen;
import com.jamesswafford.chess4j.utils.PerftCallable;
import eu.usrv.yamcore.auxiliary.LogHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Perft {
    private static final Log LOGGERX = LogFactory.getLog(Perft.class);
    private static LogHelper mLog = new LogHelper("LootGames - ChessEngine");

    private Perft() {
    }

    public static long perft(Board b, int depth) {
        if (depth <= 0) {
            return 1L;
        }
        int processors = Runtime.getRuntime().availableProcessors();
        mLog.info((Object)("detected " + processors + " processors."));
        ExecutorService executor = Executors.newFixedThreadPool(processors);
        ArrayList<Future<Long>> futures = new ArrayList<Future<Long>>();
        List<Move> moves = MoveGen.genLegalMoves(b);
        for (Move m : moves) {
            Board b2 = b.deepCopy();
            b2.applyMove(m);
            PerftCallable perftCallable = new PerftCallable(b2, depth - 1);
            futures.add(executor.submit(perftCallable));
        }
        long n = 0L;
        for (Future future : futures) {
            try {
                n += ((Long)future.get()).longValue();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        return n;
    }
}

