/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.gui;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import logisticspipes.config.Configs;
import logisticspipes.interfaces.ISpecialItemRenderer;
import logisticspipes.utils.Color;
import logisticspipes.utils.gui.IItemSearch;
import logisticspipes.utils.gui.LogisticsBaseGuiScreen;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.item.ItemStackRenderer;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class ItemDisplay {
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/gui/icons.png");
    private static final int PANELSIZEX = 20;
    private static final int PANELSIZEY = 20;
    private ItemIdentifierStack selectedItem = null;
    public final LinkedList<ItemIdentifierStack> _allItems = new LinkedList();
    private final Map<Pair<Integer, Integer>, ItemIdentifierStack> map = new HashMap<Pair<Integer, Integer>, ItemIdentifierStack>();
    private int page = 0;
    private int maxPage = 0;
    private int requestCount = 1;
    private Object[] tooltip = null;
    private boolean listbyserver = false;
    private final IItemSearch search;
    private final FontRenderer fontRenderer;
    private final LogisticsBaseGuiScreen screen;
    private final ISpecialItemRenderer renderer;
    private int left;
    private int top;
    private int height;
    private int width;
    private int itemsPerPage;
    private final int[] amountChangeMode;
    private final boolean shiftPageChange;
    private final Minecraft mc = FMLClientHandler.instance().getClient();
    private static DisplayOption option = DisplayOption.ID;

    public ItemDisplay(IItemSearch search, FontRenderer fontRenderer, LogisticsBaseGuiScreen screen, ISpecialItemRenderer renderer, int left, int top, int width, int height, int[] amountChangeMode, boolean shiftPageChange) {
        this.search = search;
        this.fontRenderer = fontRenderer;
        this.screen = screen;
        this.renderer = renderer;
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
        this.itemsPerPage = this.width * this.height / 400;
        if (amountChangeMode.length != 4) {
            throw new UnsupportedOperationException("amountChangeMode.length needs to be 4");
        }
        this.amountChangeMode = amountChangeMode;
        this.shiftPageChange = shiftPageChange;
    }

    public void reposition(int left, int top, int width, int height) {
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
        this.itemsPerPage = this.width * this.height / 400;
    }

    public void setItemList(Collection<ItemIdentifierStack> allItems) {
        this.listbyserver = true;
        this._allItems.clear();
        this._allItems.addAll(allItems);
        this._allItems.sort(new StackComparitor());
        boolean found = false;
        if (this.selectedItem == null) {
            return;
        }
        for (ItemIdentifierStack itemStack : this._allItems) {
            if (!itemStack.getItem().equals(this.selectedItem.getItem())) continue;
            this.selectedItem = itemStack;
            found = true;
            break;
        }
        if (!found) {
            this.selectedItem = null;
        }
    }

    public void cycle() {
        int i = option.ordinal();
        if (++i >= DisplayOption.values().length) {
            i = 0;
        }
        option = DisplayOption.values()[i];
        this._allItems.sort(new StackComparitor());
    }

    public void renderSortMode(int x, int y) {
        String name = option.name();
        boolean up = true;
        if (name.endsWith("_DOWN")) {
            name = name.substring(0, name.length() - 5);
            up = false;
        }
        name = name + (!up ? " /\\" : " \\/");
        this.fontRenderer.func_78276_b(name, x - this.fontRenderer.func_78256_a(name) / 2, y, 0x404040);
    }

    public void renderPageNumber(int x, int y) {
        this.maxPage = (this.getSearchedItemNumber() - 1) / this.itemsPerPage;
        if (this.maxPage == -1) {
            this.maxPage = 0;
        }
        if (this.page > this.maxPage) {
            this.page = this.maxPage;
        }
        String pageString = "Page " + (this.page + 1) + " / " + (this.maxPage + 1);
        this.fontRenderer.func_78276_b(pageString, x - this.fontRenderer.func_78256_a(pageString) / 2, y, 0x404040);
    }

    private int getSearchedItemNumber() {
        int count = 0;
        for (ItemIdentifierStack item : this._allItems) {
            if (this.search != null && !this.search.itemSearched(item.getItem())) continue;
            ++count;
        }
        return count;
    }

    public void renderAmount(int x, int y, int stackAmount) {
        String StackrequestCount = "" + this.requestCount / stackAmount + "+" + this.requestCount % stackAmount;
        this.fontRenderer.func_78276_b(this.requestCount + "", x - this.fontRenderer.func_78256_a(this.requestCount + "") / 2, y, 0x404040);
        this.fontRenderer.func_78276_b(StackrequestCount + "", x - this.fontRenderer.func_78256_a(StackrequestCount + "") / 2, y + 10, 0x404040);
    }

    public void renderItemArea(double zLevel) {
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.screen.drawRect(this.left, this.top, this.left + this.width, this.top + this.height, Color.GREY);
        this.tooltip = null;
        int ppi = 0;
        int panelxSize = 20;
        int panelySize = 20;
        int x = 2;
        int y = 2;
        ScaledResolution scaledresolution = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        int scaleX = scaledresolution.func_78326_a();
        int scaleY = scaledresolution.func_78328_b();
        int mouseX = Mouse.getX() * scaleX / this.mc.field_71443_c - this.left;
        int mouseY = scaleY - Mouse.getY() * scaleY / this.mc.field_71440_d - this.top;
        GL11.glTranslatef((float)this.left, (float)this.top, (float)0.0f);
        if (!this.listbyserver) {
            int graphic = (int)(System.currentTimeMillis() / 250L) % 5;
            this.screen.getMC().field_71446_o.func_110577_a(TEXTURE);
            Tessellator tesselator = Tessellator.field_78398_a;
            tesselator.func_78382_b();
            int xPosition = this.width / 2 - 50;
            int yPosition = 40;
            tesselator.func_78374_a((double)xPosition, (double)(yPosition + 100), zLevel, 0.04, 0.72 + (double)graphic * 0.03125);
            tesselator.func_78374_a((double)(xPosition + 100), (double)(yPosition + 100), zLevel, 0.08, 0.72 + (double)graphic * 0.03125);
            tesselator.func_78374_a((double)(xPosition + 100), (double)yPosition, zLevel, 0.08, 0.69 + (double)graphic * 0.03125);
            tesselator.func_78374_a((double)xPosition, (double)yPosition, zLevel, 0.04, 0.69 + (double)graphic * 0.03125);
            tesselator.func_78381_a();
        } else {
            RenderHelper.func_74520_c();
            GL11.glEnable((int)32826);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GL11.glDisable((int)2929);
            GL11.glDisable((int)2896);
            for (ItemIdentifierStack itemIdentifierStack : this._allItems) {
                ItemIdentifier item = itemIdentifierStack.getItem();
                if (this.search != null && !this.search.itemSearched(item) || ++ppi <= this.itemsPerPage * this.page) continue;
                if (ppi > this.itemsPerPage * (this.page + 1)) break;
                ItemStack itemstack = itemIdentifierStack.unsafeMakeNormalStack();
                int realX = x - 2;
                int realY = y - 2;
                Pair<Integer, Integer> pair = new Pair<Integer, Integer>(realX, realY);
                if (this.map.get(pair) != itemIdentifierStack) {
                    this.map.put(pair, itemIdentifierStack);
                }
                if (mouseX >= realX && mouseX < realX + panelxSize && mouseY >= realY && mouseY < realY + panelySize) {
                    this.screen.drawRect(x - 2, y - 2, x + panelxSize - 2, y + panelySize - 2, Color.BLACK);
                    this.screen.drawRect(x - 1, y - 1, x + panelxSize - 3, y + panelySize - 3, Color.DARKER_GREY);
                    this.tooltip = new Object[]{mouseX + this.left, mouseY + this.top, itemstack};
                }
                if (this.selectedItem == itemIdentifierStack) {
                    this.screen.drawRect(x - 2, y - 2, x + panelxSize - 2, y + panelySize - 2, Color.BLACK);
                    this.screen.drawRect(x - 1, y - 1, x + panelxSize - 3, y + panelySize - 3, Color.LIGHTER_GREY);
                    this.screen.drawRect(x, y, x + panelxSize - 4, y + panelySize - 4, Color.DARKER_GREY);
                    if (this.renderer != null) {
                        this.renderer.specialItemRendering(itemIdentifierStack.getItem(), x, y);
                    }
                }
                ItemStackRenderer itemstackRenderer = new ItemStackRenderer(x, y, 100.0f, true, false, true);
                itemstackRenderer.setItemIdentifierStack(itemIdentifierStack).setDisplayAmount(ItemStackRenderer.DisplayAmount.HIDE_ONE);
                itemstackRenderer.renderInGui();
                if ((x += panelxSize) <= this.width) continue;
                x = 2;
                y += panelySize;
            }
            GL11.glEnable((int)2929);
        }
        GL11.glPopMatrix();
    }

    public void handleMouse() {
        boolean isShift = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
        boolean isControl = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
        int wheel = Mouse.getEventDWheel() / 120;
        if (wheel == 0) {
            return;
        }
        if (isShift && !isControl && this.isShiftPageChange()) {
            if (wheel > 0) {
                if (!Configs.LOGISTICS_ORDERER_PAGE_INVERTWHEEL) {
                    this.prevPage();
                } else {
                    this.nextPage();
                }
            } else if (!Configs.LOGISTICS_ORDERER_PAGE_INVERTWHEEL) {
                this.nextPage();
            } else {
                this.prevPage();
            }
        } else if (isShift && !isControl) {
            if (wheel > 0) {
                if (!Configs.LOGISTICS_ORDERER_COUNT_INVERTWHEEL) {
                    this.requestCount = Math.max(1, this.requestCount - wheel * this.getAmountChangeMode(4));
                } else {
                    if (this.requestCount == 1) {
                        --this.requestCount;
                    }
                    this.requestCount += wheel * this.getAmountChangeMode(4);
                }
            } else if (!Configs.LOGISTICS_ORDERER_COUNT_INVERTWHEEL) {
                if (this.requestCount == 1) {
                    --this.requestCount;
                }
                this.requestCount -= wheel * this.getAmountChangeMode(4);
            } else {
                this.requestCount = Math.max(1, this.requestCount + wheel * this.getAmountChangeMode(4));
            }
        } else if (!isControl) {
            this.requestCount = wheel > 0 ? (!Configs.LOGISTICS_ORDERER_COUNT_INVERTWHEEL ? Math.max(1, this.requestCount - wheel * this.getAmountChangeMode(1)) : (this.requestCount += wheel * this.getAmountChangeMode(1))) : (!Configs.LOGISTICS_ORDERER_COUNT_INVERTWHEEL ? (this.requestCount -= wheel * this.getAmountChangeMode(1)) : Math.max(1, this.requestCount + wheel * this.getAmountChangeMode(1)));
        } else if (!isShift) {
            if (wheel > 0) {
                if (!Configs.LOGISTICS_ORDERER_COUNT_INVERTWHEEL) {
                    this.requestCount = Math.max(1, this.requestCount - wheel * this.getAmountChangeMode(2));
                } else {
                    if (this.requestCount == 1) {
                        --this.requestCount;
                    }
                    this.requestCount += wheel * this.getAmountChangeMode(2);
                }
            } else if (!Configs.LOGISTICS_ORDERER_COUNT_INVERTWHEEL) {
                if (this.requestCount == 1) {
                    --this.requestCount;
                }
                this.requestCount += -wheel * this.getAmountChangeMode(2);
            } else {
                this.requestCount = Math.max(1, this.requestCount + wheel * this.getAmountChangeMode(2));
            }
        } else if (wheel > 0) {
            if (!Configs.LOGISTICS_ORDERER_COUNT_INVERTWHEEL) {
                this.requestCount = Math.max(1, this.requestCount - wheel * this.getAmountChangeMode(3));
            } else {
                if (this.requestCount == 1) {
                    --this.requestCount;
                }
                this.requestCount += wheel * this.getAmountChangeMode(3);
            }
        } else if (!Configs.LOGISTICS_ORDERER_COUNT_INVERTWHEEL) {
            if (this.requestCount == 1) {
                --this.requestCount;
            }
            this.requestCount += -wheel * this.getAmountChangeMode(3);
        } else {
            this.requestCount = Math.max(1, this.requestCount + wheel * this.getAmountChangeMode(3));
        }
    }

    private int getAmountChangeMode(int step) {
        return this.amountChangeMode[step - 1];
    }

    private boolean isShiftPageChange() {
        return this.shiftPageChange;
    }

    public Object[] getToolTip() {
        return this.tooltip;
    }

    public void resetAmount() {
        this.requestCount = 1;
    }

    public void setMaxAmount() {
        if (this.selectedItem != null && this.selectedItem.getStackSize() != 0) {
            this.requestCount = this.selectedItem.getStackSize();
        }
    }

    public void nextPage() {
        this.page = this.page < this.maxPage ? ++this.page : 0;
    }

    public void prevPage() {
        this.page = this.page > 0 ? --this.page : this.maxPage;
    }

    public void add(int i) {
        if (i != 1 && this.requestCount == 1) {
            --this.requestCount;
        }
        this.requestCount += this.getAmountChangeMode(i);
    }

    public void sub(int i) {
        this.requestCount = Math.max(1, this.requestCount - this.getAmountChangeMode(i));
    }

    public ItemIdentifierStack getSelectedItem() {
        return this.selectedItem;
    }

    public int getRequestCount() {
        return this.requestCount;
    }

    public boolean handleClick(int x, int y, int k) {
        if ((x -= this.left) < 0 || (y -= this.top) < 0 || x > this.width || y > this.height) {
            return false;
        }
        this.selectedItem = null;
        for (Map.Entry<Pair<Integer, Integer>, ItemIdentifierStack> entry : this.map.entrySet()) {
            if (x < entry.getKey().getValue1() || x >= entry.getKey().getValue1() + 20 || y < entry.getKey().getValue2() || y >= entry.getKey().getValue2() + 20) continue;
            this.selectedItem = entry.getValue();
            return true;
        }
        return false;
    }

    public int getPage() {
        return this.page;
    }

    private static class StackComparitor
    implements Comparator<ItemIdentifierStack> {
        private StackComparitor() {
        }

        @Override
        public int compare(ItemIdentifierStack o1, ItemIdentifierStack o2) {
            if (option == DisplayOption.ID) {
                int c = this.basicCompare(o1, o2);
                if (c != 0) {
                    return c;
                }
                return o2.getStackSize() - o1.getStackSize();
            }
            if (option == DisplayOption.ID_DOWN) {
                int c = this.basicCompare(o2, o1);
                if (c != 0) {
                    return c;
                }
                return o1.getStackSize() - o2.getStackSize();
            }
            if (option == DisplayOption.SIZE) {
                int c = o2.getStackSize() - o1.getStackSize();
                if (c != 0) {
                    return c;
                }
                return this.basicCompare(o1, o2);
            }
            if (option == DisplayOption.SIZE_DOWN) {
                int c = o1.getStackSize() - o2.getStackSize();
                if (c != 0) {
                    return c;
                }
                return this.basicCompare(o2, o1);
            }
            if (option == DisplayOption.NAME) {
                int c = o1.getItem().getFriendlyName().compareToIgnoreCase(o2.getItem().getFriendlyName());
                if (c != 0) {
                    return c;
                }
                c = this.basicCompare(o1, o2);
                if (c != 0) {
                    return c;
                }
                return o2.getStackSize() - o1.getStackSize();
            }
            if (option == DisplayOption.NAME_DOWN) {
                int c = o2.getItem().getFriendlyName().compareToIgnoreCase(o1.getItem().getFriendlyName());
                if (c != 0) {
                    return c;
                }
                c = this.basicCompare(o2, o1);
                if (c != 0) {
                    return c;
                }
                return o1.getStackSize() - o2.getStackSize();
            }
            int c = this.basicCompare(o1, o2);
            if (c != 0) {
                return c;
            }
            return o2.getStackSize() - o1.getStackSize();
        }

        private int basicCompare(ItemIdentifierStack o1, ItemIdentifierStack o2) {
            return o1.compareTo(o2);
        }
    }

    public static enum DisplayOption {
        ID,
        ID_DOWN,
        SIZE,
        SIZE_DOWN,
        NAME,
        NAME_DOWN;

    }
}

