/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer.newpipe;

import logisticspipes.renderer.newpipe.IRenderable;
import net.minecraft.client.renderer.GLAllocation;
import org.lwjgl.opengl.GL11;

public class GLRenderList
implements IRenderable {
    private final int listID = GLAllocation.func_74526_a((int)1);
    public boolean isValid = true;
    private long lastUsed = System.currentTimeMillis();
    private boolean isFilled = false;

    @Override
    public int getID() {
        return this.listID;
    }

    @Override
    public void startListCompile() {
        if (!this.isValid) {
            throw new UnsupportedOperationException("Can't use a removed list");
        }
        GL11.glNewList((int)this.listID, (int)4864);
    }

    @Override
    public void stopCompile() {
        if (!this.isValid) {
            throw new UnsupportedOperationException("Can't use a removed list");
        }
        GL11.glEndList();
        this.isFilled = true;
    }

    @Override
    public void render() {
        if (!this.isValid) {
            throw new UnsupportedOperationException("Can't use a removed list");
        }
        GL11.glCallList((int)this.listID);
        this.lastUsed = System.currentTimeMillis();
    }

    @Override
    public boolean check() {
        if (!this.isValid) {
            return true;
        }
        if (this.lastUsed + 60000L < System.currentTimeMillis()) {
            this.isValid = false;
            return false;
        }
        return true;
    }

    @Override
    public boolean isInvalid() {
        return !this.isValid;
    }

    @Override
    public boolean isFilled() {
        return this.isFilled;
    }

    @Override
    public void close() {
        GLAllocation.func_74523_b((int)this.listID);
        this.isValid = false;
    }
}

