/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialinventoryhandler;

import logisticspipes.proxy.specialinventoryhandler.DSULikeInventoryHandler;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public class DSUInventoryHandler
extends DSULikeInventoryHandler {
    private final IDeepStorageUnit _tile;

    private DSUInventoryHandler(TileEntity tile, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        this._tile = (IDeepStorageUnit)tile;
        this._hideOnePerStack = hideOnePerStack || hideOne;
    }

    public DSUInventoryHandler() {
        this._tile = null;
        this._hideOnePerStack = false;
    }

    @Override
    public boolean init() {
        return true;
    }

    @Override
    public boolean isType(TileEntity tile) {
        return tile instanceof IDeepStorageUnit;
    }

    @Override
    public SpecialInventoryHandler getUtilForTile(TileEntity tile, ForgeDirection dir, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        return new DSUInventoryHandler(tile, hideOnePerStack, hideOne, cropStart, cropEnd);
    }

    @Override
    boolean isEmpty() {
        return this._tile.getStoredItemType() == null;
    }

    @Override
    int getSize() {
        return this._tile.getMaxStoredCount();
    }

    @Override
    int getCurrent() {
        return this.isEmpty() ? 0 : this._tile.getStoredItemType().field_77994_a;
    }

    @Override
    ItemStack getType() {
        return this._tile.getStoredItemType();
    }

    @Override
    void setContent(int count) {
        this._tile.setStoredItemCount(count);
    }

    @Override
    void setContent(ItemStack stack, int size) {
        this._tile.setStoredItemType(stack, size);
    }

    @Override
    void markDirty() {
        ((TileEntity)this._tile).func_70296_d();
    }
}

