/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.hydroenergy.client.renderer;

import com.sinthoras.hydroenergy.client.renderer.HEProgram;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

public class HESortedRenderList {
    private static int[][] bucketsVaoIds = new int[49][541];
    private static int[][] bucketsNumWaterBlocks = new int[49][541];
    private static int[] bucketsIds = new int[49];
    private static int centerX = 0;
    private static int centerY = 0;
    private static int centerZ = 0;

    public static void setup(int chunkX, int chunkY, int chunkZ) {
        centerX = chunkX;
        centerY = chunkY;
        centerZ = chunkZ;
        for (int i = 0; i < bucketsIds.length; ++i) {
            HESortedRenderList.bucketsIds[i] = 0;
        }
    }

    public static void add(int vaoId, int numWaterBlocks, int chunkX, int chunkY, int chunkZ) {
        int distance = Math.abs(chunkX - centerX) + Math.abs(chunkY - centerY) + Math.abs(chunkZ - centerZ);
        HESortedRenderList.bucketsVaoIds[distance][HESortedRenderList.bucketsIds[distance]] = vaoId;
        HESortedRenderList.bucketsNumWaterBlocks[distance][HESortedRenderList.bucketsIds[distance]] = numWaterBlocks;
        int n = distance;
        bucketsIds[n] = bucketsIds[n] + 1;
    }

    public static void render() {
        for (int distance = bucketsIds.length - 1; distance >= 0; --distance) {
            int numVaos = bucketsIds[distance];
            if (numVaos == 0) continue;
            int[] vaoIds = bucketsVaoIds[distance];
            int[] numWaterBlocks = bucketsNumWaterBlocks[distance];
            for (int n = 0; n < numVaos; ++n) {
                GL30.glBindVertexArray((int)vaoIds[n]);
                HEProgram.setCullFronts();
                GL11.glDrawArrays((int)0, (int)0, (int)numWaterBlocks[n]);
                HEProgram.setCullBacks();
                GL11.glDrawArrays((int)0, (int)0, (int)numWaterBlocks[n]);
                GL30.glBindVertexArray((int)0);
            }
        }
    }
}

