/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gtnhintergalactic.render;

import com.gtnewhorizon.gtnhlib.client.renderer.shader.ShaderProgram;
import com.gtnewhorizons.gtnhintergalactic.block.BlockSpaceElevatorCable;
import com.gtnewhorizons.gtnhintergalactic.config.IGConfig;
import com.gtnewhorizons.gtnhintergalactic.tile.TileEntitySpaceElevatorCable;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.joml.Math;
import org.joml.Matrix4fStack;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;

public class RenderSpaceElevatorCable
extends TileEntitySpecialRenderer
implements ISimpleBlockRenderingHandler {
    private static final ResourceLocation climberTexture = new ResourceLocation("gtnhintergalactic", "textures/models/climber.png");
    private static IModelCustom modelCustom;
    private static final int CLIMBER_OFFSET = 50;
    private static final int MIN_CLIMBER_HEIGHT = 100;
    boolean isInitialized = false;
    private static final float LONG_DISTANCE;
    private static final float SHORT_DISTANCE = 0.18518518f;
    private static final double CABLE_HEIGHT = 512.0;
    private static final float[] edgeX;
    private static final float[] edgeZ;
    private static ShaderProgram cableProgram;
    private static int uModelProjectionMatrix;
    private static int uBlockTex;
    private static int uSectionHeight;
    private static int uTime;
    private static int uBaseY;
    private static int uGlowU;
    private static int uGlowV;
    private static int uUV;
    private static int aVertexID;
    private static int vertexIDBuffer;
    private static final FloatBuffer bufModelViewProjection;
    private static final Matrix4fStack modelProjection;
    private static final float SIDE = 0.37037036f;
    private static final float SECTION_HEIGHT = 2.9629629f;
    private static final int SECTIONS;
    private static final int VERTEX_COUNT;

    public RenderSpaceElevatorCable() {
        modelCustom = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("gtnhintergalactic", "models/climber.obj"));
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float timeSinceLastTick) {
        if (!IGConfig.spaceElevator.isCableRenderingEnabled) {
            return;
        }
        if (!(tile instanceof TileEntitySpaceElevatorCable)) {
            return;
        }
        TileEntitySpaceElevatorCable cableTile = (TileEntitySpaceElevatorCable)tile;
        if (!cableTile.shouldRender()) {
            return;
        }
        this.renderCable(tile, x, y, z, timeSinceLastTick);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5 + (double)cableTile.getClimberHeight() + (double)(50 + cableTile.field_145848_d < 100 ? 100 : 50)), (double)(z + 0.5));
        GL11.glRotated((double)cableTile.getClimberRotation(), (double)0.0, (double)1.0, (double)0.0);
        this.renderClimber();
        GL11.glPopMatrix();
    }

    private void renderClimber() {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.func_147499_a(climberTexture);
        GL11.glScaled((double)4.0, (double)4.0, (double)4.0);
        modelCustom.renderAll();
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2896);
    }

    private void renderCable(TileEntity tile, double x, double y, double z, float timeSinceLastTick) {
        GL13.glActiveTexture((int)33984);
        this.func_147499_a(TextureMap.field_110575_b);
        if (!this.isInitialized) {
            float minU = BlockSpaceElevatorCable.textures[0].func_94209_e();
            float maxU = BlockSpaceElevatorCable.textures[0].func_94212_f();
            float minV = BlockSpaceElevatorCable.textures[0].func_94206_g();
            float maxV = BlockSpaceElevatorCable.textures[0].func_94210_h();
            float glowMinU = Math.lerp((float)minU, (float)maxU, (float)0.4375f);
            float glowMaxU = Math.lerp((float)minU, (float)maxU, (float)0.5625f);
            float glowMinV = Math.lerp((float)minV, (float)maxV, (float)0.4375f);
            float glowMaxV = Math.lerp((float)minV, (float)maxV, (float)0.5625f);
            cableProgram = new ShaderProgram("gtnhintergalactic", "shaders/spacecable.vert.glsl", "shaders/spacecable.frag.glsl");
            cableProgram.use();
            aVertexID = cableProgram.getAttribLocation("vertexId");
            uModelProjectionMatrix = cableProgram.getUniformLocation("u_ModelProjection");
            uBlockTex = cableProgram.getUniformLocation("u_BlockTex");
            uSectionHeight = cableProgram.getUniformLocation("u_SectionHeight");
            uTime = cableProgram.getUniformLocation("u_Time");
            uBaseY = cableProgram.getUniformLocation("u_BaseY");
            uGlowU = cableProgram.getUniformLocation("u_GlowU");
            uGlowV = cableProgram.getUniformLocation("u_GlowV");
            uUV = cableProgram.getUniformLocation("u_UV");
            vertexIDBuffer = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)vertexIDBuffer);
            ByteBuffer vertexIDData = BufferUtils.createByteBuffer((int)(VERTEX_COUNT * 4 * 3));
            for (int i = 0; i < VERTEX_COUNT * 3; ++i) {
                vertexIDData.putFloat(i * 4, i);
            }
            GL15.glBufferData((int)34962, (ByteBuffer)vertexIDData, (int)35044);
            GL15.glBindBuffer((int)34962, (int)0);
            FloatBuffer uvBuffer = BufferUtils.createFloatBuffer((int)4);
            uvBuffer.put(0, minU);
            uvBuffer.put(1, minV);
            uvBuffer.put(2, maxU);
            uvBuffer.put(3, maxV);
            GL20.glUniform1f((int)uSectionHeight, (float)2.9629629f);
            GL20.glUniform1i((int)uBlockTex, (int)(OpenGlHelper.field_77478_a - 33984));
            GL20.glUniform2f((int)uGlowU, (float)glowMinU, (float)glowMaxU);
            GL20.glUniform2f((int)uGlowV, (float)glowMinV, (float)glowMaxV);
            GL20.glUniform2((int)uUV, (FloatBuffer)uvBuffer);
            ShaderProgram.clear();
            this.isInitialized = true;
        }
        cableProgram.use();
        GL20.glUniform1f((int)uTime, (float)(((float)(tile.func_145831_w().func_72912_H().func_82573_f() % 60L) + timeSinceLastTick) / 60.0f));
        GL20.glUniform1i((int)uBaseY, (int)((int)y - 23));
        modelProjection.identity();
        modelProjection.translate((float)x, (float)(y - 23.0), (float)z);
        GL11.glDisable((int)2884);
        modelProjection.get(0, bufModelViewProjection);
        GL20.glUniformMatrix4((int)uModelProjectionMatrix, (boolean)false, (FloatBuffer)bufModelViewProjection);
        GL15.glBindBuffer((int)34962, (int)vertexIDBuffer);
        GL20.glVertexAttribPointer((int)aVertexID, (int)1, (int)5126, (boolean)false, (int)0, (long)0L);
        GL20.glEnableVertexAttribArray((int)aVertexID);
        GL11.glVertexPointer((int)3, (int)5126, (int)0, (long)0L);
        GL11.glEnableClientState((int)32884);
        GL11.glDrawArrays((int)4, (int)0, (int)VERTEX_COUNT);
        GL11.glDisableClientState((int)32884);
        GL20.glDisableVertexAttribArray((int)aVertexID);
        GL15.glBindBuffer((int)34962, (int)0);
        GL11.glEnable((int)2884);
        ShaderProgram.clear();
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GL11.glPushMatrix();
        IIcon side = BlockSpaceElevatorCable.textures[0];
        Tessellator tes = Tessellator.field_78398_a;
        tes.func_78382_b();
        tes.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, side);
        tes.func_78381_a();
        tes.func_78382_b();
        tes.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, side);
        tes.func_78381_a();
        tes.func_78382_b();
        tes.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, side);
        tes.func_78381_a();
        tes.func_78382_b();
        tes.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, side);
        tes.func_78381_a();
        tes.func_78382_b();
        tes.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, side);
        tes.func_78381_a();
        tes.func_78382_b();
        tes.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, side);
        tes.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glPopMatrix();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntitySpaceElevatorCable && !((TileEntitySpaceElevatorCable)te).shouldRender()) {
            GL11.glPushMatrix();
            IIcon side = BlockSpaceElevatorCable.textures[0];
            float minU = side.func_94209_e();
            float maxU = side.func_94212_f();
            float minV = side.func_94206_g();
            float maxV = side.func_94210_h();
            Tessellator tes = Tessellator.field_78398_a;
            tes.func_78374_a((double)x, (double)y, (double)z, (double)maxU, (double)maxV);
            tes.func_78374_a((double)x, (double)(y + 1), (double)z, (double)maxU, (double)minV);
            tes.func_78374_a((double)(x + 1), (double)(y + 1), (double)z, (double)minU, (double)minV);
            tes.func_78374_a((double)(x + 1), (double)y, (double)z, (double)minU, (double)maxV);
            tes.func_78374_a((double)(x + 1), (double)y, (double)(z + 1), (double)maxU, (double)maxV);
            tes.func_78374_a((double)(x + 1), (double)(y + 1), (double)(z + 1), (double)maxU, (double)minV);
            tes.func_78374_a((double)x, (double)(y + 1), (double)(z + 1), (double)minU, (double)minV);
            tes.func_78374_a((double)x, (double)y, (double)(z + 1), (double)minU, (double)maxV);
            tes.func_78374_a((double)x, (double)y, (double)(z + 1), (double)maxU, (double)maxV);
            tes.func_78374_a((double)x, (double)(y + 1), (double)(z + 1), (double)maxU, (double)minV);
            tes.func_78374_a((double)x, (double)(y + 1), (double)z, (double)minU, (double)minV);
            tes.func_78374_a((double)x, (double)y, (double)z, (double)minU, (double)maxV);
            tes.func_78374_a((double)(x + 1), (double)y, (double)z, (double)maxU, (double)maxV);
            tes.func_78374_a((double)(x + 1), (double)(y + 1), (double)z, (double)maxU, (double)minV);
            tes.func_78374_a((double)(x + 1), (double)(y + 1), (double)(z + 1), (double)minU, (double)minV);
            tes.func_78374_a((double)(x + 1), (double)y, (double)(z + 1), (double)minU, (double)maxV);
            tes.func_78374_a((double)(x + 1), (double)y, (double)z, (double)maxU, (double)maxV);
            tes.func_78374_a((double)(x + 1), (double)y, (double)(z + 1), (double)maxU, (double)minV);
            tes.func_78374_a((double)x, (double)y, (double)(z + 1), (double)minU, (double)minV);
            tes.func_78374_a((double)x, (double)y, (double)z, (double)minU, (double)maxV);
            tes.func_78374_a((double)x, (double)(y + 1), (double)z, (double)maxU, (double)maxV);
            tes.func_78374_a((double)x, (double)(y + 1), (double)(z + 1), (double)maxU, (double)minV);
            tes.func_78374_a((double)(x + 1), (double)(y + 1), (double)(z + 1), (double)minU, (double)minV);
            tes.func_78374_a((double)(x + 1), (double)(y + 1), (double)z, (double)minU, (double)maxV);
            GL11.glPopMatrix();
            return true;
        }
        return false;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return BlockSpaceElevatorCable.getRenderID();
    }

    static {
        LONG_DISTANCE = (1.0f + Math.sqrt((float)2.0f)) / 5.4f;
        edgeX = new float[]{LONG_DISTANCE, LONG_DISTANCE, 0.18518518f, -0.18518518f, -LONG_DISTANCE, -LONG_DISTANCE, -0.18518518f, 0.18518518f};
        edgeZ = new float[]{0.18518518f, -0.18518518f, -LONG_DISTANCE, -LONG_DISTANCE, -0.18518518f, 0.18518518f, LONG_DISTANCE, LONG_DISTANCE};
        aVertexID = -1;
        vertexIDBuffer = -1;
        bufModelViewProjection = BufferUtils.createFloatBuffer((int)16);
        modelProjection = new Matrix4fStack(2);
        SECTIONS = (int)Math.ceil((double)172.80000566482562);
        VERTEX_COUNT = 192 * SECTIONS;
    }
}

