/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gravisuiteneo.util;

import com.gtnewhorizons.gravisuiteneo.common.Properties;
import gravisuite.GraviSuite;
import gravisuite.ServerProxy;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public class LevelableToolHelper {
    public static void AddXP(EntityPlayer player, ItemStack itemStack, int amount) {
        int nextLevel;
        double currentXP = LevelableToolHelper.readToolXP(itemStack);
        int currLevel = LevelableToolHelper.getLevel(currentXP);
        if (Double.MAX_VALUE - currentXP >= (double)amount) {
            currentXP += (double)amount;
        }
        if ((nextLevel = LevelableToolHelper.getLevel(currentXP)) > currLevel) {
            ServerProxy.sendPlayerMessage((EntityPlayer)player, (String)(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"message.xp.levelup")));
        }
        LevelableToolHelper.saveToolXP(itemStack, currentXP);
    }

    public static int getLevel(double xpValue) {
        return (int)Math.floor(Math.sqrt(xpValue / (double)Properties.AdvTweaks.getXpGainFactor()));
    }

    public static int getLevel(ItemStack itemStack) {
        return LevelableToolHelper.getLevel(LevelableToolHelper.readToolXP(itemStack));
    }

    public static boolean hasLevel(ItemStack itemStack, int level) {
        return LevelableToolHelper.getLevel(itemStack) >= level;
    }

    public static int getXPForLevel(int level) {
        return Properties.AdvTweaks.getXpGainFactor() * level * level;
    }

    public static double readToolXP(ItemStack itemStack) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData((ItemStack)itemStack);
        return nbttagcompound.func_74769_h("toolXP");
    }

    public static void saveToolXP(ItemStack itemStack, double toolXP) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData((ItemStack)itemStack);
        nbttagcompound.func_74780_a("toolXP", toolXP);
    }
}

