/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gravisuiteneo.mixins;

import com.gtnewhorizons.gravisuiteneo.common.Properties;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.ItemAdvChainsaw;
import gravisuite.ServerProxy;
import gravisuite.keyboard.Keyboard;
import ic2.api.item.ElectricItem;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemAdvChainsaw.class})
public abstract class MixinItemAdvChainsaw
extends ItemTool {
    @Shadow(remap=false)
    private int energyPerOperation;
    @Shadow(remap=false)
    public Set<Block> mineableBlocks;

    @Shadow(remap=false)
    public abstract void saveToolMode(ItemStack var1, Integer var2);

    @Overwrite(remap=false)
    public void init() {
        for (String blockName : Properties.AdvTweaks.getAdvChainsawAdditionalMineableBlocks()) {
            Block block;
            String[] blockNameParts = blockName.split(":", 1);
            if (blockNameParts.length != 2 || (block = GameRegistry.findBlock((String)blockNameParts[0], (String)blockNameParts[1])) == null) continue;
            this.mineableBlocks.add(block);
        }
    }

    @Overwrite(remap=false)
    public int getHarvestLevel(ItemStack stack, String toolClass) {
        return super.getHarvestLevel(stack, toolClass);
    }

    @ModifyConstant(constant={@Constant(floatValue=1.0f, ordinal=0)}, method={"getDigSpeed"}, remap=false)
    private float gravisuiteneo$getDigSpeedUncharged(float original) {
        return 0.0f;
    }

    @ModifyExpressionValue(at={@At(remap=false, target="Ljava/lang/Integer;intValue()I", value="INVOKE")}, method={"onEntityInteract"}, remap=false)
    private int gravisuiteneo$getShearMode(int original) {
        return original - 1;
    }

    @Inject(at={@At(ordinal=2, opcode=180, remap=true, target="Lnet/minecraft/entity/player/EntityPlayer;worldObj:Lnet/minecraft/world/World;", value="FIELD")}, method={"onBlockStartBreak"}, remap=false)
    private void gravisuiteneo$playChainsawSound(ItemStack itemstack, int x, int y, int z, EntityPlayer player, CallbackInfoReturnable<Boolean> cir) {
        player.field_70170_p.func_72956_a((Entity)player, "gravisuiteneo:chainsaw", 1.25f, 1.0f);
    }

    @Inject(at={@At(ordinal=1, value="RETURN")}, cancellable=true, method={"onBlockStartBreak"}, remap=false)
    private void gravisuiteneo$handleTreeToolMode(ItemStack itemstack, int x, int y, int z, EntityPlayer player, CallbackInfoReturnable<Boolean> cir) {
        if (ItemAdvChainsaw.readToolMode((ItemStack)itemstack) != 2) {
            return;
        }
        World world = player.field_70170_p;
        Block block = world.func_147439_a(x, y, z);
        if (block == null || !ElectricItem.manager.canUse(itemstack, (double)(this.energyPerOperation * 10))) {
            cir.setReturnValue((Object)true);
            return;
        }
        if ((block.isWood((IBlockAccess)world, x, y, z) || block.func_149688_o() == Material.field_151583_m) && this.detectTree(world, x, y, z, block)) {
            this.breakTree(world, x, y, z, x, y, z, itemstack, block, world.func_72805_g(x, y, z), player);
            cir.setReturnValue((Object)true);
        }
    }

    @ModifyConstant(constant={@Constant(intValue=1)}, method={"readToolMode"}, remap=false)
    private static int gravisuiteneo$getMaxToolMode1(int original) {
        return 2;
    }

    @Overwrite
    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (Keyboard.isModeKeyDown((EntityPlayer)player)) {
            Integer toolMode;
            Integer n = toolMode = ItemAdvChainsaw.readToolMode((ItemStack)itemStack);
            toolMode = toolMode + 1;
            if (toolMode > 2) {
                toolMode = 0;
            }
            this.saveToolMode(itemStack, toolMode);
            StringBuilder message = new StringBuilder();
            message.append(EnumChatFormatting.GREEN);
            message.append(StatCollector.func_74838_a((String)"message.text.mode"));
            message.append(": ");
            if (toolMode == 0) {
                message.append(EnumChatFormatting.GREEN);
                message.append(StatCollector.func_74838_a((String)"message.advChainsaw.mode.axe"));
            } else if (toolMode == 1) {
                message.append(EnumChatFormatting.GOLD);
                message.append(StatCollector.func_74838_a((String)"message.advChainsaw.mode.shear"));
            } else if (toolMode == 2) {
                message.append(EnumChatFormatting.AQUA);
                message.append(StatCollector.func_74838_a((String)"message.advChainsaw.mode.treecapitator"));
            }
            ServerProxy.sendPlayerMessage((EntityPlayer)player, (String)message.toString());
        }
        return itemStack;
    }

    @Overwrite
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack item, EntityPlayer player, List<String> tooltip, boolean advancedTooltips) {
        int toolMode = ItemAdvChainsaw.readToolMode((ItemStack)item);
        StringBuilder line = new StringBuilder();
        line.append(EnumChatFormatting.GOLD);
        line.append(StatCollector.func_74838_a((String)"message.text.mode"));
        line.append(": ");
        line.append(EnumChatFormatting.WHITE);
        if (toolMode == 0) {
            line.append(StatCollector.func_74838_a((String)"message.advChainsaw.mode.axe"));
        } else if (toolMode == 1) {
            line.append(StatCollector.func_74838_a((String)"message.advChainsaw.mode.shear"));
        } else if (toolMode == 2) {
            line.append(StatCollector.func_74838_a((String)"message.advChainsaw.mode.treecapitator"));
        }
        tooltip.add(line.toString());
    }

    @Unique
    private void breakTree(World world, int x, int y, int z, int xStart, int yStart, int zStart, ItemStack stack, Block block, int meta, EntityPlayer player) {
        for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
            for (int yPos = y; yPos <= y + 1; ++yPos) {
                for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                    Block localBlock;
                    if (!ElectricItem.manager.use(stack, (double)this.energyPerOperation, (EntityLivingBase)player) || block != (localBlock = world.func_147439_a(xPos, yPos, zPos))) continue;
                    int localMeta = world.func_72805_g(xPos, yPos, zPos);
                    boolean cancelHarvest = false;
                    BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(x, y, z, world, localBlock, localMeta, player);
                    event.setCanceled(cancelHarvest);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    cancelHarvest = event.isCanceled();
                    int xDist = xPos - xStart;
                    int yDist = yPos - yStart;
                    int zDist = zPos - zStart;
                    if (9 * xDist * xDist + yDist * yDist + 9 * zDist * zDist >= 2500) continue;
                    if (cancelHarvest) {
                        this.breakTree(world, xPos, yPos, zPos, xStart, yStart, zStart, stack, block, meta, player);
                        continue;
                    }
                    if (localMeta % 4 != meta % 4) continue;
                    if (!player.field_71075_bZ.field_75098_d) {
                        localBlock.func_149636_a(world, player, x, y, z, localMeta);
                        this.func_150894_a(stack, world, localBlock, xPos, yPos, zPos, (EntityLivingBase)player);
                    }
                    world.func_147468_f(xPos, yPos, zPos);
                    if (world.field_72995_K) continue;
                    this.breakTree(world, xPos, yPos, zPos, xStart, yStart, zStart, stack, block, meta, player);
                }
            }
        }
    }

    @Unique
    private boolean detectTree(World world, int x, int y, int z, Block wood) {
        int height = y;
        boolean foundTop = false;
        do {
            Block block;
            if ((block = world.func_147439_a(x, ++height, z)) == wood) continue;
            --height;
            foundTop = true;
        } while (!foundTop);
        int numLeaves = 0;
        if (height - y < 50) {
            for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
                for (int yPos = height - 1; yPos <= height + 1; ++yPos) {
                    for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                        Block leaves = world.func_147439_a(xPos, yPos, zPos);
                        if (leaves == null || !leaves.isLeaves((IBlockAccess)world, xPos, yPos, zPos)) continue;
                        ++numLeaves;
                    }
                }
            }
        }
        return numLeaves > 3;
    }

    private MixinItemAdvChainsaw(float p_i45333_1_, Item.ToolMaterial p_i45333_2_, Set<Block> p_i45333_3_) {
        super(p_i45333_1_, p_i45333_2_, p_i45333_3_);
    }
}

