/*
 * Decompiled with CFR 0.152.
 */
package com.gtnh.findit.util;

import net.minecraft.entity.Entity;
import net.minecraft.util.Vec3;

public class Rotation {
    private final float yaw;
    private final float pitch;

    public Rotation(float yaw, float pitch) {
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public float yaw() {
        return this.yaw;
    }

    public float pitch() {
        return this.pitch;
    }

    public void apply(Entity entity) {
        entity.field_70177_z = this.yaw;
        entity.field_70125_A = this.pitch;
    }

    public static Rotation lookAt(Vec3 source, Vec3 target) {
        double deltaX = target.field_72450_a - source.field_72450_a;
        double deltaY = target.field_72448_b - source.field_72448_b;
        double deltaZ = target.field_72449_c - source.field_72449_c;
        double distanceXZ = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
        float yaw = (float)Math.toDegrees(Math.atan2(-deltaX, deltaZ));
        float pitch = (float)Math.toDegrees(Math.atan2(-deltaY, distanceXZ));
        return new Rotation(yaw, pitch);
    }
}

