/*
 * Decompiled with CFR 0.152.
 */
package com.gtnh.findit.util;

import com.gtnh.findit.service.blockfinder.BlockFoundResponse;
import com.gtnh.findit.util.Rotation;
import java.util.List;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;

public class ClientFinderHelperUtils {
    public static void lookAtTarget(EntityClientPlayerMP player, BlockFoundResponse response) {
        ClientFinderHelperUtils.rotateViewHelper(player, response.getPositions());
    }

    public static void rotateViewHelper(EntityClientPlayerMP player, List<ChunkPosition> targets) {
        if (targets.isEmpty()) {
            return;
        }
        Vec3 eyesPos = player.func_70666_h(1.0f);
        Vec3 nearestPos = ClientFinderHelperUtils.center(ClientFinderHelperUtils.getNearBlock(eyesPos, targets));
        Rotation targetRotation = Rotation.lookAt(eyesPos, nearestPos);
        targetRotation.apply((Entity)player);
    }

    public static Vec3 center(ChunkPosition p) {
        return Vec3.func_72443_a((double)((double)p.field_151329_a + 0.5), (double)((double)p.field_151327_b + 0.5), (double)((double)p.field_151328_c + 0.5));
    }

    private static ChunkPosition getNearBlock(Vec3 player, List<ChunkPosition> targets) {
        ChunkPosition result = null;
        double minDistance = Double.MAX_VALUE;
        for (ChunkPosition target : targets) {
            double distance = ClientFinderHelperUtils.getDistanceToCenter(player, target);
            if (!(distance < minDistance)) continue;
            result = target;
            minDistance = distance;
        }
        return result;
    }

    private static double getDistanceToCenter(Vec3 player, ChunkPosition target) {
        double deltaX = (double)target.field_151329_a + 0.5 - player.field_72450_a;
        double deltaY = (double)target.field_151327_b + 0.5 - player.field_72448_b;
        double deltaZ = (double)target.field_151328_c + 0.5 - player.field_72449_c;
        return Math.sqrt(deltaX * deltaX + deltaZ * deltaZ + deltaY * deltaY);
    }

    public static AxisAlignedBB mergeAABB(AxisAlignedBB box1, AxisAlignedBB box2) {
        return AxisAlignedBB.func_72330_a((double)Math.min(box1.field_72340_a, box2.field_72340_a), (double)Math.min(box1.field_72338_b, box2.field_72338_b), (double)Math.min(box1.field_72339_c, box2.field_72339_c), (double)Math.max(box1.field_72336_d, box2.field_72336_d), (double)Math.max(box1.field_72337_e, box2.field_72337_e), (double)Math.max(box1.field_72334_f, box2.field_72334_f));
    }
}

