/*
 * Decompiled with CFR 0.152.
 */
package com.gtnh.findit;

import com.gtnh.findit.FindItConfig;
import com.gtnh.findit.IStackFilter;
import com.gtnh.findit.handler.AdventureBackpackProvider;
import com.gtnh.findit.handler.BackpackProvider;
import com.gtnh.findit.handler.DraconicEvolutionProvider;
import com.gtnh.findit.handler.ForestryStackFilterProvider;
import com.gtnh.findit.handler.MinecraftProvider;
import com.gtnh.findit.handler.ProjectRedExplorationProvider;
import com.gtnh.findit.handler.ThaumcraftProvider;
import com.gtnh.findit.service.blockfinder.BlockFindService;
import com.gtnh.findit.service.blockfinder.ClientBlockFindService;
import com.gtnh.findit.service.cooldown.SearchCooldownService;
import com.gtnh.findit.service.itemfinder.ClientItemFindService;
import com.gtnh.findit.service.itemfinder.ItemFindService;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;

@Mod(modid="findit", name="FindIt", version="1.3.10", dependencies="required-after:NotEnoughItems;after:gregtech", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.7.10]")
public class FindIt {
    public static final String MOD_ID = "findit";
    public static final String MOD_NAME = "FindIt";
    public static final String VERSION = "1.3.10";
    @Mod.Instance(value="findit")
    public static FindIt INSTANCE;
    private boolean isEnderIOLoaded;
    private boolean isExtraUtilitiesLoaded;
    private boolean isGregTechLoaded;
    private SearchCooldownService cooldownService;
    private BlockFindService blockFindService;
    private ItemFindService itemFindService;
    public final List<IStackFilter.IStackFilterProvider> pluginsList = new ArrayList<IStackFilter.IStackFilterProvider>();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.isExtraUtilitiesLoaded = Loader.isModLoaded((String)"ExtraUtilities");
        this.isGregTechLoaded = Loader.isModLoaded((String)"gregtech");
        this.isEnderIOLoaded = Loader.isModLoaded((String)"EnderIO");
        this.cooldownService = new SearchCooldownService();
        FindItConfig.setup(event.getSuggestedConfigurationFile());
        if (event.getSide() == Side.CLIENT) {
            this.blockFindService = new ClientBlockFindService();
            this.itemFindService = new ClientItemFindService();
        } else {
            this.blockFindService = new BlockFindService();
            this.itemFindService = new ItemFindService();
        }
        if (Loader.isModLoaded((String)"Forestry")) {
            this.pluginsList.add(new ForestryStackFilterProvider());
        }
        if (Loader.isModLoaded((String)"adventurebackpack")) {
            this.pluginsList.add(new AdventureBackpackProvider());
        }
        if (Loader.isModLoaded((String)"ProjRed|Exploration")) {
            this.pluginsList.add(new ProjectRedExplorationProvider());
        }
        if (Loader.isModLoaded((String)"DraconicEvolution")) {
            this.pluginsList.add(new DraconicEvolutionProvider());
        }
        if (Loader.isModLoaded((String)"Backpack")) {
            this.pluginsList.add(new BackpackProvider());
        }
        if (Loader.isModLoaded((String)"thaumcraftneiplugin") && Loader.isModLoaded((String)"Thaumcraft")) {
            this.pluginsList.add(new ThaumcraftProvider());
        }
        this.pluginsList.add(new MinecraftProvider());
    }

    public static SearchCooldownService getCooldownService() {
        return FindIt.INSTANCE.cooldownService;
    }

    public static BlockFindService getBlockFindService() {
        return FindIt.INSTANCE.blockFindService;
    }

    public static ItemFindService getItemFindService() {
        return FindIt.INSTANCE.itemFindService;
    }

    public static boolean isExtraUtilitiesLoaded() {
        return FindIt.INSTANCE.isExtraUtilitiesLoaded;
    }

    public static boolean isGregTechLoaded() {
        return FindIt.INSTANCE.isGregTechLoaded;
    }

    public static boolean isEnderIOLoaded() {
        return FindIt.INSTANCE.isEnderIOLoaded;
    }
}

