/*
 * Decompiled with CFR 0.152.
 */
package com.n247s.N2ConfigApi.api.core;

import com.n247s.N2ConfigApi.api.N2ConfigApi;
import com.n247s.N2ConfigApi.api.core.ConfigFile;
import com.n247s.N2ConfigApi.api.core.ConfigHandler;
import com.n247s.N2ConfigApi.api.core.ConfigSection;
import com.n247s.N2ConfigApi.api.core.InitConfigObjectManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;

public class ConfigSectionCollection
extends ConfigSection
implements Serializable {
    private static final long serialVersionUID = -864529735488611577L;
    private static final Logger log = N2ConfigApi.log;
    protected HashMap<String, ConfigSection> AbsoluteSubSectionMap = new HashMap();
    private HashMap<String, ConfigSection> subSectionMap = new HashMap();
    private List<ConfigSection> subSectionOrderList = new ArrayList<ConfigSection>();
    private ConfigSectionCollection superConfigSectionCollection;
    private boolean ExtraSpaces;
    private boolean changedSections;
    private int level;

    private ConfigSectionCollection(String sectionName, String[] description, boolean setExtraSpaces, int level) {
        super(sectionName, description, null, ConfigSection.SectionType.SectionHead, true, false);
        this.ExtraSpaces = setExtraSpaces;
        this.level = level;
    }

    public ConfigSectionCollection(String sectionName, String[] description, boolean setExtraSpaces) {
        this(sectionName, description, setExtraSpaces, 0);
    }

    public final ConfigSection addNewConfigSectionCollection(String sectionName, String[] description, boolean setExtraSpaces) {
        ConfigSectionCollection configSection = new ConfigSectionCollection(sectionName, description, setExtraSpaces, this.level + 1);
        configSection.setSuperConfigSectionCollection(this);
        this.addNewSection(configSection);
        return configSection;
    }

    public final ConfigSection addNewShortSection(String sectionName, String[] description, short defaultValue, boolean hideOutLines) {
        ConfigSection configSection = new ConfigSection(sectionName, description, defaultValue, ConfigSection.SectionType.Short, hideOutLines);
        this.addNewSection(configSection);
        return configSection;
    }

    public final ConfigSection addNewShortArraySection(String sectionName, String[] description, short[] defaultValue, boolean separateLines, boolean hideOutLines) {
        ConfigSection configSection = new ConfigSection(sectionName, description, defaultValue, ConfigSection.SectionType.ShortArray, separateLines, hideOutLines);
        this.addNewSection(configSection);
        return configSection;
    }

    public final ConfigSection addNewIntegerSection(String sectionName, String[] description, int defaultValue, boolean hideOutLines) {
        ConfigSection configSection = new ConfigSection(sectionName, description, defaultValue, ConfigSection.SectionType.Integer, hideOutLines);
        this.addNewSection(configSection);
        return configSection;
    }

    public final ConfigSection addNewIntegerArraySection(String sectionName, String[] description, int[] defaultValue, boolean separateLines, boolean hideOutLines) {
        ConfigSection configSection = new ConfigSection(sectionName, description, defaultValue, ConfigSection.SectionType.IntegerArray, hideOutLines);
        this.addNewSection(configSection);
        return configSection;
    }

    public final ConfigSection addNewLongSection(String sectionName, String[] description, long defaultValue, boolean hideOutLines) {
        ConfigSection configSection = new ConfigSection(sectionName, description, defaultValue, ConfigSection.SectionType.Long, hideOutLines);
        this.addNewSection(configSection);
        return configSection;
    }

    public final ConfigSection addNewLongArraySection(String sectionName, String[] description, long[] defaultValue, boolean separateLines, boolean hideOutLines) {
        ConfigSection configSection = new ConfigSection(sectionName, description, defaultValue, ConfigSection.SectionType.LongArray, hideOutLines);
        this.addNewSection(configSection);
        return configSection;
    }

    public final ConfigSection addNewFloatSection(String sectionName, String[] description, float defaultValue, boolean hideOutLines) {
        ConfigSection configSection = new ConfigSection(sectionName, description, Float.valueOf(defaultValue), ConfigSection.SectionType.Float, hideOutLines);
        this.addNewSection(configSection);
        return configSection;
    }

    public final ConfigSection addNewFloatArraySection(String sectionName, String[] description, float[] defaultValue, boolean separateLines, boolean hideOutLines) {
        ConfigSection configSection = new ConfigSection(sectionName, description, defaultValue, ConfigSection.SectionType.FloatArray, hideOutLines);
        this.addNewSection(configSection);
        return configSection;
    }

    public final ConfigSection addNewDoubleSection(String sectionName, String[] description, double defaultValue, boolean hideOutLines) {
        ConfigSection configSection = new ConfigSection(sectionName, description, defaultValue, ConfigSection.SectionType.Double, hideOutLines);
        this.addNewSection(configSection);
        return configSection;
    }

    public final ConfigSection addNewDoubleArraySection(String sectionName, String[] description, double[] defaultValue, boolean separateLines, boolean hideOutLines) {
        ConfigSection configSection = new ConfigSection(sectionName, description, defaultValue, ConfigSection.SectionType.DoubleArray, hideOutLines);
        this.addNewSection(configSection);
        return configSection;
    }

    public final ConfigSection addNewBooleanSection(String sectionName, String[] description, boolean defaultValue, boolean hideOutLines) {
        ConfigSection configSection = new ConfigSection(sectionName, description, defaultValue, ConfigSection.SectionType.Boolean, hideOutLines);
        this.addNewSection(configSection);
        return configSection;
    }

    public final ConfigSection addNewBooleanArraySection(String sectionName, String[] description, boolean[] defaultValue, boolean separateLines, boolean hideOutLines) {
        ConfigSection configSection = new ConfigSection(sectionName, description, defaultValue, ConfigSection.SectionType.BooleanArray, hideOutLines);
        this.addNewSection(configSection);
        return configSection;
    }

    public final ConfigSection addNewStringSection(String sectionName, String[] description, String defaultValue, boolean hideOutLines) {
        ConfigSection configSection = new ConfigSection(sectionName, description, defaultValue, ConfigSection.SectionType.String, hideOutLines);
        this.addNewSection(configSection);
        return configSection;
    }

    public final ConfigSection addNewStringArraySection(String sectionName, String[] description, String[] defaultValue, boolean separateLines, boolean hideOutLines) {
        ConfigSection configSection = new ConfigSection(sectionName, description, defaultValue, ConfigSection.SectionType.StringArray, hideOutLines);
        this.addNewSection(configSection);
        return configSection;
    }

    public final ConfigSection addNewTextSection(String sectionName, String[] description) {
        ConfigSection configSection = new ConfigSection(sectionName, description, ConfigSection.SectionType.Text);
        this.addNewSection(configSection);
        return configSection;
    }

    public final void addNewSection(ConfigSection configSection) {
        String sectionName = configSection.getSectionName();
        if (!this.subSectionMap.containsKey(sectionName)) {
            if (this.superConfigSectionCollection != null && !this.superConfigSectionCollection.insertConfigSection(configSection, this.superConfigSectionCollection.getConfigSectionAtIndex(this.superConfigSectionCollection.getConfigSectionIndex(this.getSectionName()) + 1))) {
                return;
            }
            this.subSectionOrderList.add(this.subSectionOrderList.size(), configSection);
            this.subSectionMap.put(sectionName, configSection);
            this.AbsoluteSubSectionMap.put(sectionName, configSection);
            this.setChangedSections(true);
        } else {
            log.error("Section: " + sectionName + " is already registered!");
        }
    }

    public final boolean insertConfigSection(ConfigSection insertConfigSection, ConfigSection configSectionTarget) {
        if (this.AbsoluteSubSectionMap.containsValue(insertConfigSection) || this.AbsoluteSubSectionMap.containsKey(insertConfigSection.getSectionName())) {
            return false;
        }
        if (this.superConfigSectionCollection != null) {
            return this.superConfigSectionCollection.insertConfigSection(insertConfigSection, configSectionTarget);
        }
        return this.superInsertConfigSection(insertConfigSection, configSectionTarget);
    }

    private boolean superInsertConfigSection(ConfigSection insertConfigSection, ConfigSection configSectionTarget) {
        if (!this.AbsoluteSubSectionMap.containsValue(insertConfigSection) || this.AbsoluteSubSectionMap.containsKey(insertConfigSection.getSectionName())) {
            return false;
        }
        int index = 0;
        if (this.subSectionMap.containsValue(configSectionTarget)) {
            for (int i = 0; i < this.subSectionOrderList.size(); ++i) {
                ConfigSection configSection = this.subSectionOrderList.get(i);
                if (!configSection.equals(configSectionTarget)) continue;
                index = i;
                break;
            }
            this.subSectionOrderList.add(index, insertConfigSection);
            this.subSectionMap.put(insertConfigSection.getSectionName(), insertConfigSection);
            this.AbsoluteSubSectionMap.put(insertConfigSection.getSectionName(), insertConfigSection);
            if (insertConfigSection instanceof ConfigSectionCollection) {
                ArrayList<String> configSectionNames = new ArrayList<String>();
                int subSectionCount = ((ConfigSectionCollection)insertConfigSection).getAbsoluteSubSectionCount();
                for (int ii = 0; ii < subSectionCount; ++ii) {
                    if (!this.superInsertConfigSection(((ConfigSectionCollection)insertConfigSection).getConfigSectionAtIndex(ii), configSectionTarget)) {
                        for (int ij = 0; ij < configSectionNames.size(); ++ij) {
                            this.removeSubConfigSection((String)configSectionNames.get(ij));
                        }
                        return false;
                    }
                    configSectionNames.add(((ConfigSectionCollection)insertConfigSection).getConfigSectionAtIndex(ii).getSectionName());
                }
            }
            this.setChangedSections(true);
            return true;
        }
        for (int ip = 0; ip < this.subSectionOrderList.size(); ++ip) {
            ConfigSection configSection = this.subSectionOrderList.get(ip);
            if (!(configSection instanceof ConfigSectionCollection) || !((ConfigSectionCollection)configSection).superInsertConfigSection(insertConfigSection, configSectionTarget)) continue;
            this.AbsoluteSubSectionMap.put(insertConfigSection.getSectionName(), insertConfigSection);
            this.setChangedDefaultValue(true);
            return true;
        }
        log.error("Something Strange happens during adding ConfigSection: " + insertConfigSection.getSectionName());
        log.info("Its recommended to regenerate this ConfigFile");
        return false;
    }

    public final boolean removeSubConfigSection(String configSectionName) {
        if (!this.AbsoluteSubSectionMap.containsKey(configSectionName)) {
            return false;
        }
        if (this.superConfigSectionCollection != null) {
            return this.superConfigSectionCollection.superRemoveSubConfigSection(configSectionName);
        }
        return this.superRemoveSubConfigSection(configSectionName);
    }

    private boolean superRemoveSubConfigSection(String configSectionName) {
        if (this.AbsoluteSubSectionMap.containsKey(configSectionName)) {
            if (this.subSectionOrderList.contains(this.getConfigSectionAtIndex(this.getConfigSectionIndex(configSectionName)))) {
                this.subSectionOrderList.remove(this.getConfigSectionAtIndex(this.getConfigSectionIndex(configSectionName)));
                this.subSectionMap.remove(configSectionName);
                this.AbsoluteSubSectionMap.remove(configSectionName);
                this.setChangedSections(true);
                return true;
            }
            for (int i = 0; i < this.subSectionMap.size(); ++i) {
                if (!(this.subSectionOrderList.get(i) instanceof ConfigSectionCollection) || !((ConfigSectionCollection)this.subSectionOrderList.get(i)).superRemoveSubConfigSection(configSectionName)) continue;
                this.AbsoluteSubSectionMap.remove(configSectionName);
                this.setChangedDefaultValue(true);
                return true;
            }
            log.error("Something went horibly wrong, Did you touch the 'AbsoluteSubSectionMap'?");
            return false;
        }
        return false;
    }

    public final void clearAllConfigSections() {
        this.AbsoluteSubSectionMap = new HashMap();
        this.subSectionMap = new HashMap();
        this.subSectionOrderList = new ArrayList<ConfigSection>();
        this.setChangedSections(true);
    }

    public void setExtraSpaces(boolean extraSpaces) {
        this.ExtraSpaces = extraSpaces;
    }

    public final ConfigSection getSubSection(String sectionName) {
        if (this.subSectionMap.containsKey(sectionName)) {
            return this.subSectionMap.get(sectionName);
        }
        Iterator<String> CurrentSectionName = this.subSectionMap.keySet().iterator();
        while (CurrentSectionName.hasNext()) {
            ConfigSection subSection = null;
            ConfigSection section = this.subSectionMap.get(CurrentSectionName.next());
            if (!(section instanceof ConfigSectionCollection) || (subSection = ((ConfigSectionCollection)section).getSubSection(sectionName)) == null) continue;
            return subSection;
        }
        return null;
    }

    public final int getSubSectionCount() {
        return this.subSectionMap.size();
    }

    public final int getAbsoluteSubSectionCount() {
        int finalAmount = 0;
        finalAmount += this.getSubSectionCount();
        Iterator<String> currentSectionName = this.subSectionMap.keySet().iterator();
        while (currentSectionName.hasNext()) {
            if (!(this.subSectionMap.get(currentSectionName.next()) instanceof ConfigSectionCollection)) continue;
            finalAmount += ((ConfigSectionCollection)this.subSectionMap.get(currentSectionName.next())).getAbsoluteSubSectionCount();
        }
        return finalAmount + 1;
    }

    public final ConfigSection getConfigSectionAtAbsoluteIndex(int index) {
        int corrector = 0;
        ConfigSection finalsection = null;
        if (index > this.subSectionOrderList.size()) {
            return null;
        }
        if (index <= 0) {
            return this;
        }
        for (int i = 0; i <= index - 1 - corrector; ++i) {
            ConfigSection section = this.subSectionOrderList.get(i + corrector);
            if (section instanceof ConfigSectionCollection) {
                for (int il = 0; il <= index - i; ++il) {
                    finalsection = ((ConfigSectionCollection)section).getConfigSectionAtIndex(il - 1);
                    if (finalsection != null) continue;
                    corrector += ((ConfigSectionCollection)section).getSubSectionCount();
                }
                continue;
            }
            finalsection = this.subSectionOrderList.get(i + corrector);
        }
        return finalsection;
    }

    public final ConfigSection getConfigSectionAtIndex(int index) {
        ConfigSection configSection = this.subSectionOrderList.get(index - 1);
        if (index > 0) {
            return configSection;
        }
        return this;
    }

    public final int getAbsoluteConfigSectionIndex(String ConfigSectionName) {
        ConfigSection target = this.AbsoluteSubSectionMap.get(ConfigSectionName);
        int corrector = 0;
        Object finalsection = null;
        if (target != null) {
            for (int i = 0; i < this.subSectionOrderList.size(); ++i) {
                ConfigSection section = this.subSectionOrderList.get(i);
                if (section.equals(target)) {
                    return i + 1;
                }
                if (!(section instanceof ConfigSectionCollection)) continue;
                corrector += ((ConfigSectionCollection)section).getAbsoluteConfigSectionIndex(ConfigSectionName);
            }
            return corrector;
        }
        return -1;
    }

    public final int getConfigSectionIndex(String ConfigSectionName) {
        ConfigSection target = this.AbsoluteSubSectionMap.get(ConfigSectionName);
        if (target != null) {
            for (int i = 0; i < this.subSectionOrderList.size(); ++i) {
                if (!this.subSectionOrderList.get(i).equals(target)) continue;
                return i + 1;
            }
        }
        return -1;
    }

    protected final void setChangedSections(boolean changedSections) {
        this.changedSections = changedSections;
        if (this.superConfigSectionCollection != null) {
            this.superConfigSectionCollection.setChangedSections(changedSections);
        }
    }

    private void setSuperConfigSectionCollection(ConfigSectionCollection configSectionCollection) {
        this.superConfigSectionCollection = configSectionCollection;
        this.level = this.superConfigSectionCollection.getLevel();
    }

    private int getLevel() {
        return this.level;
    }

    public final boolean haveSectionChanged() {
        return this.changedSections;
    }

    public final ConfigSectionCollection getSuperConfigSectionChapter() {
        return this.superConfigSectionCollection;
    }

    public final int regenConfigChapter(BufferedWriter writer, BufferedReader reader, List invalidSections) throws IOException {
        ConfigSectionCollection superSectionCollection = this.superConfigSectionCollection;
        while (superSectionCollection.superConfigSectionCollection != null) {
            superSectionCollection = superSectionCollection.superConfigSectionCollection;
        }
        if (superSectionCollection instanceof ConfigFile && ((ConfigFile)superSectionCollection).isConnected()) {
            return -1;
        }
        String readedLine = reader.readLine();
        int sectionCount = 0;
        int totalSectionsChecked = 0;
        HashMap<String, String[]> sectionValues = new HashMap<String, String[]>();
        while (readedLine != null) {
            if (readedLine.isEmpty() || readedLine.trim().startsWith("#")) {
                readedLine = reader.readLine();
                continue;
            }
            if (readedLine.contains(";")) {
                for (int i = 0; i < this.subSectionOrderList.size(); ++i) {
                    ConfigSection section = this.subSectionOrderList.get(i);
                    try {
                        if (!section.getSectionName().equals(readedLine.trim().substring(0, readedLine.trim().indexOf(";"))) || section.getSectionType() == ConfigSection.SectionType.Text || section.getSectionType() == ConfigSection.SectionType.SectionHead || invalidSections.contains(section.getSectionName())) continue;
                        ArrayList<String> value = new ArrayList<String>();
                        if (section.getSectionType().isArray()) {
                            String[] s4;
                            String[] s1;
                            StringBuilder SB1 = new StringBuilder();
                            Pattern p1 = Pattern.compile(";\\{");
                            block5: for (String s2 : s1 = p1.split(readedLine)) {
                                if (s2.length() <= 0 || s2.contains(section.getSectionName())) continue;
                                while (readedLine != null) {
                                    String s3;
                                    if (readedLine.contains(";{") && readedLine.contains("};")) {
                                        s3 = readedLine.substring(readedLine.indexOf("{") + 1, readedLine.indexOf("}"));
                                        SB1.append(s3);
                                        continue block5;
                                    }
                                    if (readedLine.contains("};")) {
                                        s3 = readedLine.substring(0, readedLine.indexOf("}"));
                                        SB1.append(s3);
                                        continue block5;
                                    }
                                    SB1.append(readedLine);
                                    readedLine = reader.readLine();
                                }
                            }
                            Pattern p2 = Pattern.compile(",");
                            for (String s5 : s4 = p2.split(SB1.toString())) {
                                if (s5.length() <= 0) continue;
                                value.add(value.size(), s5);
                            }
                        } else {
                            String[] s1;
                            Pattern p1 = Pattern.compile(";");
                            for (String s2 : s1 = p1.split(readedLine)) {
                                if (s2.length() <= 0 || s2.contains(section.getSectionName())) continue;
                                value.add(value.size(), s2);
                            }
                        }
                        sectionValues.put(section.getSectionName(), (String[])value.toArray());
                        continue;
                    }
                    catch (Exception value) {
                        // empty catch block
                    }
                }
            }
            readedLine = reader.readLine();
        }
        if (this.getStarter() != null && !this.getHideOutLines()) {
            this.appendLineWithOffset(writer, this.getStarter(), this.level);
            writer.newLine();
        }
        if (this.getDescription() != null) {
            for (int ik = 0; ik < this.getDescription().length; ++ik) {
                this.appendLineWithOffset(writer, " # " + this.getDescription()[ik], this.level);
                writer.newLine();
            }
            if (this.getHeadEnder() != null && !this.getHideOutLines()) {
                this.appendLineWithOffset(writer, this.getHeadEnder(), this.level);
                writer.newLine();
            }
        }
        writer.newLine();
        writer.flush();
        for (int il = 0; il < this.subSectionOrderList.size(); ++il) {
            ConfigSection currentSection = this.subSectionOrderList.get(il);
            if (currentSection instanceof ConfigSectionCollection) {
                totalSectionsChecked += ((ConfigSectionCollection)currentSection).regenConfigChapter(writer, reader, invalidSections) + 1;
            } else if (sectionValues.containsKey(currentSection.getSectionName())) {
                if (currentSection.getStarter() != null && !currentSection.getHideOutLines()) {
                    this.appendLineWithOffset(writer, currentSection.getStarter(), this.level + 1);
                    writer.newLine();
                }
                if (currentSection.getDescription() != null) {
                    for (int ip = 0; ip < currentSection.getDescription().length; ++ip) {
                        this.appendLineWithOffset(writer, " # " + currentSection.getDescription()[ip], this.level + 1);
                        writer.newLine();
                    }
                    if (currentSection.getHeadEnder() != null && !currentSection.getHideOutLines()) {
                        this.appendLineWithOffset(writer, currentSection.getHeadEnder(), this.level + 1);
                        writer.newLine();
                    }
                }
                writer.flush();
                String[] values = (String[])sectionValues.get(currentSection.getSectionName());
                if (currentSection.getSectionType().isArray()) {
                    this.appendLineWithOffset(writer, currentSection.getSectionName() + ";{ ", this.level + 1);
                    for (int iu = 0; iu < values.length; ++iu) {
                        if (currentSection.getSeparteLines()) {
                            writer.newLine();
                        }
                        this.appendLineWithOffset(writer, values[iu] + ", ", this.level + 1);
                    }
                    if (currentSection.getSeparteLines()) {
                        writer.newLine();
                    }
                    this.appendLineWithOffset(writer, "};", this.level + 1);
                } else {
                    this.appendLineWithOffset(writer, currentSection.getSectionName() + "; " + values[0], this.level + 1);
                }
                writer.newLine();
                if (currentSection.getEnder() != null && !currentSection.getHideOutLines()) {
                    this.appendLineWithOffset(writer, currentSection.getEnder(), this.level + 1);
                    writer.newLine();
                }
                ++sectionCount;
            } else {
                this.writeSubSection(writer, currentSection);
                ++sectionCount;
            }
            if (!this.ExtraSpaces) continue;
            writer.newLine();
        }
        if (!this.ExtraSpaces) {
            writer.newLine();
        }
        if (this.getEnder() != null && !this.getHideOutLines()) {
            this.appendLineWithOffset(writer, this.getEnder(), this.level);
            writer.newLine();
        }
        return totalSectionsChecked + sectionCount;
    }

    private void appendLineWithOffset(BufferedWriter writer, String line, int offset) throws IOException {
        for (int i = 0; i < offset; ++i) {
            writer.append("  ");
        }
        writer.append(line);
    }

    public final void writeAllSections(BufferedWriter writer) throws IOException {
        ConfigSectionCollection superSectionCollection = this;
        while (superSectionCollection.superConfigSectionCollection != null) {
            superSectionCollection = superSectionCollection.superConfigSectionCollection;
        }
        if (superSectionCollection instanceof ConfigFile && ((ConfigFile)superSectionCollection).isConnected()) {
            return;
        }
        this.writeSectionChapter(writer, this);
        writer.flush();
    }

    public final void writeSubSection(BufferedWriter writer, String sectionName) throws IOException {
        ConfigSectionCollection superSectionCollection = this;
        while (superSectionCollection.superConfigSectionCollection != null) {
            superSectionCollection = superSectionCollection.superConfigSectionCollection;
        }
        if (superSectionCollection instanceof ConfigFile && ((ConfigFile)superSectionCollection).isConnected()) {
            return;
        }
        ConfigSection section = this.subSectionMap.get(sectionName);
        if (section instanceof ConfigSectionCollection) {
            ((ConfigSectionCollection)section).writeSectionChapter(writer, (ConfigSectionCollection)section);
        } else {
            this.writeSubSection(writer, section);
        }
        writer.flush();
    }

    private void writeSectionChapter(BufferedWriter writer, ConfigSectionCollection section) throws IOException {
        int i;
        if (!section.getHideOutLines()) {
            if (this.getStarter() != null) {
                this.appendLineWithOffset(writer, section.getStarter(), this.level);
                writer.newLine();
            }
            if (section.getDescription() != null) {
                for (i = 0; i < section.getDescription().length; ++i) {
                    this.appendLineWithOffset(writer, " # " + section.getDescription()[i], this.level);
                    writer.newLine();
                }
                if (this.getHeadEnder() != null) {
                    this.appendLineWithOffset(writer, section.getHeadEnder(), this.level);
                    writer.newLine();
                }
            }
            writer.newLine();
        }
        for (i = 0; i < this.subSectionOrderList.size(); ++i) {
            ConfigSection subSection = this.subSectionOrderList.get(i);
            if (subSection != null) {
                if (subSection instanceof ConfigSectionCollection) {
                    ((ConfigSectionCollection)subSection).writeAllSections(writer);
                } else {
                    this.writeSubSection(writer, subSection);
                }
            }
            if (!section.ExtraSpaces) continue;
            writer.newLine();
        }
        writer.newLine();
        if (this.getEnder() != null && !section.getHideOutLines()) {
            this.appendLineWithOffset(writer, section.getEnder(), this.level);
        }
        writer.flush();
    }

    private void writeSubSection(BufferedWriter writer, ConfigSection section) throws IOException {
        ConfigSection.SectionType sectionType = section.getSectionType();
        if (sectionType == ConfigSection.SectionType.Text && section.getDescription() == null) {
            writer.newLine();
        } else if (!section.getHideOutLines()) {
            if (this.getStarter() != null) {
                this.appendLineWithOffset(writer, section.getStarter(), 1 + this.level);
                writer.newLine();
            }
            if (section.getDescription() != null) {
                for (int i = 0; i < section.getDescription().length; ++i) {
                    this.appendLineWithOffset(writer, " # " + section.getDescription()[i], 1 + this.level);
                    writer.newLine();
                }
                if (sectionType != ConfigSection.SectionType.Text && this.getHeadEnder() != null) {
                    this.appendLineWithOffset(writer, section.getHeadEnder(), 1 + this.level);
                    writer.newLine();
                } else if (this.getEnder() != null) {
                    this.appendLineWithOffset(writer, section.getEnder(), 1 + this.level);
                    writer.newLine();
                }
            }
            writer.newLine();
            writer.flush();
        }
        if (sectionType != ConfigSection.SectionType.Text) {
            if (sectionType.isArray()) {
                if (section.getDefaultValue() != null) {
                    this.appendLineWithOffset(writer, section.getSectionName() + ";{ ", 1 + this.level);
                    if (section.getSeparteLines()) {
                        writer.newLine();
                    }
                    switch (sectionType) {
                        case ShortArray: {
                            short[] shortValues = (short[])section.getDefaultValue();
                            for (int i = 0; i < shortValues.length; ++i) {
                                if (!section.getSeparteLines()) {
                                    writer.append(Short.toString(shortValues[i]) + ", ");
                                } else {
                                    this.appendLineWithOffset(writer, Short.toString(shortValues[i]), 1 + this.level);
                                    writer.newLine();
                                }
                                writer.flush();
                            }
                            break;
                        }
                        case IntegerArray: {
                            int[] intValues = (int[])section.getDefaultValue();
                            for (int i = 0; i < intValues.length; ++i) {
                                if (!section.getSeparteLines()) {
                                    writer.append(Integer.toString(intValues[i]) + ", ");
                                } else {
                                    this.appendLineWithOffset(writer, Integer.toString(intValues[i]), 1 + this.level);
                                    writer.newLine();
                                }
                                writer.flush();
                            }
                            break;
                        }
                        case LongArray: {
                            long[] longValues = (long[])section.getDefaultValue();
                            for (int i = 0; i < longValues.length; ++i) {
                                if (!section.getSeparteLines()) {
                                    writer.append(Long.toString(longValues[i]) + ", ");
                                } else {
                                    this.appendLineWithOffset(writer, Long.toString(longValues[i]), 1 + this.level);
                                    writer.newLine();
                                }
                                writer.flush();
                            }
                            break;
                        }
                        case FloatArray: {
                            float[] floatValues = (float[])section.getDefaultValue();
                            for (int i = 0; i < floatValues.length; ++i) {
                                if (!section.getSeparteLines()) {
                                    writer.append(Float.toString(floatValues[i]) + ", ");
                                } else {
                                    this.appendLineWithOffset(writer, Float.toString(floatValues[i]), 1 + this.level);
                                    writer.newLine();
                                }
                                writer.flush();
                            }
                            break;
                        }
                        case DoubleArray: {
                            double[] doubleValues = (double[])section.getDefaultValue();
                            for (int i = 0; i < doubleValues.length; ++i) {
                                if (!section.getSeparteLines()) {
                                    writer.append(Double.toString(doubleValues[i]) + ", ");
                                } else {
                                    this.appendLineWithOffset(writer, Double.toString(doubleValues[i]), 1 + this.level);
                                    writer.newLine();
                                }
                                writer.flush();
                            }
                            break;
                        }
                        case BooleanArray: {
                            boolean[] booleanValues = (boolean[])section.getDefaultValue();
                            for (int i = 0; i < booleanValues.length; ++i) {
                                if (!section.getSeparteLines()) {
                                    writer.append(Boolean.toString(booleanValues[i]) + ", ");
                                } else {
                                    this.appendLineWithOffset(writer, Boolean.toString(booleanValues[i]), 1 + this.level);
                                    writer.newLine();
                                }
                                writer.flush();
                            }
                            break;
                        }
                        case StringArray: {
                            String[] values = (String[])section.getDefaultValue();
                            for (int i = 0; i < values.length; ++i) {
                                if (!section.getSeparteLines()) {
                                    writer.append(values[i] + ", ");
                                } else {
                                    this.appendLineWithOffset(writer, values[i], 1 + this.level);
                                    writer.newLine();
                                }
                                writer.flush();
                            }
                            break;
                        }
                        default: {
                            log.error("Did something go wrong? Tried writing an Array while input wasn't an ArrayType");
                        }
                    }
                    if (section.getSeparteLines()) {
                        this.appendLineWithOffset(writer, "};", 1 + this.level);
                    } else {
                        writer.append("};");
                    }
                    writer.newLine();
                    writer.flush();
                } else {
                    this.appendLineWithOffset(writer, section.getSectionName() + ";{ ", 1 + this.level);
                    if (section.getSeparteLines()) {
                        writer.newLine();
                        this.appendLineWithOffset(writer, "};", this.level + 1);
                    } else {
                        writer.append("};");
                    }
                }
                writer.newLine();
                writer.flush();
            } else {
                this.appendLineWithOffset(writer, section.getSectionName() + "; ", 1 + this.level);
                if (section.getDefaultValue() != null) {
                    switch (sectionType) {
                        case Short: {
                            writer.append(Short.toString((Short)section.getDefaultValue()));
                            break;
                        }
                        case Integer: {
                            writer.append(Integer.toString((Integer)section.getDefaultValue()));
                            break;
                        }
                        case Long: {
                            writer.append(Long.toString((Long)section.getDefaultValue()));
                            break;
                        }
                        case Float: {
                            writer.append(Float.toString(((Float)section.getDefaultValue()).floatValue()));
                            break;
                        }
                        case Double: {
                            writer.append(Double.toString((Double)section.getDefaultValue()));
                            break;
                        }
                        case Boolean: {
                            writer.append(Boolean.toString((Boolean)section.getDefaultValue()));
                            break;
                        }
                        case String: {
                            writer.append((String)section.getDefaultValue());
                            break;
                        }
                        default: {
                            log.error("Did something go wrong? tried wrinting an primitive dataType while input wasn't an primitive dataType");
                        }
                    }
                    writer.newLine();
                    writer.flush();
                }
                writer.newLine();
                writer.flush();
            }
            if (this.getEnder() != null && !section.getHideOutLines()) {
                this.appendLineWithOffset(writer, section.getEnder(), 1 + this.level);
                writer.newLine();
            }
        }
        writer.flush();
    }

    protected final boolean readAndSaveValues(String fileName) throws IOException {
        ConfigSectionCollection superSectionCollection = this.superConfigSectionCollection;
        if (superSectionCollection != null) {
            while (superSectionCollection.superConfigSectionCollection != null) {
                superSectionCollection = superSectionCollection.superConfigSectionCollection;
            }
        } else {
            superSectionCollection = this;
        }
        if (superSectionCollection instanceof ConfigFile && ((ConfigFile)superSectionCollection).isConnected()) {
            return false;
        }
        if (this.superConfigSectionCollection != null) {
            log.error("Can't save Value's if ConfigSectionCollection is not an ConfigFile!");
            return false;
        }
        boolean hasChangedConfigSections = false;
        if (!InitConfigObjectManager.ConfigList.containsKey(fileName)) {
            InitConfigObjectManager.addConfigFile(fileName);
        }
        InitConfigObjectManager.Config config = InitConfigObjectManager.getConfigByName(fileName);
        ConfigFile configFile = ConfigHandler.getConfigFileFromName(fileName);
        boolean exist = ConfigHandler.getFileFromConfigFile(configFile).exists();
        Iterator<String> section = this.AbsoluteSubSectionMap.keySet().iterator();
        while (section.hasNext()) {
            ConfigSection currentSection = this.AbsoluteSubSectionMap.get(section.next());
            if (exist) {
                BufferedReader reader = ConfigHandler.getConfigFileFromName(fileName).getNewReader();
                InitConfigObjectManager.addField(config, currentSection.getSectionName(), this.getValue(currentSection.getSectionName(), reader));
                ConfigHandler.getConfigFileFromName(fileName).closeReader(reader);
            } else {
                InitConfigObjectManager.addField(config, currentSection.getSectionName(), this.getValue(currentSection.getSectionName(), null));
            }
            if (!currentSection.getChangedDefaultValue()) continue;
            hasChangedConfigSections = true;
        }
        return hasChangedConfigSections;
    }

    private final Object getValue(String sectionName, BufferedReader reader) throws IOException {
        String readedLine;
        ConfigSection configSection = this.getSubSection(sectionName);
        ConfigSection.SectionType sectiontype = configSection.getSectionType();
        StringBuilder finalString = new StringBuilder();
        if (reader == null) {
            return configSection.getDefaultValue();
        }
        block44: while ((readedLine = reader.readLine()) != null) {
            String[] value;
            if (!readedLine.contains(";") || !readedLine.trim().substring(0, readedLine.trim().indexOf(";")).equals(sectionName)) continue;
            Pattern p1 = sectiontype.isArray() ? Pattern.compile(";\\{") : Pattern.compile(";");
            for (String s1 : value = p1.split(readedLine)) {
                String[] s2;
                if (s1.length() <= 0 || s1.trim().startsWith(sectionName)) continue;
                StringBuilder SB1 = new StringBuilder();
                boolean hasEnder = false;
                Pattern p2 = Pattern.compile("\\s");
                for (String s3 : s2 = p2.split(s1)) {
                    if (sectiontype.isArray()) {
                        if (s3.length() > 2 && s3.endsWith("};")) {
                            SB1.append(s3.substring(0, s3.length() - 2));
                            hasEnder = true;
                        } else if (s3.endsWith("};")) {
                            hasEnder = true;
                        } else {
                            SB1.append(s3);
                        }
                    } else {
                        SB1.append(s3);
                    }
                    String values = SB1.toString();
                    if (sectiontype.isArray() && !hasEnder) {
                        StringBuilder SB2 = new StringBuilder();
                        block47: while ((readedLine = reader.readLine()) != null) {
                            String[] s5;
                            Pattern p3 = Pattern.compile("\\s");
                            for (String s6 : s5 = p3.split(readedLine)) {
                                if (s6.length() <= 0) continue;
                                if (s6.endsWith("};")) {
                                    SB2.append(s6.substring(0, readedLine.length() - 2));
                                    break block47;
                                }
                                SB2.append(s6);
                            }
                        }
                        values = SB2.toString();
                    }
                    if (values.length() <= 0) continue;
                    switch (sectiontype) {
                        case Short: {
                            short finalShortValue = configSection.getDefaultValue() != null ? (short)((Short)configSection.getDefaultValue()) : (short)-1;
                            try {
                                finalShortValue = Short.parseShort(values);
                            }
                            catch (Exception e) {
                                log.catching((Throwable)e);
                            }
                            return finalShortValue;
                        }
                        case Integer: {
                            int finalIntegerValue = configSection.getDefaultValue() != null ? (Integer)configSection.getDefaultValue() : -1;
                            try {
                                finalIntegerValue = Integer.parseInt(values);
                            }
                            catch (Exception e) {
                                log.catching((Throwable)e);
                            }
                            return finalIntegerValue;
                        }
                        case Long: {
                            long finalLongValue = configSection.getDefaultValue() != null ? (Long)configSection.getDefaultValue() : -1L;
                            try {
                                finalLongValue = Long.parseLong(values);
                            }
                            catch (Exception e) {
                                log.catching((Throwable)e);
                            }
                            return finalLongValue;
                        }
                        case Float: {
                            float finalFloatValue = configSection.getDefaultValue() != null ? ((Float)configSection.getDefaultValue()).floatValue() : -1.0f;
                            try {
                                finalFloatValue = Float.parseFloat(values);
                            }
                            catch (Exception e) {
                                log.catching((Throwable)e);
                            }
                            return Float.valueOf(finalFloatValue);
                        }
                        case Double: {
                            double finalDoubleValue = configSection.getDefaultValue() != null ? (Double)configSection.getDefaultValue() : -1.0;
                            try {
                                finalDoubleValue = Double.parseDouble(values);
                            }
                            catch (Exception e) {
                                log.catching((Throwable)e);
                            }
                            return finalDoubleValue;
                        }
                        case Boolean: {
                            boolean finalBooleanValue = configSection.getDefaultValue() != null ? (Boolean)configSection.getDefaultValue() : false;
                            try {
                                finalBooleanValue = Boolean.parseBoolean(values);
                            }
                            catch (Exception e) {
                                log.catching((Throwable)e);
                            }
                            return finalBooleanValue;
                        }
                        case String: {
                            String finalStringValue = configSection.getDefaultValue() != null ? (String)configSection.getDefaultValue() : null;
                            try {
                                finalStringValue = values;
                            }
                            catch (Exception e) {
                                log.catching((Throwable)e);
                            }
                            return finalStringValue;
                        }
                        case ShortArray: {
                            String[] shortS1;
                            HashMap<Integer, Short> finalShortArrayValueMap = new HashMap<Integer, Short>();
                            Pattern ShortP1 = Pattern.compile(",");
                            String[] stringArray = shortS1 = ShortP1.split(values);
                            int n = stringArray.length;
                            int n2 = 0;
                            if (n2 < n) {
                                String shortS2 = stringArray[n2];
                                if (shortS2.length() > 0) {
                                    try {
                                        finalShortArrayValueMap.put(finalShortArrayValueMap.size(), Short.parseShort(shortS2));
                                    }
                                    catch (Exception e) {
                                        log.catching((Throwable)e);
                                    }
                                }
                                if (finalShortArrayValueMap.isEmpty()) {
                                    return null;
                                }
                                short[] finalShortArrayValue = new short[finalShortArrayValueMap.size()];
                                for (int i = 0; i < finalShortArrayValue.length; ++i) {
                                    finalShortArrayValue[i] = (Short)finalShortArrayValueMap.get(i);
                                }
                                return finalShortArrayValue;
                            }
                        }
                        case IntegerArray: {
                            String[] intS1;
                            HashMap<Integer, Integer> finalIntArrayValueMap = new HashMap<Integer, Integer>();
                            Pattern intP1 = Pattern.compile(",");
                            String[] shortS2 = intS1 = intP1.split(values);
                            int finalShortArrayValue = shortS2.length;
                            int i = 0;
                            if (i < finalShortArrayValue) {
                                String intS2 = shortS2[i];
                                if (intS2.length() > 0) {
                                    try {
                                        finalIntArrayValueMap.put(finalIntArrayValueMap.size(), Integer.parseInt(intS2));
                                    }
                                    catch (Exception e) {
                                        log.catching((Throwable)e);
                                    }
                                }
                                if (finalIntArrayValueMap.isEmpty()) {
                                    return null;
                                }
                                int[] finalIntArrayValue = new int[finalIntArrayValueMap.size()];
                                for (int i2 = 0; i2 < finalIntArrayValue.length; ++i2) {
                                    finalIntArrayValue[i2] = (Integer)finalIntArrayValueMap.get(i2);
                                }
                                return finalIntArrayValue;
                            }
                        }
                        case LongArray: {
                            String[] longS1;
                            HashMap<Integer, Long> finalLongArrayValueMap = new HashMap<Integer, Long>();
                            Pattern longP1 = Pattern.compile(",");
                            String[] intS2 = longS1 = longP1.split(values);
                            int finalIntArrayValue = intS2.length;
                            int i2 = 0;
                            if (i2 < finalIntArrayValue) {
                                String longS2 = intS2[i2];
                                if (longS2.length() > 0) {
                                    try {
                                        finalLongArrayValueMap.put(finalLongArrayValueMap.size(), Long.parseLong(longS2));
                                    }
                                    catch (Exception e) {
                                        log.catching((Throwable)e);
                                    }
                                }
                                if (finalLongArrayValueMap.isEmpty()) {
                                    return null;
                                }
                                long[] finalLongArrayValue = new long[finalLongArrayValueMap.size()];
                                for (int i = 0; i < finalLongArrayValue.length; ++i) {
                                    finalLongArrayValue[i] = (Long)finalLongArrayValueMap.get(i);
                                }
                                return finalLongArrayValue;
                            }
                        }
                        case FloatArray: {
                            String[] floatS1;
                            HashMap<Integer, Float> finalFloatArrayValueMap = new HashMap<Integer, Float>();
                            Pattern floatP1 = Pattern.compile(",");
                            String[] longS2 = floatS1 = floatP1.split(values);
                            int finalLongArrayValue = longS2.length;
                            int i = 0;
                            if (i < finalLongArrayValue) {
                                String floatS2 = longS2[i];
                                if (floatS2.length() > 0) {
                                    try {
                                        finalFloatArrayValueMap.put(finalFloatArrayValueMap.size(), Float.valueOf(Float.parseFloat(floatS2)));
                                    }
                                    catch (Exception e) {
                                        log.catching((Throwable)e);
                                    }
                                }
                                if (finalFloatArrayValueMap.isEmpty()) {
                                    return null;
                                }
                                float[] finalFloatArrayValue = new float[finalFloatArrayValueMap.size()];
                                for (int i3 = 0; i3 < finalFloatArrayValue.length; ++i3) {
                                    finalFloatArrayValue[i3] = ((Float)finalFloatArrayValueMap.get(i3)).floatValue();
                                }
                                return finalFloatArrayValue;
                            }
                        }
                        case DoubleArray: {
                            String[] doubleS1;
                            HashMap<Integer, Double> finalDoubleArrayValueMap = new HashMap<Integer, Double>();
                            Pattern doubleP1 = Pattern.compile(",");
                            String[] floatS2 = doubleS1 = doubleP1.split(values);
                            int finalFloatArrayValue = floatS2.length;
                            int i3 = 0;
                            if (i3 < finalFloatArrayValue) {
                                String doubleS2 = floatS2[i3];
                                if (doubleS2.length() > 0) {
                                    try {
                                        finalDoubleArrayValueMap.put(finalDoubleArrayValueMap.size(), Double.parseDouble(doubleS2));
                                    }
                                    catch (Exception e) {
                                        log.catching((Throwable)e);
                                    }
                                }
                                if (finalDoubleArrayValueMap.isEmpty()) {
                                    return null;
                                }
                                double[] finalDoubleArrayValue = new double[finalDoubleArrayValueMap.size()];
                                for (int i = 0; i < finalDoubleArrayValue.length; ++i) {
                                    finalDoubleArrayValue[i] = (Double)finalDoubleArrayValueMap.get(i);
                                }
                                return finalDoubleArrayValue;
                            }
                        }
                        case BooleanArray: {
                            String[] booleanS1;
                            HashMap<Integer, Boolean> finalBooleanArrayValueMap = new HashMap<Integer, Boolean>();
                            Pattern booleanP1 = Pattern.compile(",");
                            String[] doubleS2 = booleanS1 = booleanP1.split(values);
                            int finalDoubleArrayValue = doubleS2.length;
                            int i = 0;
                            if (i < finalDoubleArrayValue) {
                                String booleanS2 = doubleS2[i];
                                if (booleanS2.length() > 0) {
                                    try {
                                        finalBooleanArrayValueMap.put(finalBooleanArrayValueMap.size(), Boolean.parseBoolean(booleanS2));
                                    }
                                    catch (Exception e) {
                                        log.catching((Throwable)e);
                                    }
                                }
                                if (finalBooleanArrayValueMap.isEmpty()) {
                                    return null;
                                }
                                boolean[] finalDoubleArrayValue2 = new boolean[finalBooleanArrayValueMap.size()];
                                for (int i4 = 0; i4 < finalDoubleArrayValue2.length; ++i4) {
                                    finalDoubleArrayValue2[i4] = (Boolean)finalBooleanArrayValueMap.get(i4);
                                }
                                return finalDoubleArrayValue2;
                            }
                        }
                        case StringArray: {
                            String[] stringS1;
                            HashMap<Integer, String> finalStringArrayValueMap = new HashMap<Integer, String>();
                            Pattern stringP1 = Pattern.compile(",");
                            String[] stringArray = stringS1 = stringP1.split(values);
                            int n = stringArray.length;
                            int n3 = 0;
                            if (n3 >= n) break;
                            String stringS2 = stringArray[n3];
                            if (stringS2.length() > 0) {
                                try {
                                    finalStringArrayValueMap.put(finalStringArrayValueMap.size(), stringS2);
                                }
                                catch (Exception e) {
                                    log.catching((Throwable)e);
                                }
                            }
                            if (finalStringArrayValueMap.isEmpty()) {
                                return null;
                            }
                            String[] finalStringArrayValue = new String[finalStringArrayValueMap.size()];
                            for (int i = 0; i < finalStringArrayValue.length; ++i) {
                                finalStringArrayValue[i] = (String)finalStringArrayValueMap.get(i);
                            }
                            return finalStringArrayValue;
                        }
                    }
                    log.error("Did something go wrong? An Error ocured while trying to retrieve Value from: " + sectionName + "!");
                    log.info("Its recommended to check/regenerate the configFile while this might be caused by a faulty input.");
                    break block44;
                }
            }
        }
        log.error("Couldn't find ConfigSection " + sectionName + " in the configFile!, returning Default value instead.");
        log.info("Its recommended to check/regenerate the configFile while this might be caused by a faulty input.");
        return configSection.getDefaultValue();
    }
}

