/*
 * Decompiled with CFR 0.152.
 */
package com.n247s.N2ConfigApi.api.core;

import com.n247s.N2ConfigApi.api.N2ConfigApi;
import com.n247s.N2ConfigApi.api.core.ConfigHandler;
import com.n247s.N2ConfigApi.api.core.ConfigSection;
import com.n247s.N2ConfigApi.api.core.ConfigSectionCollection;
import com.n247s.N2ConfigApi.api.core.InitConfigObjectManager;
import com.n247s.N2ConfigApi.api.networking.N2ConfigApiMessageHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import org.apache.logging.log4j.Logger;

public abstract class ConfigFile
extends ConfigSectionCollection
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -864529735488611537L;
    private static final Logger log = N2ConfigApi.log;
    private String fileName;
    private ConfigHandler.ProxySide proxySide;

    private ConfigFile(String sectionName, String[] description, String fileName, ConfigHandler.ProxySide proxySide, boolean setExtraSpaces, boolean isVirtual) {
        super(sectionName, description, setExtraSpaces);
        this.fileName = fileName;
        this.proxySide = proxySide;
    }

    public ConfigFile(String fileName, ConfigHandler.ProxySide proxySide) {
        this("defaultSection", null, fileName, proxySide, true, false);
    }

    protected final void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public abstract void generateFile();

    public abstract boolean getPermission(EntityPlayerMP var1);

    public final void writeAllSections() {
        if (this.isConnected()) {
            return;
        }
        try {
            BufferedWriter writer = this.getNewWriter();
            super.writeAllSections(writer);
            this.closeWriter(writer);
        }
        catch (Exception e) {
            log.catching((Throwable)e);
        }
    }

    public final void writeSection(String sectionName) {
        if (this.isConnected()) {
            return;
        }
        try {
            BufferedWriter writer = this.getNewWriter();
            super.writeSubSection(writer, sectionName);
            this.closeWriter(writer);
        }
        catch (Exception e) {
            log.catching((Throwable)e);
        }
    }

    public final void regenerateConfigFile(List<String> invalidSectionNames) {
        if (this.isConnected()) {
            return;
        }
        if (invalidSectionNames != null && !invalidSectionNames.isEmpty()) {
            try {
                File tempFile = ConfigHandler.generateSingleFileFromConfigFile(this, ConfigHandler.FileType.Temp, N2ConfigApi.getTempDir(ConfigHandler.getFileFromConfigFile(this).getParentFile()));
                File configFile = ConfigHandler.generateSingleFileFromConfigFile(this, ConfigHandler.FileType.Original, ConfigHandler.getFileFromConfigFile(this).getParentFile());
                if (tempFile == null || configFile == null) {
                    log.error("Couldnt regenerate ConfigFile: " + invalidSectionNames);
                    return;
                }
                BufferedWriter writer = this.getNewWriter();
                BufferedReader reader = new BufferedReader(new FileReader(tempFile));
                int sectionCount = 0;
                sectionCount = super.regenConfigChapter(writer, reader, invalidSectionNames);
                if (sectionCount != this.AbsoluteSubSectionMap.size()) {
                    log.error("Couldn't resolve the sections in: " + configFile.getPath());
                    log.error("recreating this config file, all data will be restored to its default Value");
                    File backUpFile = ConfigHandler.generateSingleFileFromConfigFile(this, ConfigHandler.FileType.BackUp, N2ConfigApi.getTempDir(ConfigHandler.getFileFromConfigFile(this).getParentFile()));
                    ConfigHandler.copyFile(tempFile, backUpFile);
                    ConfigHandler.generateSingleFileFromConfigFile(this, ConfigHandler.FileType.Original, ConfigHandler.getFileFromConfigFile(this).getParentFile());
                }
                this.closeWriter(writer);
                tempFile.delete();
                this.closeReader(reader);
            }
            catch (Exception e) {
                log.catching((Throwable)e);
            }
        }
    }

    public final List checkConfigFile() {
        if (this.isConnected()) {
            return null;
        }
        ArrayList invalidSectionList = new ArrayList();
        Iterator section = this.AbsoluteSubSectionMap.keySet().iterator();
        while (section.hasNext()) {
            invalidSectionList.add(section.next());
        }
        try {
            String readedLine;
            BufferedReader reader = new BufferedReader(new FileReader(ConfigHandler.getFileFromConfigFile(this)));
            while ((readedLine = reader.readLine()) != null) {
                if (readedLine.startsWith("#") || readedLine.isEmpty() || !readedLine.contains(";")) continue;
                for (int i = 0; i < invalidSectionList.size(); ++i) {
                    String subString = readedLine.replaceAll("[\\s.*]", "");
                    char firstLetter = subString.charAt(0);
                    try {
                        if (!invalidSectionList.contains(readedLine.substring(readedLine.indexOf(firstLetter), readedLine.indexOf(";")))) continue;
                        invalidSectionList.remove(readedLine.substring(readedLine.indexOf(firstLetter), readedLine.indexOf(";")));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            reader.close();
        }
        catch (Exception e) {
            log.catching((Throwable)e);
        }
        if (!invalidSectionList.isEmpty()) {
            for (int i = 0; i < invalidSectionList.size(); ++i) {
                if (((ConfigSection)this.AbsoluteSubSectionMap.get(invalidSectionList.get(i))).getSectionType() == ConfigSection.SectionType.Text && ((ConfigSection)this.AbsoluteSubSectionMap.get(invalidSectionList.get(i))).getSectionType() == ConfigSection.SectionType.SectionHead) continue;
                log.error("Missing Section: " + (String)invalidSectionList.get(i) + " in " + ConfigHandler.getFileFromConfigFile(this).getName());
            }
            return invalidSectionList;
        }
        return null;
    }

    public final List<String> getChangedSections() {
        ArrayList<String> changedSections = new ArrayList<String>();
        Iterator section = this.AbsoluteSubSectionMap.keySet().iterator();
        while (section.hasNext()) {
            ConfigSection currentSection = this.getSubSection((String)section.next());
            if (!currentSection.getChangedDefaultValue()) continue;
            changedSections.add((String)section.next());
        }
        if (changedSections.isEmpty()) {
            return null;
        }
        return changedSections;
    }

    public final void readAndSaveConfigValues() {
        if (this.isConnected()) {
            return;
        }
        if (ConfigHandler.getConfigFileFromName(this.fileName) == null) {
            return;
        }
        if (!this.proxySide.isEffectiveSide(FMLCommonHandler.instance().getEffectiveSide())) {
            return;
        }
        try {
            if (super.readAndSaveValues(this.fileName) && FMLCommonHandler.instance().getEffectiveSide().isServer() && this.proxySide.isCommon()) {
                ConfigHandler.syncConfigFile(this);
            }
        }
        catch (Exception e) {
            log.catching((Throwable)e);
        }
    }

    public final Object getValue(String sectionName) {
        if (InitConfigObjectManager.getConfigByName(this.fileName) != null) {
            if (this.getSubSection(sectionName) != null) {
                return InitConfigObjectManager.getField(InitConfigObjectManager.getConfigByName(this.fileName), sectionName);
            }
            log.error("Couldn't find " + sectionName + " in " + this.fileName);
            return null;
        }
        return this.getSubSection(sectionName).getDefaultValue();
    }

    public final void setValue(String sectionName, Object newValue) {
        if (InitConfigObjectManager.getConfigByName(this.fileName) == null) {
            InitConfigObjectManager.addConfigFile(this.fileName);
        }
        if (this.getSubSection(sectionName) != null) {
            InitConfigObjectManager.changeFieldValue(InitConfigObjectManager.getConfigByName(this.fileName), sectionName, newValue);
        } else {
            log.error("Couldn't find " + sectionName + " in " + this.fileName);
        }
    }

    protected final ConfigFile CloneConfigurationFileInstance() throws CloneNotSupportedException {
        return (ConfigFile)super.clone();
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final boolean getIsWritten() {
        if (this.isConnected()) {
            return false;
        }
        try {
            BufferedReader reader = this.getNewReader();
            String readedLine = reader.readLine();
            if (readedLine != null) {
                this.closeReader(reader);
                return true;
            }
            this.closeReader(reader);
        }
        catch (Exception e) {
            log.catching((Throwable)e);
        }
        return false;
    }

    public final ConfigHandler.ProxySide getProxySide() {
        return this.proxySide;
    }

    public final BufferedWriter getNewWriter() throws IOException {
        if (this.isConnected()) {
            return null;
        }
        return new BufferedWriter(new FileWriter(ConfigHandler.getFileFromConfigFile(this)));
    }

    public final void closeWriter(BufferedWriter writer) throws IOException {
        writer.flush();
        writer.close();
    }

    public final BufferedReader getNewReader() throws IOException {
        if (this.isConnected()) {
            return null;
        }
        return new BufferedReader(new FileReader(ConfigHandler.getFileFromConfigFile(this)));
    }

    public final void closeReader(BufferedReader reader) throws IOException {
        reader.close();
    }

    public final List<ByteBuf> writeFullConfigFileToBuff(ByteBufOutputStream stream) throws IOException {
        ArrayList<ByteBuf> byteBufList = new ArrayList<ByteBuf>();
        File parentDirectory = ConfigHandler.getFileFromConfigFile(this).getParentFile();
        stream.writeUTF(N2ConfigApi.getFileIDFromFileDir(parentDirectory));
        stream.writeUTF(parentDirectory.toURI().getPath().substring(N2ConfigApi.getMCMainDir().toURI().getPath().length(), parentDirectory.toURI().getPath().length()));
        stream.writeUTF(this.fileName);
        int subSectionCount = this.getAbsoluteSubSectionCount();
        stream.writeInt(0);
        this.writeFullSectionToByteBuf(stream, null);
        for (int i = 0; i < subSectionCount; ++i) {
            ConfigSection currentSection = this.getConfigSectionAtAbsoluteIndex(i);
            currentSection.writeFullSectionToByteBuf(stream, this.getValue(currentSection.getSectionName()));
            stream.flush();
            if (stream.buffer().capacity() <= 25600) continue;
            stream.writeUTF(N2ConfigApiMessageHandler.getSignature(2));
            stream.flush();
            byteBufList.add(stream.buffer().copy());
            stream.buffer().clear();
            stream.writeUTF(N2ConfigApiMessageHandler.getSignature(5));
            stream.writeUTF(this.fileName);
            stream.writeInt(i + 1);
            stream.flush();
        }
        stream.writeUTF(N2ConfigApiMessageHandler.getSignature(1));
        stream.writeInt(subSectionCount);
        stream.flush();
        byteBufList.add(stream.buffer());
        return byteBufList;
    }

    public final List<ByteBuf> writeValuesToBuff(ByteBufOutputStream stream) throws IOException {
        ArrayList<ByteBuf> byteBufList = new ArrayList<ByteBuf>();
        stream.writeUTF(N2ConfigApiMessageHandler.getSignature(6));
        stream.writeUTF(this.fileName);
        int subSectionCount = this.getAbsoluteSubSectionCount();
        for (int i = 0; i < subSectionCount; ++i) {
            ConfigSection section = this.getConfigSectionAtAbsoluteIndex(i);
            section.WriteSectionValuesToByteBuf(stream, this.getValue(section.getSectionName()));
            stream.flush();
            if (stream.buffer().capacity() <= 25600 || i >= subSectionCount - 1) continue;
            stream.writeUTF(N2ConfigApiMessageHandler.getSignature(2));
            stream.flush();
            byteBufList.add(stream.buffer().copy());
            stream.buffer().clear();
            stream.writeUTF(N2ConfigApiMessageHandler.getSignature(3));
            stream.writeUTF(N2ConfigApiMessageHandler.getSignature(6));
            stream.writeUTF(this.fileName);
            stream.flush();
        }
        return byteBufList;
    }

    public final boolean createFullConfigFileFromBuff(ByteBufInputStream stream, InitConfigObjectManager.Config config) throws IOException {
        int i;
        int subSectionStartIndex = stream.readInt();
        ConfigSectionCollection sectionCollection = this;
        for (i = subSectionStartIndex; i > 0; --i) {
            ConfigSection section = this.getConfigSectionAtAbsoluteIndex(i);
            if (section.getSectionType() != ConfigSection.SectionType.SectionHead || i - this.getAbsoluteConfigSectionIndex(section.getSectionName()) > (Integer)section.getDefaultValue()) continue;
            sectionCollection = (ConfigSectionCollection)section;
        }
        String currentString;
        while (!(currentString = stream.readUTF()).equals(N2ConfigApiMessageHandler.getSignature(2))) {
            if (currentString.equals(N2ConfigApiMessageHandler.getSignature(1))) {
                if (this.getAbsoluteSubSectionCount() != stream.readInt()) {
                    log.catching((Throwable)new Exception("Found end signature while the total SectionCount isn't equal to the sended SectionCount!"));
                    return false;
                }
                return true;
            }
            if (!this.createSection(stream, config, currentString, sectionCollection, subSectionStartIndex - i)) {
                return false;
            }
            this.setChangedSections(false);
        }
        return true;
    }

    public final int createValuesFromByteBuf(ByteBufInputStream stream) throws IOException {
        if (!InitConfigObjectManager.ConfigList.containsKey(this.fileName)) {
            InitConfigObjectManager.addConfigFile(this.fileName);
        }
        InitConfigObjectManager.Config config = InitConfigObjectManager.getConfigByName(this.fileName);
        String currentString;
        while (!(currentString = stream.readUTF()).equals(N2ConfigApiMessageHandler.getSignature(6))) {
            if (currentString.equals(N2ConfigApiMessageHandler.getSignature(1))) {
                return 1;
            }
            if (currentString.equals(N2ConfigApiMessageHandler.getSignature(2))) {
                return 2;
            }
            ConfigSection section = this.getSubSection(currentString);
            if (section != null) {
                section.createSectionValuesFromBuf(stream, config);
                continue;
            }
            log.catching((Throwable)new Exception("Couldn't find ConfigSection " + currentString + " in ConfigFile " + this.fileName));
        }
        return 0;
    }

    private boolean createSection(ByteBufInputStream stream, InitConfigObjectManager.Config config, String currentString, ConfigSectionCollection superSectionCollection, int subSectionIndex) throws IOException {
        ConfigSection.SectionType sectionType = ConfigSection.SectionType.values()[stream.readInt()];
        ConfigSection section = new ConfigSection(currentString, null, null, sectionType);
        section.createFullSectionFromBuf(stream, config);
        if (section.getSectionType() == ConfigSection.SectionType.SectionHead) {
            int collectionSize = (Integer)section.getDefaultValue();
            ConfigSectionCollection sectionCollection = new ConfigSectionCollection(section.getSectionName(), null, false);
            sectionCollection.setDefaultValue(collectionSize);
            for (int i = 0; i < collectionSize - subSectionIndex + 1; ++i) {
                currentString = stream.readUTF();
                if (this.createSection(stream, config, currentString, sectionCollection, i)) continue;
                superSectionCollection.addNewSection(sectionCollection);
                return false;
            }
            sectionCollection.setChangedSections(false);
            superSectionCollection.addNewSection(sectionCollection);
            return true;
        }
        superSectionCollection.addNewSection(section);
        return true;
    }

    public boolean isConnected() {
        return FMLCommonHandler.instance().getEffectiveSide().isClient() && !Minecraft.func_71410_x().func_71356_B();
    }
}

