/*
 * Decompiled with CFR 0.152.
 */
package blockrenderer6343.integration.gregtech;

import blockrenderer6343.client.world.DummyWorld;
import blockrenderer6343.integration.gregtech.GTNEIMultiblockHandler;
import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.IStructureElementCheckOnly;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.multitileentity.multiblock.casing.Glasses;
import gregtech.api.util.GTStructureUtility;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class StructureHacks {
    private static final int MAX_TIERS_TO_CHECK = 50;
    private static final List<String> TIERED_ELEMENTS;
    private static final MethodHandle LAZY_ELEMENT_GET;
    private static final String LAZY_ELEMENT = "com.gtnewhorizon.structurelib.structure.LazyStructureElement";
    private static final ItemStack HOLO_STACK;
    static List<Item> validGlass;

    @Nullable
    static Iterable<ItemStack> getStacksForElement(IConstructable multi, IStructureElement<IConstructable> element, AutoPlaceEnvironment env) {
        IStructureElement.BlocksToPlace blocks;
        String name;
        if (validGlass == null) {
            validGlass = StructureHacks.getGlasses(env);
        }
        if ((name = element.getClass().getName()).equals(LAZY_ELEMENT)) {
            element = StructureHacks.getUnderlyingElement(multi, element);
            name = element.getClass().getName();
        }
        if ((blocks = element.getBlocksToPlace((Object)multi, (World)DummyWorld.INSTANCE, 0, 0, 0, HOLO_STACK, env)) == null) {
            return Collections.emptyList();
        }
        if (TIERED_ELEMENTS.contains(name)) {
            return StructureHacks.extractTieredBlocks(multi, element, env);
        }
        return blocks.getStacks();
    }

    private static ObjectSet<ItemStack> extractTieredBlocks(IConstructable multi, IStructureElement<IConstructable> element, AutoPlaceEnvironment env) {
        ObjectOpenHashSet result = new ObjectOpenHashSet();
        int tier = 0;
        LongOpenHashSet addedItemHashes = new LongOpenHashSet();
        do {
            ItemStack firstStack;
            Iterator iterator;
            StructureHacks.HOLO_STACK.field_77994_a = tier++ + 1;
            IStructureElement.BlocksToPlace toPlace = element.getBlocksToPlace((Object)multi, (World)DummyWorld.INSTANCE, 0, 0, 0, HOLO_STACK, env);
            if (toPlace == null || toPlace.getStacks() == null || !(iterator = toPlace.getStacks().iterator()).hasNext() || (firstStack = (ItemStack)iterator.next()) == null || firstStack.func_77973_b() == null || !addedItemHashes.add(StructureHacks.hashStack(firstStack))) break;
            StructureHacks.addWithSize((ObjectSet<ItemStack>)result, firstStack, tier);
            while (iterator.hasNext()) {
                ItemStack stack = (ItemStack)iterator.next();
                if (!addedItemHashes.add(StructureHacks.hashStack(stack))) continue;
                StructureHacks.addWithSize((ObjectSet<ItemStack>)result, stack, tier);
            }
        } while (tier < 50);
        StructureHacks.HOLO_STACK.field_77994_a = 1;
        return result;
    }

    private static void addWithSize(ObjectSet<ItemStack> set, ItemStack stack, int size) {
        if (!GTNEIMultiblockHandler.isValidItem(stack.func_77973_b())) {
            return;
        }
        ItemStack copy = stack.func_77946_l();
        copy.field_77994_a = size;
        set.add((Object)copy);
    }

    private static long hashStack(ItemStack stack) {
        return (long)stack.func_77973_b().hashCode() * 31L + (long)stack.func_77960_j() * 31L;
    }

    private static List<Item> getGlasses(AutoPlaceEnvironment env) {
        ArrayList<Item> result = new ArrayList<Item>();
        Iterable stacks = Glasses.chainAllGlasses().getBlocksToPlace(null, (World)DummyWorld.INSTANCE, 0, 0, 0, HOLO_STACK, env).getStacks();
        if (stacks == null) {
            return result;
        }
        stacks.forEach(stack -> result.add(stack.func_77973_b()));
        return result;
    }

    private static IStructureElement<IConstructable> getUnderlyingElement(IConstructable multi, IStructureElement<?> element) {
        try {
            return (IStructureElement)LAZY_ELEMENT_GET.invokeWithArguments(element, multi);
        }
        catch (Throwable ignored) {
            throw new RuntimeException();
        }
    }

    static {
        HOLO_STACK = new ItemStack(StructureLibAPI.getDefaultHologramItem());
        String coil = GTStructureUtility.ofCoil((a, c) -> true, b -> HeatingCoilLevel.LV).getClass().getName();
        String tiered = StructureUtility.ofBlocksTiered((a, b) -> 0, null, Collections.emptyList(), (c, d) -> {}, e -> -1).getClass().getName();
        IStructureElementCheckOnly elem = StructureUtility.ofBlocksTiered((a, b) -> 0, null, (c, d) -> {}, e -> -1);
        String tieredCheck = elem.getClass().getName();
        String channel = StructureUtility.withChannel((String)"blah", (IStructureElement)elem).getClass().getName();
        TIERED_ELEMENTS = ImmutableList.of((Object)coil, (Object)tiered, (Object)tieredCheck, (Object)channel);
        try {
            Method method = Class.forName(LAZY_ELEMENT).getDeclaredMethod("get", Object.class);
            method.setAccessible(true);
            LAZY_ELEMENT_GET = MethodHandles.lookup().unreflect(method);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e2) {
            throw new RuntimeException(e2);
        }
    }
}

